/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test;

import com.acunia.wonka.test.Calculator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CalculatorApplication
extends Frame
implements ActionListener,
Runnable {
    private Calculator calculator;
    private Button one;
    private Button two;
    private Button three;
    private Button four;
    private Button five;
    private Button six;
    private Button seven;
    private Button eight;
    private Button nine;
    private Button zero;
    private Button plus;
    private Button subtract;
    private Button multiply;
    private Button divide;
    private Button dot;
    private Button enter;
    private Button invert;
    private Button clear;
    private Button reciprocal;
    private Button info;
    private Label display;
    private Thread runner;
    private boolean run;
    private Runtime rt = Runtime.getRuntime();
    private Font displayFont;
    private static final int GAP = 6;
    private static boolean toggle = false;
    private static String[] infoMessage = new String[]{"Acunia drives telematics       ", "The quick brown fox jumps over the lazy dog", "All work and no play makes Jack a dull boy", "The silver swan    Who living had no note    When death approached unlocked her silent throat:    \"Farewell all joys,    Oh death come close mine eyes    More geese than swans now live, more fools than wise.\"", "Have you nothing better to do with your time?", "It'll fall off if you keep playing with it like that", "Don't you ever get fed up with these stupid scrolling messages?"};
    private static int messageNumber = 0;
    private static final int FONT_SIZE = 24;
    private static final String FONT_NAME = "Dialog";
    private static final long DOUBLE_CLICK_MILLIS = 500L;
    private long clear_clicked = System.currentTimeMillis();
    private long last_clear_clicked;
    static /* synthetic */ Class class$com$acunia$wonka$test$CalculatorApplication;

    public CalculatorApplication(String label) {
        super(label);
        this.init();
        this.setSize(400, 234);
        this.setVisible(true);
    }

    public CalculatorApplication() {
        this("Wonka Test Calculator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CalculatorApplication calculatorApplication = new CalculatorApplication("SmartCalculator");
        Class clazz = class$com$acunia$wonka$test$CalculatorApplication == null ? (class$com$acunia$wonka$test$CalculatorApplication = CalculatorApplication.class$("com.acunia.wonka.test.CalculatorApplication")) : class$com$acunia$wonka$test$CalculatorApplication;
        synchronized (clazz) {
            try {
                (class$com$acunia$wonka$test$CalculatorApplication == null ? (class$com$acunia$wonka$test$CalculatorApplication = CalculatorApplication.class$("com.acunia.wonka.test.CalculatorApplication")) : class$com$acunia$wonka$test$CalculatorApplication).wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void init() {
        Color w = Color.white;
        Color d = Color.darkGray;
        this.calculator = new Calculator();
        this.displayFont = new Font(FONT_NAME, 1, 24);
        this.setFont(this.displayFont);
        this.setBackground(Color.black);
        Panel buttons = new Panel();
        buttons.setLayout(new GridLayout(5, 4, 6, 6));
        this.clear = new Button("C");
        buttons.add(this.clear);
        this.clear.setBackground(d);
        this.clear.setForeground(Color.red);
        this.clear.addActionListener(this);
        this.info = new Button("?");
        buttons.add(this.info);
        this.info.setBackground(d);
        this.info.setForeground(w);
        this.info.addActionListener(this);
        this.reciprocal = new Button("1/x");
        buttons.add(this.reciprocal);
        this.reciprocal.setBackground(d);
        this.reciprocal.setForeground(Color.yellow);
        this.reciprocal.addActionListener(this);
        this.invert = new Button("+/-");
        buttons.add(this.invert);
        this.invert.setBackground(d);
        this.invert.setForeground(Color.yellow);
        this.invert.addActionListener(this);
        this.seven = new Button("7");
        buttons.add(this.seven);
        this.seven.setBackground(w);
        this.seven.addActionListener(this);
        this.eight = new Button("8");
        buttons.add(this.eight);
        this.eight.setBackground(w);
        this.eight.addActionListener(this);
        this.nine = new Button("9");
        buttons.add(this.nine);
        this.nine.setBackground(w);
        this.nine.addActionListener(this);
        this.divide = new Button("/");
        buttons.add(this.divide);
        this.divide.setBackground(d);
        this.divide.setForeground(Color.orange);
        this.divide.addActionListener(this);
        this.four = new Button("4");
        buttons.add(this.four);
        this.four.setBackground(w);
        this.four.addActionListener(this);
        this.five = new Button("5");
        buttons.add(this.five);
        this.five.setBackground(w);
        this.five.addActionListener(this);
        this.six = new Button("6");
        buttons.add(this.six);
        this.six.setBackground(w);
        this.six.addActionListener(this);
        this.multiply = new Button("*");
        buttons.add(this.multiply);
        this.multiply.setBackground(d);
        this.multiply.setForeground(Color.orange);
        this.multiply.addActionListener(this);
        this.one = new Button("1");
        buttons.add(this.one);
        this.one.setBackground(w);
        this.one.addActionListener(this);
        this.two = new Button("2");
        buttons.add(this.two);
        this.two.setBackground(w);
        this.two.addActionListener(this);
        this.three = new Button("3");
        buttons.add(this.three);
        this.three.setBackground(w);
        this.three.addActionListener(this);
        this.subtract = new Button("-");
        buttons.add(this.subtract);
        this.subtract.setBackground(d);
        this.subtract.setForeground(Color.orange);
        this.subtract.addActionListener(this);
        this.zero = new Button("0");
        buttons.add(this.zero);
        this.zero.setBackground(w);
        this.zero.addActionListener(this);
        this.dot = new Button(".");
        buttons.add(this.dot);
        this.dot.setBackground(w);
        this.dot.addActionListener(this);
        this.enter = new Button("=");
        buttons.add(this.enter);
        this.enter.setBackground(d);
        this.enter.setForeground(Color.red);
        this.enter.addActionListener(this);
        this.plus = new Button("+");
        buttons.add(this.plus);
        this.plus.setBackground(d);
        this.plus.setForeground(Color.orange);
        this.plus.addActionListener(this);
        Panel top = new Panel();
        top.setLayout(new GridLayout(1, 1, 6, 6));
        this.display = new Label("", 2);
        top.add(this.display);
        this.display.setFont(new Font("Courier", 1, 28));
        this.display.setBackground(Color.black);
        this.display.setForeground(Color.green);
        this.setLayout(new BorderLayout(6, 6));
        this.add("North", top);
        this.add("Center", buttons);
        this.updateDisplay();
    }

    private boolean updateDisplay() {
        String str;
        boolean isInteger;
        double acc = this.calculator.accumulator();
        boolean bl = isInteger = (double)((int)acc) == acc;
        if (!isInteger) {
            str = new Float(acc).toString();
        } else {
            int zeros = this.calculator.trailingDigits();
            str = new Integer((int)acc).toString();
            if (zeros > 0) {
                str = str + ".";
                while (--zeros > 0) {
                    str = str + "0";
                }
            }
        }
        this.display.setText(str);
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        this.hideInfoMessage();
        if (event.getSource() == this.one) {
            this.calculator.one();
            this.updateDisplay();
        } else if (event.getSource() == this.two) {
            this.calculator.two();
            this.updateDisplay();
        } else if (event.getSource() == this.two) {
            this.calculator.two();
            this.updateDisplay();
        } else if (event.getSource() == this.three) {
            this.calculator.three();
            this.updateDisplay();
        } else if (event.getSource() == this.four) {
            this.calculator.four();
            this.updateDisplay();
        } else if (event.getSource() == this.five) {
            this.calculator.five();
            this.updateDisplay();
        } else if (event.getSource() == this.six) {
            this.calculator.six();
            this.updateDisplay();
        } else if (event.getSource() == this.seven) {
            this.calculator.seven();
            this.updateDisplay();
        } else if (event.getSource() == this.eight) {
            this.calculator.eight();
            this.updateDisplay();
        } else if (event.getSource() == this.nine) {
            this.calculator.nine();
            this.updateDisplay();
        } else if (event.getSource() == this.zero) {
            this.calculator.zero();
            this.updateDisplay();
        } else if (event.getSource() == this.dot) {
            this.calculator.dot();
            this.updateDisplay();
        } else if (event.getSource() == this.enter) {
            this.calculator.enter();
            this.updateDisplay();
        } else if (event.getSource() == this.plus) {
            this.calculator.plusOperator();
            this.updateDisplay();
        } else if (event.getSource() == this.subtract) {
            this.calculator.subtractOperator();
            this.updateDisplay();
        } else if (event.getSource() == this.multiply) {
            this.calculator.multiplyOperator();
            this.updateDisplay();
        } else if (event.getSource() == this.divide) {
            this.calculator.divideOperator();
            this.updateDisplay();
        } else if (event.getSource() == this.clear) {
            this.last_clear_clicked = this.clear_clicked;
            this.clear_clicked = System.currentTimeMillis();
            if (this.clear_clicked - this.last_clear_clicked < 500L) {
                System.exit(0);
            }
            this.calculator.clear();
            this.updateDisplay();
        } else if (event.getSource() == this.invert) {
            this.calculator.invert();
            this.updateDisplay();
        } else if (event.getSource() == this.reciprocal) {
            this.calculator.reciprocal();
            this.updateDisplay();
        } else if (event.getSource() == this.info) {
            this.showInfoMessage();
        }
    }

    private void showInfoMessage() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.setPriority(8);
            this.run = true;
            this.runner.start();
        }
    }

    private void hideInfoMessage() {
        if (this.runner != null) {
            this.run = false;
            this.runner = null;
            this.updateDisplay();
        }
    }

    public void run() {
        FontMetrics fm = this.display.getGraphics().getFontMetrics(this.displayFont);
        int displayWidth = this.display.getWidth();
        String message = toggle ? infoMessage[messageNumber] : "Current heap usage: " + (this.rt.totalMemory() - this.rt.freeMemory()) + " bytes";
        String excerpt = "";
        boolean textWidth = false;
        int index = 0;
        int behead = 0;
        while (this.run && index < message.length()) {
            excerpt = excerpt + message.charAt(index++);
            while (fm.stringWidth(excerpt) > displayWidth) {
                ++behead;
                excerpt = excerpt.substring(1);
            }
            this.display.setText(excerpt);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        while (this.run && behead < message.length()) {
            excerpt = excerpt + " ";
            while (fm.stringWidth(excerpt) > displayWidth) {
                ++behead;
                excerpt = excerpt.substring(1);
            }
            this.display.setText(excerpt);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        this.updateDisplay();
        if (toggle) {
            ++messageNumber;
        }
        if (messageNumber == infoMessage.length) {
            messageNumber = 0;
        }
        toggle = !toggle;
    }

    public void stop() {
        if (this.runner != null) {
            this.run = false;
            this.runner = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

