/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.taskbar;

import com.acunia.wonka.rudolph.taskbar.TaskBarApplet;
import com.acunia.wonka.rudolph.taskbar.TaskBarConstraints;
import com.acunia.wonka.rudolph.taskbar.TaskBarLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public class TaskBar
extends Frame
implements FocusListener {
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int FLOATING = 4;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static boolean enabled = false;
    private static int location = 1;
    private static int size = 0;
    private static Properties properties;
    private static Rectangle floatDimensions;
    private static Image background;
    private static Color color;
    private static TaskBar taskbar;
    private int tb_width;
    private int tb_height;
    private Vector applets;
    static /* synthetic */ Class class$com$acunia$wonka$rudolph$taskbar$TaskBar;

    public static TaskBar getTaskBar() {
        if (properties == null) {
            TaskBar.loadProperties();
        }
        if (taskbar == null && enabled) {
            taskbar = new TaskBar();
        }
        return taskbar;
    }

    public TaskBar() {
        int ty;
        int tx;
        this.setLayout(new TaskBarLayout());
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (location == 4) {
            this.tb_width = TaskBar.floatDimensions.width;
            this.tb_height = TaskBar.floatDimensions.height;
            tx = TaskBar.floatDimensions.x;
            ty = TaskBar.floatDimensions.y;
        } else {
            this.tb_width = location == 2 || location == 3 ? size : screen.width;
            this.tb_height = location == 1 || location == 0 ? size : screen.height;
            tx = location == 3 ? screen.width - size : 0;
            ty = location == 0 ? screen.height - size : 0;
        }
        this.setBounds(tx, ty, this.tb_width, this.tb_height);
        this.setBackground(Color.black);
        this.addFocusListener(this);
        this.applets = new Vector();
        this.loadApplets();
        this.setVisible(true);
    }

    private static void loadProperties() {
        URL url;
        properties = new Properties();
        try {
            properties.load(ClassLoader.getSystemResourceAsStream("taskbar.properties"));
        }
        catch (Exception e) {
            // empty catch block
        }
        enabled = Boolean.valueOf(properties.getProperty("taskbar", "false"));
        if (!enabled) {
            return;
        }
        String loc = properties.getProperty("taskbar.location", "top");
        if (loc.equals("top")) {
            location = 1;
        } else if (loc.equals("bottom")) {
            location = 0;
        } else if (loc.equals("left")) {
            location = 2;
        } else if (loc.equals("right")) {
            location = 3;
        } else if (loc.equals("floating")) {
            location = 4;
            floatDimensions = new Rectangle(Integer.parseInt(properties.getProperty("taskbar.x", "0")), Integer.parseInt(properties.getProperty("taskbar.y", "0")), Integer.parseInt(properties.getProperty("taskbar.width", "0")), Integer.parseInt(properties.getProperty("taskbar.height", "0")));
        }
        size = loc.equals("floating") ? TaskBar.floatDimensions.width : Integer.parseInt(properties.getProperty("taskbar.size", "32"));
        String imgname = properties.getProperty("taskbar.background", null);
        if (imgname != null && (url = ClassLoader.getSystemResource(imgname)) != null) {
            background = Toolkit.getDefaultToolkit().getImage(url);
        }
        int r = Integer.parseInt(properties.getProperty("taskbar.color.red", "0"));
        int g = Integer.parseInt(properties.getProperty("taskbar.color.green", "0"));
        int b = Integer.parseInt(properties.getProperty("taskbar.color.blue", "0"));
        color = new Color(r, g, b);
    }

    private void loadApplets() {
        String classname = null;
        int i = 1;
        while ((classname = properties.getProperty("taskbar.applet." + i + ".class")) != null) {
            int position = Integer.parseInt(properties.getProperty("taskbar.applet." + i + ".position", "-1"));
            try {
                Class appletClass = Class.forName(classname);
                Constructor appletConstructor = appletClass.getConstructor(new Class[]{class$com$acunia$wonka$rudolph$taskbar$TaskBar == null ? TaskBar.class$("com.acunia.wonka.rudolph.taskbar.TaskBar") : class$com$acunia$wonka$rudolph$taskbar$TaskBar});
                TaskBarApplet applet = (TaskBarApplet)appletConstructor.newInstance(new Object[]{this});
                TaskBarConstraints constr = position != -1 ? new TaskBarConstraints(position) : new TaskBarConstraints();
                this.addApplet(applet, constr);
            }
            catch (Exception e) {
                System.out.println("Oh no : " + e);
            }
            ++i;
        }
    }

    public static int getBarSize() {
        return size;
    }

    public static int getBarLocation() {
        return location;
    }

    public static int getBarOrientation() {
        return location == 2 || location == 3 ? 1 : 0;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.tb_width, this.tb_height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.tb_width, this.tb_height);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.tb_width, this.tb_height);
    }

    public void addApplet(TaskBarApplet applet, TaskBarConstraints consts) {
        this.add((Component)applet, consts);
        this.applets.add(applet);
    }

    public int getAppletCount() {
        return this.applets.size();
    }

    public TaskBarApplet getApplet(int i) {
        return (TaskBarApplet)this.applets.elementAt(i);
    }

    public void paint(Graphics g) {
        g.setColor(color);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (background != null) {
            g.drawImage(background, 0, 0, null);
        }
    }

    public void focusGained(FocusEvent evt) {
        Component.revertFocus();
    }

    public void focusLost(FocusEvent evt) {
    }

    public Properties getProperties() {
        return properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        taskbar = null;
    }
}

