/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultList;
import com.acunia.wonka.rudolph.peers.DefaultScrollbar;
import com.acunia.wonka.rudolph.peers.DefaultTextArea;
import com.acunia.wonka.rudolph.peers.ScrollPainter;
import java.awt.Component;
import java.awt.List;
import java.awt.Scrollbar;
import java.awt.TextArea;

public class ScrollRunner
extends Thread {
    public static final long SCROLLSENSITIVITY = 100L;
    public static final int SCROLL_STOP = -1;
    public static final int SCROLL_UP = 1;
    public static final int SCROLL_DOWN = 2;
    private ScrollPainter thePainter = null;
    private Component theParent = null;
    private int mouseScroll = -1;

    public ScrollRunner() {
        super("<List Scrolling Runner>");
        this.setDaemon(true);
        this.start();
    }

    public synchronized void setRunner(ScrollPainter painter, Component parent, int mouse) {
        this.thePainter = painter;
        this.theParent = parent;
        this.mouseScroll = mouse;
        this.notifyAll();
    }

    public synchronized void setRunner(ScrollPainter painter, Component parent) {
        this.thePainter = painter;
        this.theParent = parent;
        this.mouseScroll = -1;
        this.notifyAll();
    }

    public synchronized void updateMouseScroll(int newvalue) {
        this.mouseScroll = newvalue;
    }

    public synchronized void stopRunner(ScrollPainter painter) {
        painter.setNoSelected();
        this.mouseScroll = -1;
        if (this.theParent != null && this.thePainter != null) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            boolean running;
            ScrollRunner scrollRunner;
            if (this.thePainter == null || this.theParent == null) {
                scrollRunner = this;
                synchronized (scrollRunner) {
                    try {
                        this.wait();
                        this.wait(250L);
                    }
                    catch (InterruptedException e) {
                        System.out.println(e.toString());
                    }
                }
            }
            int active = this.thePainter.getActive();
            boolean bl = running = active > -1 || this.mouseScroll > -1;
            while (running) {
                if (this.theParent instanceof Scrollbar) {
                    if (active == 2 && this.thePainter.lineUp()) {
                        ((DefaultScrollbar)this.theParent.getPeer()).processAdjustmentEvent(active);
                    } else if (active == 1 && this.thePainter.lineDn()) {
                        ((DefaultScrollbar)this.theParent.getPeer()).processAdjustmentEvent(active);
                    } else if (active == 3 && this.thePainter.pageUp()) {
                        ((DefaultScrollbar)this.theParent.getPeer()).processAdjustmentEvent(active);
                    } else if (active == 4 && this.thePainter.pageDn()) {
                        ((DefaultScrollbar)this.theParent.getPeer()).processAdjustmentEvent(active);
                    } else {
                        running = false;
                    }
                } else if (this.theParent instanceof List) {
                    if (active == 2 && this.thePainter.lineUp()) {
                        ((DefaultList)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (active == 1 && this.thePainter.lineDn()) {
                        ((DefaultList)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (active == 3 && this.thePainter.pageUp()) {
                        ((DefaultList)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (active == 4 && this.thePainter.pageDn()) {
                        ((DefaultList)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (this.mouseScroll == 1 && this.thePainter.lineUp()) {
                        ((DefaultList)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (this.mouseScroll == 2 && this.thePainter.lineDn()) {
                        ((DefaultList)this.theParent.getPeer()).repaint(this.thePainter);
                    } else {
                        running = false;
                    }
                } else if (this.theParent instanceof TextArea) {
                    if (active == 2 && this.thePainter.lineUp()) {
                        ((DefaultTextArea)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (active == 1 && this.thePainter.lineDn()) {
                        ((DefaultTextArea)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (active == 3 && this.thePainter.pageUp()) {
                        ((DefaultTextArea)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (active == 4 && this.thePainter.pageDn()) {
                        ((DefaultTextArea)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (this.mouseScroll == 1 && this.thePainter.lineUp()) {
                        ((DefaultTextArea)this.theParent.getPeer()).repaint(this.thePainter);
                    } else if (this.mouseScroll == 2 && this.thePainter.lineDn()) {
                        ((DefaultTextArea)this.theParent.getPeer()).repaint(this.thePainter);
                    } else {
                        running = false;
                    }
                } else {
                    running = false;
                }
                if (!running) continue;
                scrollRunner = this;
                synchronized (scrollRunner) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        System.out.println(e.toString());
                    }
                    active = this.thePainter.getActive();
                    running = active > -1 || this.mouseScroll > -1;
                }
            }
            this.thePainter = null;
            this.theParent = null;
        }
    }
}

