/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.SystemColor;

public class RudolphPeer {
    public static final int FIELD_NONESELECTED = -1;
    public static final int COLORFILTER = 2;
    public static final int COLORWIDTH = 5;
    public static final int REVERTTOBLACK = 96;
    public static final int REVERTTOWHITE = 240;

    public static Color[] getBarColors() {
        Color[] peercolors;
        peercolors = new Color[]{SystemColor.control, SystemColor.controlShadow, SystemColor.controlHighlight, peercolors[1].equals(SystemColor.controlDkShadow) ? RudolphPeer.getDarker(SystemColor.controlDkShadow) : SystemColor.controlDkShadow, SystemColor.controlText};
        return peercolors;
    }

    public static Color[] getBarColors(Color panelcolor, Color fontcolor) {
        Color[] peercolors;
        if (panelcolor == null) {
            panelcolor = SystemColor.scrollbar;
        }
        if (fontcolor == null) {
            fontcolor = SystemColor.windowText;
        }
        peercolors = new Color[]{RudolphPeer.copyOf(panelcolor), RudolphPeer.getMiddle(panelcolor, Color.gray), RudolphPeer.getBrighter(panelcolor), RudolphPeer.getMiddle(peercolors[1], Color.black), RudolphPeer.copyOf(fontcolor)};
        return peercolors;
    }

    public static Color[] getBarColors(Color panelcolor, Color background, Color whiteframe, Color blackframe, Color fontcolor) {
        Color[] peercolors = new Color[]{RudolphPeer.copyOf(panelcolor), RudolphPeer.copyOf(background), RudolphPeer.copyOf(whiteframe), RudolphPeer.copyOf(blackframe), RudolphPeer.copyOf(fontcolor)};
        return peercolors;
    }

    public static Color getDarker(Color c) {
        int b;
        int g;
        int r = c.getRed() / 2;
        if (r + (g = c.getGreen() / 2) + (b = c.getBlue() / 2) > 96) {
            return new Color(r, g, b);
        }
        return Color.black;
    }

    public static Color getBrighter(Color c) {
        int b;
        int g;
        int offset = 127;
        int r = offset + c.getRed() / 2;
        if (r + (g = offset + c.getGreen() / 2) + (b = offset + c.getBlue() / 2) < 240) {
            return new Color(r, g, b);
        }
        return Color.white;
    }

    public static Color getMiddle(Color c1, Color c2) {
        int base = 1;
        int r = (base * c1.getRed() + c2.getRed()) / 2;
        int g = (base * c1.getGreen() + c2.getGreen()) / 2;
        int b = (base * c1.getBlue() + c2.getBlue()) / 2;
        return new Color(r, g, b);
    }

    public static Color copyOf(Color c) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static int getChars(int width, int lineoffset, char[] line, FontMetrics fm) {
        if (line == null || lineoffset >= line.length) {
            return -2;
        }
        if (width < 0) {
            return -1;
        }
        int len = fm.charWidth(line[lineoffset]);
        int lastchar = line.length - 1;
        while (len < width && lineoffset < lastchar) {
            len += fm.charWidth(line[++lineoffset]);
        }
        return len < width ? line.length : lineoffset;
    }

    public static int getChars(int width, int lineoffset, char[] line, int fontwidth) {
        if (line == null || lineoffset >= line.length) {
            return -2;
        }
        if (width < 0) {
            return -1;
        }
        int len = lineoffset + width / fontwidth;
        return len > line.length ? line.length : len;
    }
}

