/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.peer.TextComponentPeer;

public class DefaultTextComponent
extends DefaultComponent
implements TextComponentPeer,
KeyListener {
    protected String text = "";
    protected int position;
    protected int selectionStart;
    protected int selectionStop;

    public DefaultTextComponent(TextComponent textComponent) {
        super(textComponent);
        textComponent.addKeyListener(this);
    }

    public int getCaretPosition() {
        return this.position;
    }

    public void setCaretPosition(int newposition) {
        this.position = newposition < 0 ? 0 : (newposition > this.text.length() ? this.text.length() : newposition);
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionStop;
    }

    public void select(int start, int end) {
        this.selectionStart = start > 0 ? start : 0;
        this.selectionStop = end > 0 ? end : 0;
        int length = this.text.length();
        if (this.selectionStart > length) {
            this.selectionStart = length;
        }
        if (this.selectionStop > length) {
            this.selectionStop = length;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newtext) {
        this.text = newtext;
        int length = this.text.length();
        if (this.position > length) {
            this.position = length;
        }
        if (this.selectionStart > length) {
            this.selectionStart = length;
        }
        if (this.selectionStop > this.selectionStart) {
            this.selectionStop = this.selectionStart;
        }
    }

    public void setEditable(boolean editable) {
    }

    public void keyPressed(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 37: {
                if (evt.isShiftDown() && this.moveSelection(this.position - 1) || !this.moveCaret(this.position - 1)) break;
                break;
            }
            case 39: {
                if (evt.isShiftDown() && this.moveSelection(this.position + 1) || !this.moveCaret(this.position + 1)) break;
                break;
            }
            case 36: {
                if (evt.isShiftDown() && this.moveSelection(0) || !this.moveCaret(0)) break;
                break;
            }
            case 35: {
                if (evt.isShiftDown() && this.moveSelection(this.text.length())) {
                    this.setCaretPosition(this.position);
                    break;
                }
                if (!this.moveCaret(this.text.length())) break;
                break;
            }
            case 8: {
                if (this.selectionStart < this.selectionStop) {
                    this.deleteSelection();
                    this.component.dispatchEvent(new TextEvent(this.component, 900));
                    break;
                }
                if (!this.deleteCaret(this.position - 1)) break;
                this.component.dispatchEvent(new TextEvent(this.component, 900));
                break;
            }
            case 127: {
                if (this.selectionStart < this.selectionStop) {
                    this.deleteSelection();
                    this.component.dispatchEvent(new TextEvent(this.component, 900));
                    break;
                }
                if (!this.deleteCaret(this.position)) break;
                this.component.dispatchEvent(new TextEvent(this.component, 900));
                break;
            }
            case 16: 
            case 17: 
            case 38: 
            case 40: {
                break;
            }
            default: {
                if (this.selectionStart < this.selectionStop) {
                    this.insertSelection(evt.getKeyChar());
                    this.component.dispatchEvent(new TextEvent(this.component, 900));
                    break;
                }
                if (!this.insertCaret(this.position, evt.getKeyChar())) break;
                this.component.dispatchEvent(new TextEvent(this.component, 900));
            }
        }
        this.paint(this.getGraphics());
    }

    private boolean moveCaret(int newpos) {
        if (newpos < 0 || newpos > this.text.length() || newpos == this.position) {
            return false;
        }
        this.position = newpos;
        this.selectionStart = newpos;
        this.selectionStop = newpos;
        return true;
    }

    private boolean moveSelection(int newpos) {
        if (newpos < 0 || newpos > this.text.length() || newpos == this.position) {
            return false;
        }
        if (this.position == this.selectionStart && newpos < this.selectionStop) {
            this.position = newpos;
            this.selectionStart = newpos;
            return true;
        }
        if (this.position == this.selectionStart) {
            this.position = newpos;
            this.selectionStart = this.selectionStop;
            this.selectionStop = newpos;
            return true;
        }
        if (newpos > this.selectionStart) {
            this.position = newpos;
            this.selectionStop = newpos;
            return true;
        }
        this.position = newpos;
        this.selectionStop = this.selectionStart;
        this.selectionStart = newpos;
        return true;
    }

    protected boolean deleteCaret(int newpos) {
        if (newpos < 0 || newpos >= this.text.length()) {
            return false;
        }
        this.position = newpos;
        this.selectionStart = newpos;
        this.selectionStop = newpos;
        this.text = new String(new StringBuffer(this.text).deleteCharAt(newpos));
        return true;
    }

    protected void deleteSelection() {
        this.text = new String(new StringBuffer(this.text).delete(this.selectionStart, this.selectionStop));
        this.position = this.selectionStart;
        this.selectionStop = this.selectionStart;
    }

    protected boolean insertCaret(int newpos, char c) {
        if (newpos < 0 || newpos > this.text.length()) {
            return false;
        }
        this.selectionStart = this.position = newpos + 1;
        this.selectionStop = this.position;
        this.text = new String(new StringBuffer(this.text).insert(newpos, c));
        return true;
    }

    protected void insertSelection(char c) {
        StringBuffer buf = new StringBuffer(this.text);
        buf.delete(this.selectionStart, this.selectionStop);
        buf.insert(this.selectionStart, c);
        this.text = new String(buf);
        this.position = this.selectionStart;
        this.selectionStop = this.selectionStart;
    }

    public boolean inRange(MouseEvent e) {
        return true;
    }
}

