/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import com.acunia.wonka.rudolph.peers.DefaultContainer;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.ScrollPane;
import java.awt.peer.ScrollPanePeer;

public class DefaultScrollPane
extends DefaultContainer
implements ScrollPanePeer {
    private int vx;
    private int vy;
    private int vwidth;
    private int vheight;

    public DefaultScrollPane(ScrollPane scrollpane) {
        super(scrollpane);
    }

    private native void setViewport(Component var1, int var2, int var3, int var4, int var5);

    private void refreshViewport() {
        Component comp;
        try {
            comp = ((ScrollPane)this.component).getComponent(0);
        }
        catch (Exception e) {
            return;
        }
        Container viewport = comp instanceof Container ? (Container)comp : comp.getParent();
        if (this.vx + this.vwidth > viewport.getWidth()) {
            this.vx = viewport.getWidth() - this.vwidth;
        }
        if (this.vy + this.vheight > viewport.getHeight()) {
            this.vy = viewport.getHeight() - this.vheight;
        }
        this.setViewport(viewport, this.vx, this.vy, this.vwidth, this.vheight);
        ((DefaultComponent)viewport.getPeer()).refresh(2);
        this.refresh(2);
        viewport.invalidate();
        viewport.validate();
    }

    public void childResized(int w, int h) {
        this.vx = 0;
        this.vy = 0;
        this.vwidth = w;
        this.vheight = h;
        this.refreshViewport();
    }

    public int getHScrollbarHeight() {
        return 0;
    }

    public int getVScrollbarWidth() {
        return 0;
    }

    public void setScrollPosition(int x, int y) {
        this.vx = x;
        this.vy = y;
        this.refreshViewport();
    }

    public void setUnitIncrement(int increment) {
    }

    public void setValue(Adjustable adj, int value) {
        if (adj.getOrientation() == 0) {
            this.vx = value;
        } else {
            this.vy = value;
        }
        this.refreshViewport();
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        Component comp = ((ScrollPane)this.component).getComponent(0);
        if (comp != null) {
            return new Dimension(comp.getPreferredSize().width, comp.getPreferredSize().height);
        }
        return new Dimension(0, 0);
    }
}

