/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import com.acunia.wonka.rudolph.peers.RudolphPeer;
import com.acunia.wonka.rudolph.peers.RudolphScrollbarPeer;
import com.acunia.wonka.rudolph.peers.ScrollPainter;
import com.acunia.wonka.rudolph.peers.ScrollRunner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.peer.ListPeer;

public class DefaultList
extends DefaultComponent
implements ListPeer,
MouseListener,
MouseMotionListener {
    public static final Font DEFAULT_FONT = new Font("courP14", 0, 14);
    public static final int BORDER = 15;
    public static final int LABELDESCENT = 4;
    public static final int LABELOFFSET = 5;
    private int minimumLines;
    private int labelheight;
    private Dimension viewport = new Dimension();
    private Dimension listport = new Dimension();
    private Image bufferedImage;
    private Graphics bufferedGraphics;
    private Color[] listColors = RudolphPeer.getBarColors();
    private Font listFont = Component.DEFAULT_FONT;
    private FontMetrics listFontMetrics = new FontMetrics(this.listFont);
    private HListScrollPainter hScroll;
    private boolean hScrollVisible;
    private VListScrollPainter vScroll;
    private boolean vScrollVisible;
    private boolean[] itemSelected;
    private boolean[] TMPitemSelected;
    private int currentSelected;
    private int lastSelected;
    private boolean multiple;
    private boolean repaintListArea;
    private boolean repaintViewArea;
    private boolean repaintHScroll;
    private boolean repaintVScroll;
    static final ScrollRunner mouseEventThread = new ScrollRunner();
    private int lineOffset;
    private int charOffset;
    private int maximumLineWidth = 0;
    private Point lastMousePosition;

    public DefaultList(List list) {
        super(list);
        super.setFont(this.listFont);
        this.hScroll = new HListScrollPainter();
        this.hScroll.setBarColors(this.listColors);
        this.vScroll = new VListScrollPainter();
        this.vScroll.setBarColors(this.listColors);
        this.currentSelected = -1;
        this.lastSelected = -1;
        list.addMouseListener(this);
        list.addMouseMotionListener(this);
        this.lastMousePosition = new Point(0, 0);
    }

    public void add(String item, int index) {
        int lineWidth;
        List list = (List)this.component;
        if (this.multiple) {
            int i;
            this.TMPitemSelected = new boolean[list.getItemCount()];
            for (i = 0; i < index; ++i) {
                this.TMPitemSelected[i] = this.itemSelected[i];
            }
            this.TMPitemSelected[index] = false;
            for (i = index; i < this.itemSelected.length; ++i) {
                this.TMPitemSelected[i + 1] = this.itemSelected[i];
            }
            this.itemSelected = this.TMPitemSelected;
        }
        if ((lineWidth = this.calculateLineWidth(index)) > this.maximumLineWidth) {
            this.maximumLineWidth = lineWidth;
        }
        this.scrollBars();
        this.repaintViewArea = true;
        this.paint(this.getGraphics());
    }

    public void delItems(int start, int end) {
        List list = (List)this.component;
        if (this.multiple) {
            int i;
            this.TMPitemSelected = new boolean[list.getItemCount()];
            for (i = 0; i < start; ++i) {
                this.TMPitemSelected[i] = this.itemSelected[i];
            }
            for (i = start; i < this.itemSelected.length - (end - start); ++i) {
                this.TMPitemSelected[i] = this.itemSelected[i + 1];
            }
            this.itemSelected = this.TMPitemSelected;
        }
        this.calculateMaximumWidth();
        this.scrollBars();
        this.repaintViewArea = true;
        this.paint(this.getGraphics());
    }

    public void deselect(int index) {
        List list = (List)this.component;
        if (list.getItemCount() == 0 || index < 0 || index >= list.getItemCount()) {
            return;
        }
        if (this.currentSelected == index) {
            this.currentSelected = -1;
        }
        if (this.multiple) {
            this.itemSelected[index] = false;
        }
        this.repaintViewArea = true;
        this.paint(this.getGraphics());
    }

    public Dimension getMinimumSize(int rows) {
        return null;
    }

    public Dimension getPreferredSize(int rows) {
        return null;
    }

    public int[] getSelectedIndexes() {
        int[] selection;
        List list = (List)this.component;
        if (list.getItemCount() == 0 || this.currentSelected >= list.getItemCount()) {
            selection = new int[]{};
        } else if (!this.multiple && this.currentSelected < 0) {
            selection = new int[]{};
        } else if (!this.multiple) {
            selection = new int[]{this.currentSelected};
        } else {
            int i;
            int selected = 0;
            for (i = 0; i < this.itemSelected.length; ++i) {
                if (!this.itemSelected[i]) continue;
                ++selected;
            }
            selection = new int[selected];
            selected = 0;
            for (i = 0; i < this.itemSelected.length; ++i) {
                if (!this.itemSelected[i]) continue;
                selection[selected] = i;
                ++selected;
            }
        }
        return selection;
    }

    public void makeVisible(int target) {
        List list = (List)this.component;
        if (target < 0) {
            target = 0;
        } else if (target >= list.getItemCount()) {
            target = list.getItemCount() - 1;
        }
        if (target < this.lineOffset) {
            this.lineOffset = target;
        } else if (target > this.lineOffset + this.listport.height / this.labelheight) {
            this.lineOffset = target - this.listport.height / this.labelheight;
        }
        this.vScroll.setBarPos(this.lineOffset);
        this.repaintListArea = true;
        this.repaintVScroll = true;
        this.paint(this.getGraphics());
    }

    public void removeAll() {
        if (this.multiple) {
            this.itemSelected = null;
        }
        this.currentSelected = -1;
        this.lastSelected = -1;
        this.maximumLineWidth = 0;
        this.scrollBars();
        this.repaintViewArea = true;
        this.paint(this.getGraphics());
    }

    public void select(int index) {
        List list = (List)this.component;
        if (list.getItemCount() == 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to select element " + index + " of list size 0");
        }
        if (index < 0 || index >= list.getItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Attempt to select element " + index + " of list size " + list.getItemCount());
        }
        this.currentSelected = index;
        this.lastSelected = index;
        if (this.multiple) {
            this.itemSelected[index] = true;
        }
        this.repaintViewArea = true;
        this.paint(this.getGraphics());
    }

    public void setMultipleMode(boolean mode) {
        this.multiple = mode;
        this.itemSelected = (boolean[])(!mode ? null : new boolean[0]);
    }

    protected void processActionEvent(ActionEvent ae) {
        this.component.dispatchEvent(ae);
    }

    protected void processItemEvent(ItemEvent ie) {
        this.component.dispatchEvent(ie);
    }

    private int calculateLineWidth(int pos) {
        List list = (List)this.component;
        return this.listFontMetrics.stringWidth(list.getItem(pos));
    }

    private void calculateMaximumWidth() {
        this.maximumLineWidth = 0;
        List list = (List)this.component;
        if (list.getItemCount() == 0) {
            return;
        }
        for (int i = 0; i < list.getItemCount(); ++i) {
            if (this.maximumLineWidth >= this.listFontMetrics.stringWidth(list.getItem(i))) continue;
            this.maximumLineWidth = this.listFontMetrics.stringWidth(list.getItem(i));
        }
    }

    public Dimension getMinimumSize() {
        List list = (List)this.component;
        this.minimumLines = list.getRows();
        return new Dimension(this.maximumLineWidth + this.vScroll.getMinimumThickness(), DefaultList.getHeight(this.minimumLines, this.listFontMetrics));
    }

    public Dimension getPreferredSize() {
        List list = (List)this.component;
        this.minimumLines = list.getRows();
        return new Dimension(this.maximumLineWidth + this.vScroll.getMinimumThickness(), DefaultList.getHeight(this.minimumLines, this.listFontMetrics));
    }

    public static int getHeight(int lines, FontMetrics lfm) {
        return lines * (lfm.getHeight() + 4) + 4;
    }

    public void setBackground(Color cb) {
        super.setBackground(cb);
        this.listColors = RudolphPeer.getBarColors(cb, this.component.getForeground());
        this.hScroll.setBarColors(this.listColors);
        this.vScroll.setBarColors(this.listColors);
        this.repaintViewArea = true;
        this.paint(this.getGraphics());
    }

    public void setForeground(Color cf) {
        super.setForeground(cf);
        this.listColors[4] = cf;
        this.hScroll.setBarColors(this.listColors);
        this.vScroll.setBarColors(this.listColors);
        this.repaintViewArea = true;
        this.paint(this.getGraphics());
    }

    public void setFont(Font f) {
        List list = (List)this.component;
        super.setFont(f);
        this.listFont = f == null ? DEFAULT_FONT : f;
        this.listFontMetrics = new FontMetrics(this.listFont);
        if (list.getItemCount() != 0) {
            this.calculateMaximumWidth();
            this.scrollBars();
            this.hScroll.setLineStep(this.listFontMetrics.getMaxAdvance());
            this.repaintViewArea = true;
        }
    }

    public void scrollBars() {
        List list = (List)this.component;
        this.labelheight = 2 + this.listFontMetrics.getHeight() + 2;
        int fullscreenlabels = this.viewport.height / this.labelheight;
        int barredlabels = (this.viewport.height - 16) / this.labelheight;
        int innerwidth = this.viewport.width - 5 - 2;
        int barredwidth = innerwidth - 16;
        if (list.getItemCount() == 0) {
            this.hScrollVisible = false;
            this.vScrollVisible = false;
            this.lineOffset = 0;
            this.listport.setSize(this.viewport);
        } else if (innerwidth >= this.maximumLineWidth && fullscreenlabels >= list.getItemCount()) {
            this.hScrollVisible = false;
            this.charOffset = 0;
            this.vScrollVisible = false;
            this.lineOffset = 0;
            this.listport.setSize(this.viewport);
        } else if (barredwidth >= this.maximumLineWidth) {
            this.listport.setSize(this.viewport.width - 16, this.viewport.height);
            this.hScrollVisible = false;
            this.charOffset = 0;
            this.vScrollVisible = true;
            this.vScroll.setOffset(this.listport.width);
            this.lineOffset = this.vScroll.setScreenHeight(this.listport.height, fullscreenlabels, list.getItemCount());
        } else if (barredlabels >= list.getItemCount()) {
            this.listport.setSize(this.viewport.width, this.viewport.height - 16);
            this.hScrollVisible = true;
            this.hScroll.setOffset(this.listport.height);
            this.charOffset = this.hScroll.setScreenWidth(this.listport.width, this.maximumLineWidth);
            this.vScrollVisible = false;
            this.lineOffset = 0;
        } else {
            this.listport.setSize(this.viewport.width - 16, this.viewport.height - 16);
            this.hScrollVisible = true;
            this.hScroll.setOffset(this.listport.height);
            this.charOffset = this.hScroll.setScreenWidth(this.listport.width, this.maximumLineWidth);
            this.vScrollVisible = true;
            this.vScroll.setOffset(this.listport.width);
            this.lineOffset = this.vScroll.setScreenHeight(this.listport.height, barredlabels, list.getItemCount());
        }
        this.repaintViewArea = true;
    }

    public static int getLabel(int y, FontMetrics lfm) {
        return (y - 2) / (2 + lfm.getHeight() + 2);
    }

    public static int getInnerLength(int screenwidth) {
        return screenwidth - 5 - 2;
    }

    private void itemSelected(int index) {
        List list = (List)this.component;
        if (list.getItemCount() != 0 && index >= 0 && index < list.getItemCount()) {
            if (this.currentSelected != index) {
                this.currentSelected = index;
                this.lastSelected = index;
            }
            if (list.getItemCount() != 0) {
                int selected;
                if (this.multiple) {
                    this.itemSelected[index] = !this.itemSelected[index];
                    selected = this.itemSelected[index] ? 1 : 2;
                } else {
                    selected = this.currentSelected >= 0 ? 1 : 2;
                }
                this.processItemEvent(new ItemEvent((ItemSelectable)((Object)this.component), 701, new String(list.getItem(index)), selected));
            }
        }
    }

    public void repaint(ScrollPainter alignation) {
        if (alignation == this.hScroll) {
            this.charOffset = this.hScroll.getBarPos();
            this.repaintHScroll = true;
        } else {
            this.lineOffset = this.vScroll.getBarPos();
            this.repaintVScroll = true;
        }
        this.repaintListArea = true;
        this.paint(this.getGraphics());
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        List list = (List)this.component;
        if (this.bufferedImage == null || !this.viewport.equals(this.component.getSize())) {
            this.viewport.setSize(this.component.getSize());
            this.scrollBars();
            this.bufferedImage = this.component.createImage(this.viewport.width, this.viewport.height);
            if (this.bufferedImage != null && this.bufferedGraphics != null) {
                this.bufferedGraphics.dispose();
            }
            this.bufferedGraphics = this.bufferedImage.getGraphics();
            this.repaintViewArea = true;
        }
        if (this.component.getForeground() != null && !this.component.getForeground().equals(this.listColors[4])) {
            this.listColors[4] = this.component.getForeground();
            this.hScroll.setBarColors(this.listColors);
            this.vScroll.setBarColors(this.listColors);
            this.repaintViewArea = true;
        }
        if (this.component.getBackground() != null && !this.component.getBackground().equals(this.listColors[0])) {
            this.listColors = RudolphPeer.getBarColors(this.component.getBackground(), this.listColors[4]);
            this.hScroll.setBarColors(this.listColors);
            this.vScroll.setBarColors(this.listColors);
            this.repaintViewArea = true;
        }
        if (this.repaintViewArea) {
            this.bufferedGraphics.clearRect(1, 1, this.viewport.width - 2, this.viewport.height - 2);
        }
        if (this.repaintListArea || this.repaintViewArea) {
            if (!this.repaintViewArea) {
                this.bufferedGraphics.clearRect(1, 1, this.listport.width - 2, this.listport.height - 2);
            }
            int xt = 6 - this.charOffset;
            int yt = 1 + this.listFontMetrics.getHeight() - this.listFontMetrics.getDescent();
            int xl = 1;
            int xr = 1 + this.listport.width - 4;
            int yl = 1;
            int wl = this.listport.width - 2;
            int hl = this.labelheight;
            int tmpOffset = this.lineOffset;
            for (int i = this.lineOffset; i < this.lineOffset + this.listport.height / this.labelheight && i < list.getItemCount(); ++i) {
                if (i == this.currentSelected) {
                    this.bufferedGraphics.setColor(this.listColors[3]);
                    this.bufferedGraphics.fillRect(xl, yl, wl, hl);
                    yl += this.labelheight;
                    this.bufferedGraphics.setColor(this.listColors[2]);
                    this.bufferedGraphics.drawString(list.getItem(tmpOffset++), xt, yt);
                    yt += this.labelheight;
                    continue;
                }
                if (this.itemSelected != null && this.itemSelected[i]) {
                    this.bufferedGraphics.setColor(this.listColors[1]);
                    this.bufferedGraphics.fillRect(xl, yl, wl, hl);
                    yl += this.labelheight;
                    this.bufferedGraphics.setColor(this.listColors[2]);
                    this.bufferedGraphics.drawString(list.getItem(tmpOffset++), xt, yt);
                    yt += this.labelheight;
                    continue;
                }
                yl += this.labelheight;
                if (this.component.isEnabled()) {
                    this.bufferedGraphics.setColor(this.listColors[4]);
                } else {
                    this.bufferedGraphics.setColor(SystemColor.textInactiveText);
                }
                this.bufferedGraphics.drawString(list.getItem(tmpOffset++), xt, yt);
                yt += this.labelheight;
            }
            this.repaintListArea = false;
        }
        if (this.hScrollVisible) {
            this.hScroll.paint(this.bufferedGraphics);
            this.repaintHScroll = false;
        }
        if (this.vScrollVisible) {
            this.vScroll.paint(this.bufferedGraphics);
            this.repaintVScroll = false;
        }
        this.repaintViewArea = false;
        this.bufferedGraphics.setColor(this.listColors[1]);
        this.bufferedGraphics.drawLine(0, 0, this.listport.width, 0);
        this.bufferedGraphics.drawLine(0, 1, 0, this.listport.height - 1);
        this.bufferedGraphics.setColor(this.listColors[2]);
        this.bufferedGraphics.drawLine(this.listport.width - 1, 1, this.listport.width - 1, this.listport.height - 1);
        this.bufferedGraphics.drawLine(1, this.listport.height - 1, this.listport.width - 1, this.listport.height - 1);
        this.bufferedGraphics.setColor(this.listColors[0]);
        this.bufferedGraphics.drawLine(this.listport.width, 0, this.listport.width, this.listport.height - 1);
        g.drawImage(this.bufferedImage, 0, 0, this.component);
    }

    public void addItem(String item, int index) {
    }

    public void clear() {
    }

    public Dimension minimumSize(int rows) {
        return null;
    }

    public Dimension preferredSize(int rows) {
        return null;
    }

    public void setMultipleSelections(boolean multiple) {
    }

    public void mouseClicked(MouseEvent e) {
        List list = (List)this.component;
        int click = DefaultList.getLabel(e.getY(), this.listFontMetrics) + this.lineOffset;
        if (click == this.currentSelected && list.getItemCount() != 0) {
            this.processActionEvent(new ActionEvent(this.component, 1001, new String(list.getItem(click))));
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
        if (this.multiple && this.currentSelected >= 0) {
            this.currentSelected = -1;
            this.repaintListArea = true;
        }
        if (this.hScrollVisible && this.hScroll.isSelected()) {
            mouseEventThread.stopRunner(this.hScroll);
            this.repaintHScroll = true;
        }
        if (this.vScrollVisible && this.vScroll.isSelected()) {
            mouseEventThread.stopRunner(this.vScroll);
            this.repaintVScroll = true;
        }
        if (this.repaintListArea || this.repaintHScroll || this.repaintVScroll) {
            this.paint(this.getGraphics());
        }
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.hScrollVisible && y > this.listport.height) {
            int active = this.hScroll.setActive(x, y);
            if (active == 5) {
                this.lastMousePosition.setLocation(x, y);
                this.repaintHScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 2 && this.hScroll.lineUp()) {
                mouseEventThread.setRunner(this.hScroll, this.component);
                this.repaint(this.hScroll);
            } else if (active == 2) {
                this.repaintHScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 1 && this.hScroll.lineDn()) {
                mouseEventThread.setRunner(this.hScroll, this.component);
                this.repaint(this.hScroll);
            } else if (active == 1) {
                this.repaintHScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 3 && this.hScroll.pageUp()) {
                mouseEventThread.setRunner(this.hScroll, this.component);
                this.repaint(this.hScroll);
            } else if (active == 4 && this.hScroll.pageDn()) {
                mouseEventThread.setRunner(this.hScroll, this.component);
                this.repaint(this.hScroll);
            }
        } else if (this.vScrollVisible && x > this.listport.width) {
            int active = this.vScroll.setActive(x, y);
            if (active == 5) {
                this.lastMousePosition.setLocation(x, y);
                this.repaintVScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 2 && this.vScroll.lineUp()) {
                mouseEventThread.setRunner(this.vScroll, this.component);
                this.repaint(this.vScroll);
            } else if (active == 2) {
                this.repaintVScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 1 && this.vScroll.lineDn()) {
                mouseEventThread.setRunner(this.vScroll, this.component);
                this.repaint(this.vScroll);
            } else if (active == 1) {
                this.repaintVScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 3 && this.vScroll.pageUp()) {
                mouseEventThread.setRunner(this.vScroll, this.component);
                this.repaint(this.vScroll);
            } else if (active == 4 && this.vScroll.pageDn()) {
                mouseEventThread.setRunner(this.vScroll, this.component);
                this.repaint(this.vScroll);
            }
        } else {
            List list = (List)this.component;
            this.lastMousePosition.setLocation(x, y);
            int click = DefaultList.getLabel(y, this.listFontMetrics) + this.lineOffset;
            if (list.getItemCount() != 0 && click <= list.getItemCount()) {
                this.itemSelected(click);
                this.repaintListArea = true;
                this.paint(this.getGraphics());
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.multiple && this.currentSelected >= 0) {
            this.currentSelected = -1;
            this.repaintListArea = true;
        }
        if (this.hScrollVisible && this.hScroll.isSelected()) {
            mouseEventThread.stopRunner(this.hScroll);
            this.repaintHScroll = true;
        }
        if (this.vScrollVisible && this.vScroll.isSelected()) {
            mouseEventThread.stopRunner(this.vScroll);
            this.repaintVScroll = true;
        }
        if (this.repaintListArea || this.repaintHScroll || this.repaintVScroll) {
            this.paint(this.getGraphics());
        }
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.vScrollVisible) {
            if (this.vScroll.getActive() == 5) {
                if (this.vScroll.moveBar(y - this.lastMousePosition.y)) {
                    this.repaint(this.vScroll);
                    this.lastMousePosition.y = y;
                }
            } else if (x < 0 || x > this.listport.width) {
                mouseEventThread.stopRunner(this.vScroll);
            } else if (y > 0 && y < 15 && y < this.lastMousePosition.y && this.vScroll.lineUp()) {
                mouseEventThread.setRunner(this.vScroll, this.component, 1);
                this.repaint(this.vScroll);
                this.lastMousePosition.y = y;
            } else if (y > 15 && y < this.lastMousePosition.y) {
                mouseEventThread.stopRunner(this.vScroll);
                this.lastMousePosition.y = y;
            } else if (y < this.listport.height && y > this.listport.height - 15 && y > this.lastMousePosition.y && this.vScroll.lineDn()) {
                mouseEventThread.setRunner(this.vScroll, this.component, 2);
                this.repaint(this.vScroll);
                this.lastMousePosition.y = y;
            } else if (y < this.listport.height - 15 && y > this.lastMousePosition.y) {
                mouseEventThread.stopRunner(this.vScroll);
                this.lastMousePosition.y = y;
            }
        }
        if (this.hScrollVisible) {
            if (this.hScroll.getActive() == 5) {
                if (this.hScroll.moveBar(x - this.lastMousePosition.x)) {
                    this.repaint(this.hScroll);
                    this.lastMousePosition.x = x;
                }
            } else if (y < 0 || y > this.listport.height) {
                mouseEventThread.stopRunner(this.hScroll);
            } else if (x > 0 && x < 15 && x < this.lastMousePosition.x && this.hScroll.lineUp()) {
                mouseEventThread.setRunner(this.hScroll, this.component, 1);
                this.repaint(this.vScroll);
                this.lastMousePosition.x = x;
            } else if (x > 15 && x < this.lastMousePosition.x) {
                mouseEventThread.stopRunner(this.hScroll);
                this.lastMousePosition.x = x;
            } else if (x < this.listport.width && x > this.listport.width - 15 && x > this.lastMousePosition.x && this.hScroll.lineDn()) {
                mouseEventThread.setRunner(this.hScroll, this.component, 2);
                this.repaint(this.vScroll);
                this.lastMousePosition.x = x;
            } else if (x < this.listport.width - 15 && x > this.lastMousePosition.x) {
                mouseEventThread.stopRunner(this.hScroll);
                this.lastMousePosition.x = x;
            }
        }
        this.refresh(1);
    }

    class VListScrollPainter
    extends ScrollPainter {
        public VListScrollPainter() {
            super(16, 16, 16, 16);
        }

        public int getPos(int x, int y) {
            return y;
        }

        public int getThickness(int width, int height) {
            return width;
        }

        public Dimension getSize(int scrollbarlength, int scrollbarthickness) {
            return new Dimension(scrollbarthickness, scrollbarlength);
        }

        public Dimension getPreferredSize(int width, int height) {
            return new Dimension(this.minimumThickness, height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.minimumThickness, this.lineUpSpan + this.lineDnSpan + this.minimumScreenSpan);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.minimumThickness, this.lineUpSpan + this.lineDnSpan + this.screenRange);
        }

        public Dimension getCurrentSize() {
            return new Dimension(this.minimumThickness, this.lineUpSpan + this.lineDnSpan + this.screenRange);
        }

        public void setThickness(int width, int height) {
            this.currentThickness = width > this.minimumThickness ? width : this.minimumThickness;
        }

        public boolean setRange(int width, int height) {
            return this.setRange(height);
        }

        public int getField(int x, int y) {
            return this.getField(y);
        }

        public synchronized int setActive(int x, int y) {
            this.currentActive = x > this.barOffset ? this.getField(y) : -1;
            return this.currentActive;
        }

        public int setScreenHeight(int totalheight, int linespan, int linerange) {
            this.screenRange = totalheight - this.lineUpSpan - this.lineDnSpan;
            this.barSpan = linespan;
            this.barRange = linerange;
            if (this.screenRange <= 0) {
                this.screenRange = 0;
                this.screenSpan = 0;
                this.screenPos = 0;
                this.crippledSpan = totalheight;
            } else {
                this.crippledSpan = -1;
                if (this.barSpan > this.barRange) {
                    this.barSpan = this.barRange;
                    this.barPos = 0;
                } else if (this.barPos + this.barSpan > this.barRange) {
                    this.barPos = this.barRange - this.barSpan;
                }
                this.setScreen();
                this.blockStep = linespan > 1 ? linespan - 1 : 1;
            }
            return this.barPos;
        }

        public void paint(Graphics g) {
            if (this.crippledSpan < 0) {
                RudolphScrollbarPeer.paintVScrollbar(this.barOffset, 0, this.minimumThickness, this.paintedScreenPos, this.screenSpan, this.screenRange, this.currentActive, this.barColors, g);
            } else {
                RudolphScrollbarPeer.paintCrippledVScrollbar(this.barOffset, 0, this.minimumThickness, this.crippledSpan, this.currentActive, this.barColors, g);
            }
        }
    }

    class HListScrollPainter
    extends ScrollPainter {
        public HListScrollPainter() {
            super(16, 16, 16, 16);
        }

        public int getPos(int x, int y) {
            return x;
        }

        public int getThickness(int width, int height) {
            return height;
        }

        public Dimension getSize(int scrollbarlength, int scrollbarthickness) {
            return new Dimension(scrollbarlength, scrollbarthickness);
        }

        public Dimension getPreferredSize(int width, int height) {
            return new Dimension(width, this.minimumThickness);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.minimumThickness);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.minimumThickness);
        }

        public Dimension getCurrentSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.minimumThickness);
        }

        public void setThickness(int width, int height) {
            this.currentThickness = height > this.minimumThickness ? height : this.minimumThickness;
        }

        public boolean setRange(int width, int height) {
            return this.setRange(width);
        }

        public int getField(int x, int y) {
            return this.getField(x);
        }

        public synchronized int setActive(int x, int y) {
            this.currentActive = y > this.barOffset ? this.getField(x) : -1;
            return this.currentActive;
        }

        public int setScreenWidth(int totalwidth, int maximumlength) {
            this.screenRange = totalwidth - this.lineUpSpan - this.lineDnSpan;
            this.barSpan = DefaultList.getInnerLength(totalwidth);
            this.barRange = maximumlength;
            if (this.screenRange <= 0) {
                this.screenRange = 0;
                this.screenSpan = 0;
                this.screenPos = 0;
                this.crippledSpan = totalwidth;
            } else {
                this.crippledSpan = -1;
                if (this.barSpan > this.barRange) {
                    this.barSpan = this.barRange;
                    this.barPos = 0;
                } else if (this.barPos + this.barSpan > this.barRange) {
                    this.barPos = this.barRange - this.barSpan;
                }
                this.setScreen();
                this.blockStep = this.barSpan > this.lineStep ? this.barSpan - this.lineStep : this.lineStep;
            }
            return this.barPos;
        }

        public void paint(Graphics g) {
            if (this.crippledSpan < 0) {
                RudolphScrollbarPeer.paintHScrollbar(0, this.barOffset, this.minimumThickness, this.paintedScreenPos, this.screenSpan, this.screenRange, this.currentActive, this.barColors, g);
            } else {
                RudolphScrollbarPeer.paintCrippledHScrollbar(0, this.barOffset, this.minimumThickness, this.crippledSpan, this.currentActive, this.barColors, g);
            }
        }
    }
}

