/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.StringTokenizer;

public class DefaultFileDialog
extends DefaultDialog
implements FileDialogPeer {
    private TextField pathtext;
    private TextField filetext;
    private TextField filtertext;
    private List folderlist;
    private List fileslist;
    private Button okbutton;
    private Button cancelbutton;
    private EventHandler eventHandler = new EventHandler();
    private FilenameFilter filter;
    private String dir = "";
    private String file;
    private boolean gui = false;
    private boolean loopback = false;

    public DefaultFileDialog(FileDialog fileDialog) {
        super(fileDialog);
    }

    public void setDirectory(String dir) {
        if (this.loopback) {
            return;
        }
        this.dir = dir;
    }

    public void setFile(String file) {
        if (this.loopback) {
            return;
        }
        this.file = file;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    public void setVisible(boolean visible) {
        if (visible && !this.gui) {
            this.buildDialog();
            this.updateLists();
        }
        super.setVisible(visible);
    }

    private void buildDialog() {
        this.gui = true;
        InsetsPanel mainpanel = new InsetsPanel(0, 4, 0, 4);
        mainpanel.setLayout(new BorderLayout(1, 1));
        Panel pathpanel = new Panel();
        pathpanel.setLayout(new BorderLayout());
        this.pathtext = new TextField(this.dir);
        this.pathtext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultFileDialog.this.dir = DefaultFileDialog.this.pathtext.getText();
                DefaultFileDialog.this.updateLists();
            }
        });
        Label pathlabel = new Label("Enter path or folder name:");
        pathpanel.add((Component)pathlabel, "North");
        pathpanel.add((Component)this.pathtext, "Center");
        Panel filepanel = new Panel();
        filepanel.setLayout(new BorderLayout());
        this.filetext = new TextField();
        this.filetext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultFileDialog.this.file = DefaultFileDialog.this.pathtext.getText();
            }
        });
        Label filelabel = new Label("Enter file name:");
        filepanel.add((Component)filelabel, "North");
        filepanel.add((Component)this.filetext, "Center");
        Panel filterpanel = new Panel();
        filterpanel.setLayout(new BorderLayout());
        Label filterlabel = new Label("Filter");
        this.filtertext = new TextField();
        this.filtertext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DefaultFileDialog.this.filtertext.getText() != "") {
                    DefaultFileDialog.this.filter = new Filter(DefaultFileDialog.this.filtertext.getText());
                } else {
                    DefaultFileDialog.this.filter = null;
                }
                DefaultFileDialog.this.updateLists();
            }
        });
        filterpanel.add((Component)filterlabel, "North");
        filterpanel.add((Component)this.filtertext, "Center");
        Panel bottompanel = new Panel();
        bottompanel.setLayout(new BorderLayout());
        bottompanel.add((Component)filepanel, "Center");
        bottompanel.add((Component)filterpanel, "East");
        Panel selectpanel = new Panel();
        selectpanel.setLayout(new GridLayout(1, 2));
        InsetsPanel selpathpanel = new InsetsPanel(0, 0, 0, 2);
        selpathpanel.setLayout(new BorderLayout());
        Label folderlabel = new Label("Folders");
        this.folderlist = new List();
        this.folderlist.addItemListener(this.eventHandler);
        selpathpanel.add((Component)folderlabel, "North");
        selpathpanel.add((Component)this.folderlist, "Center");
        InsetsPanel selfilepanel = new InsetsPanel(0, 2, 0, 0);
        selfilepanel.setLayout(new BorderLayout());
        Label fileslabel = new Label("Files");
        this.fileslist = new List();
        this.fileslist.addItemListener(this.eventHandler);
        selfilepanel.add((Component)fileslabel, "North");
        selfilepanel.add((Component)this.fileslist, "Center");
        selectpanel.add(selpathpanel);
        selectpanel.add(selfilepanel);
        mainpanel.add((Component)pathpanel, "North");
        mainpanel.add((Component)selectpanel, "Center");
        mainpanel.add((Component)bottompanel, "South");
        InsetsPanel buttonpanel = new InsetsPanel(2, 2, 2, 2);
        buttonpanel.setLayout(new GridLayout(1, 2, 2, 2));
        this.okbutton = new Button(((FileDialog)this.component).getMode() == 0 ? "Load" : "Save");
        this.cancelbutton = new Button("Cancel");
        this.okbutton.addActionListener(this.eventHandler);
        this.okbutton.setActionCommand("ok");
        this.cancelbutton.addActionListener(this.eventHandler);
        this.cancelbutton.setActionCommand("cancel");
        buttonpanel.add(this.okbutton);
        buttonpanel.add(this.cancelbutton);
        ((Dialog)this.component).add((Component)mainpanel, "Center");
        ((Dialog)this.component).add((Component)buttonpanel, "South");
    }

    private void updateLists() {
        this.folderlist.removeAll();
        this.folderlist.add("..");
        this.fileslist.removeAll();
        File currentdir = new File(this.dir);
        Object[] list = currentdir.list();
        Arrays.sort(list);
        for (int i = 0; i < list.length; ++i) {
            File current = new File(this.dir + "/" + (String)list[i]);
            if (current.isFile()) {
                if ((this.filter == null || !this.filter.accept(currentdir, (String)list[i])) && this.filter != null) continue;
                this.fileslist.add((String)list[i]);
                continue;
            }
            this.folderlist.add((String)list[i]);
        }
    }

    private class Filter
    implements FilenameFilter {
        private String filter;
        private String[] tokens;

        public Filter(String filter) {
            this.filter = filter;
            StringTokenizer stok = new StringTokenizer(filter, "*?", true);
            this.tokens = new String[stok.countTokens()];
            int i = 0;
            while (stok.hasMoreTokens()) {
                this.tokens[i++] = stok.nextToken();
            }
        }

        public boolean accept(File dir, String name) {
            return this.match(name, 0);
        }

        public boolean match(String name, int level) {
            if (level == this.tokens.length) {
                return true;
            }
            if (this.tokens[level].equals("?")) {
                return this.match(name.substring(1), level + 1);
            }
            if (this.tokens[level].equals("*")) {
                if (level == this.tokens.length - 1) {
                    return true;
                }
                boolean result = false;
                int name_length = name.length();
                for (int i = 0; i < name_length && !result; ++i) {
                    result = this.match(name.substring(i), level + 1);
                }
                return result;
            }
            if (name.startsWith(this.tokens[level])) {
                return this.match(name.substring(this.tokens[level].length()), level + 1);
            }
            return false;
        }
    }

    private class InsetsPanel
    extends Panel {
        private Insets insets;

        public InsetsPanel(int x1, int y1, int x2, int y2) {
            this.insets = new Insets(x1, y1, x2, y2);
        }

        public Insets getInsets() {
            return this.insets;
        }
    }

    private class EventHandler
    implements ItemListener,
    ActionListener {
        private EventHandler() {
        }

        public synchronized void itemStateChanged(ItemEvent event) {
            if (event.getItemSelectable() == DefaultFileDialog.this.folderlist) {
                File f = new File(DefaultFileDialog.this.dir = DefaultFileDialog.this.dir + ("/" + (String)event.getItem()));
                try {
                    DefaultFileDialog.this.dir = f.getCanonicalPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DefaultFileDialog.this.loopback = true;
                ((FileDialog)DefaultFileDialog.this.component).setDirectory(DefaultFileDialog.this.dir);
                DefaultFileDialog.this.loopback = false;
                DefaultFileDialog.this.pathtext.setText(DefaultFileDialog.this.dir);
                DefaultFileDialog.this.updateLists();
            } else {
                DefaultFileDialog.this.file = (String)event.getItem();
                DefaultFileDialog.this.filetext.setText(DefaultFileDialog.this.file);
                DefaultFileDialog.this.loopback = true;
                ((FileDialog)DefaultFileDialog.this.component).setFile(DefaultFileDialog.this.file);
                DefaultFileDialog.this.loopback = false;
            }
        }

        public synchronized void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("cancel")) {
                DefaultFileDialog.this.file = null;
            }
            if (DefaultFileDialog.this.file == "") {
                DefaultFileDialog.this.file = null;
            }
            DefaultFileDialog.this.component.setVisible(false);
            DefaultFileDialog.this.loopback = true;
            ((FileDialog)DefaultFileDialog.this.component).setFile(DefaultFileDialog.this.file);
            DefaultFileDialog.this.loopback = false;
        }
    }
}

