/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.DropTargetEvent;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.awt.event.MouseEvent;

public class DefaultDropTargetContextPeer
implements DropTargetContextPeer {
    private DragSourceContext dsc;
    private DropTarget dropTarget;
    private int targetActions;
    private int dragAction;
    private int dropAction;
    private EventDispatcher eventDispatcher;

    public DefaultDropTargetContextPeer(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
        this.eventDispatcher = new EventDispatcher();
    }

    public void acceptDrag(int dragAction) {
        this.dragAction = dragAction;
    }

    public void acceptDrop(int dropAction) {
        this.dropAction = dropAction;
    }

    public void dropComplete(boolean success) {
        DropTargetEvent.setInProgress(false, null);
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public int getTargetActions() {
        return this.targetActions;
    }

    public Transferable getTransferable() throws InvalidDnDOperationException {
        if (this.dsc == null) {
            return null;
        }
        Transferable transf = this.dsc.getTransferable();
        return transf;
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.getTransferable() == null) {
            return null;
        }
        return this.getTransferable().getTransferDataFlavors();
    }

    public boolean isTransferableJVMLocal() {
        return true;
    }

    public void rejectDrag() {
    }

    public void rejectDrop() {
    }

    public void setTargetActions(int actions) {
        this.targetActions = actions;
    }

    protected void updateDragSourceContext(DragSourceContext dsc) {
        this.dsc = dsc;
    }

    protected void processEnterMessage(DropTargetDragEvent dtde) {
        this.dropTarget.dragEnter(dtde);
        boolean accept = false;
        int source = this.dsc.getSourceActions();
        if (source == 3) {
            if (this.dragAction == 3 || this.dropAction == 1 || this.dropAction == 2) {
                accept = true;
            }
        } else if (this.dragAction == 3) {
            if (source == 1 || source == 2) {
                accept = true;
            }
        } else if (source == this.dragAction) {
            accept = true;
        }
        if (accept) {
            if (this.dropAction == 2) {
                this.dsc.setCursor(DragSource.DefaultMoveDrop);
            } else if (this.dropAction == 4 || this.dropAction == 5) {
                this.dsc.setCursor(DragSource.DefaultLinkDrop);
            } else {
                this.dsc.setCursor(DragSource.DefaultCopyDrop);
            }
        } else {
            this.dsc.setCursor(null);
        }
    }

    protected void processMotionMessage(DropTargetDragEvent dtde) {
        this.dropTarget.dragOver(dtde);
    }

    protected void processExitMessage(java.awt.dnd.DropTargetEvent dte) {
        this.dsc.setCursor(null);
        this.dropTarget.dragExit(dte);
    }

    protected void processDropMessage(DropTargetDropEvent dtde) {
        this.dsc.setCursor(null);
        this.dropTarget.drop(dtde);
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public class EventDispatcher {
        private EventDispatcher() {
        }

        public void dispatchEvent(java.awt.dnd.DropTargetEvent dte, MouseEvent me) {
            DropTargetEvent cfr_ignored_0 = (DropTargetEvent)dte;
            DefaultDropTargetContextPeer.this.updateDragSourceContext(DropTargetEvent.getDragSourceContext());
            int dropAction = DefaultDropTargetContextPeer.this.dsc.getSourceActions();
            switch (me.getID()) {
                case 504: {
                    System.out.println("MOUSE_ENTERED");
                    System.out.println("control is pressed: " + me.isControlDown());
                    System.out.println("shift is pressed: " + me.isShiftDown());
                    if (me.isControlDown() && !me.isShiftDown()) {
                        dropAction = 1;
                    }
                    if (me.isShiftDown() && !me.isControlDown()) {
                        dropAction = 2;
                    }
                    System.out.println("dsc.getSourceActions() = " + DefaultDropTargetContextPeer.this.dsc.getSourceActions());
                    System.out.println("dropAction = " + dropAction);
                    DropTargetDragEvent dtde = new DropTargetDragEvent(dte.getDropTargetContext(), me.getPoint(), dropAction, DefaultDropTargetContextPeer.this.dsc.getSourceActions());
                    this.dispatchEnterEvent(dtde);
                    break;
                }
                case 505: {
                    this.dispatchExitEvent(dte);
                    break;
                }
                case 506: {
                    System.out.println("control is pressed: " + me.isControlDown());
                    System.out.println("shift is pressed: " + me.isShiftDown());
                    if (me.isControlDown() && !me.isShiftDown()) {
                        dropAction = 1;
                    }
                    if (me.isShiftDown() && !me.isControlDown()) {
                        dropAction = 2;
                    }
                    System.out.println("dsc.getSourceActions() = " + DefaultDropTargetContextPeer.this.dsc.getSourceActions());
                    System.out.println("dropAction = " + dropAction);
                    DropTargetDragEvent dtde = new DropTargetDragEvent(dte.getDropTargetContext(), me.getPoint(), dropAction, DefaultDropTargetContextPeer.this.dsc.getSourceActions());
                    this.dispatchMotionEvent(dtde);
                    break;
                }
                case 510: {
                    System.out.println("control is pressed: " + me.isControlDown());
                    System.out.println("shift is pressed: " + me.isShiftDown());
                    if (me.isControlDown() && !me.isShiftDown()) {
                        dropAction = 1;
                    }
                    if (me.isShiftDown() && !me.isControlDown()) {
                        dropAction = 2;
                    }
                    System.out.println("dsc.getSourceActions() = " + DefaultDropTargetContextPeer.this.dsc.getSourceActions());
                    System.out.println("dropAction = " + dropAction);
                    DropTargetDropEvent dtdrope = new DropTargetDropEvent(dte.getDropTargetContext(), me.getPoint(), dropAction, DefaultDropTargetContextPeer.this.dsc.getSourceActions(), true);
                    this.dispatchDropEvent(dtdrope);
                }
            }
        }

        private void dispatchEnterEvent(DropTargetDragEvent dtde) {
            DefaultDropTargetContextPeer.this.processEnterMessage(dtde);
        }

        private void dispatchMotionEvent(DropTargetDragEvent dtde) {
            DefaultDropTargetContextPeer.this.processMotionMessage(dtde);
        }

        private void dispatchExitEvent(java.awt.dnd.DropTargetEvent dte) {
            DefaultDropTargetContextPeer.this.processExitMessage(dte);
        }

        private void dispatchDropEvent(DropTargetDropEvent dtde) {
            DefaultDropTargetContextPeer.this.processDropMessage(dtde);
        }
    }
}

