/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.peer.ChoicePeer;

public class DefaultChoice
extends DefaultComponent
implements ChoicePeer,
ItemListener,
MouseListener,
FocusListener {
    private List list;
    private Window dropwindow;
    private boolean dropped = false;
    private FontMetrics fm;
    private boolean transferFocus = false;

    public DefaultChoice(Choice choice) {
        super(choice);
        choice.addMouseListener(this);
        this.list = new List();
        this.list.addItemListener(this);
        this.dropwindow = new Window();
        this.dropwindow.setLayout(new BorderLayout());
        this.dropwindow.add((Component)this.list, "Center");
        this.dropwindow.pack();
        this.list.addFocusListener(this);
    }

    public void add(String item, int index) {
        this.list.add(item, index);
        if (this.list.getItemCount() == 1) {
            this.paint(this.getGraphics());
        }
    }

    public void addItem(String item, int index) {
        this.list.add(item, index);
        if (this.list.getItemCount() == 1) {
            this.paint(this.getGraphics());
        }
    }

    public void remove(int index) {
        this.list.remove(index);
    }

    public void select(int index) {
        if (index > 0) {
            this.list.select(index);
        }
        this.paint(this.getGraphics());
    }

    public void itemStateChanged(ItemEvent e) {
        this.dropwindow.setVisible(false);
        this.dropped = false;
        this.paint(this.getGraphics());
        if (e.getStateChange() == 2) {
            String[] items = this.list.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].equals((String)e.getItem())) continue;
                this.list.select(i);
                break;
            }
        }
        this.component.dispatchEvent(new ItemEvent((ItemSelectable)((Object)this.component), 701, e.getItem(), 1));
    }

    public void mouseClicked(MouseEvent event) {
        if (this.dropped) {
            this.dropwindow.setVisible(false);
            this.dropped = false;
            this.paint(this.getGraphics());
        } else {
            this.fm = this.component.getFontMetrics(this.component.getFont());
            Point p = this.component.getLocationOnScreen();
            this.dropped = true;
            this.paint(this.getGraphics());
            int y = this.component.getSize().height / 2 - this.fm.getHeight();
            int w = this.component.getSize().width - 5;
            int h = this.fm.getHeight() + 9;
            this.dropwindow.pack();
            this.dropwindow.setBounds(p.x, p.y + y + h + 1, w, this.dropwindow.getSize().height);
            this.dropwindow.show();
            this.transferFocus = true;
            this.list.requestFocus();
            this.transferFocus = false;
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (!this.transferFocus && this.dropped) {
            this.dropwindow.setVisible(false);
            this.dropped = false;
            this.paint(this.getGraphics());
        }
    }

    public Dimension getPreferredSize() {
        Choice choice = (Choice)this.component;
        Font f = choice.getFont();
        FontMetrics fm = this.getFontMetrics(f != null ? f : Component.DEFAULT_FONT);
        int cy = fm.getHeight() + 4;
        int cx = Math.max(this.dropwindow.getPreferredSize().width + cy, 40);
        return new Dimension(cx, cy);
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        int x = 0;
        int y = this.component.getSize().height / 2 - (g.getFontMetrics().getHeight() + 4) / 2;
        int w = this.component.getSize().width - 5;
        int h = g.getFontMetrics().getHeight() + 4;
        if (this.component.getSize().height - 1 < h) {
            h = this.component.getSize().height - 1;
        }
        int ystr = (h - (g.getFontMetrics().getHeight() + 4)) / 2 + g.getFontMetrics().getAscent() + 2;
        String text = this.list.getSelectedItem();
        if (text == null && this.list.getItemCount() > 0) {
            this.list.select(0);
            text = this.list.getItem(0);
        }
        if (text == null) {
            text = "<none>";
        }
        g.setColor(this.component.getBackground());
        g.fillRect(x, y, w, h);
        g.setColor(SystemColor.controlHighlight);
        g.drawLine(x, y + h, x + w - h, y + h);
        g.drawLine(x + w - h, y, x + w - h, y + h);
        g.setColor(SystemColor.controlShadow);
        g.drawLine(x, y, x + w - h, y);
        g.drawLine(x, y, x, y + h);
        g.setClip(x, y, w - h, h);
        if (this.component.isEnabled()) {
            g.setColor(this.component.getForeground());
        } else {
            g.setColor(SystemColor.textInactiveText);
        }
        g.drawString(text, x + 3, y + ystr);
        int bx = x + w - h + 1;
        int bw = h;
        if (this.dropped) {
            g.setColor(SystemColor.control.darker());
        } else {
            g.setColor(SystemColor.control);
        }
        g.fillRect(bx, y, bw, h);
        if (this.dropped) {
            g.setColor(SystemColor.controlHighlight);
        } else {
            g.setColor(SystemColor.controlShadow);
        }
        g.drawLine(bx, y + h, bx + bw, y + h);
        g.drawLine(bx + 1, y + h - 1, bx + bw - 1, y + h - 1);
        g.drawLine(bx + bw, y, bx + bw, y + h);
        g.drawLine(bx + bw - 1, y + 1, bx + bw - 1, y + h - 1);
        if (this.dropped) {
            g.setColor(SystemColor.controlShadow);
        } else {
            g.setColor(SystemColor.controlHighlight);
        }
        g.drawLine(bx, y, bx + bw, y);
        g.drawLine(bx + 1, y + 1, bx + bw - 1, y + 1);
        g.drawLine(bx, y, bx, y + h);
        g.drawLine(bx + 1, y + 1, bx + 1, y + h - 1);
        if (this.component.isEnabled()) {
            g.setColor(this.component.getForeground());
        } else {
            g.setColor(SystemColor.textInactiveText);
        }
        g.fillRect(bx + bw / 4 + 1, y + h / 4 + 1, bw / 2, h / 2);
    }
}

