/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.keyboard;

import com.acunia.wonka.rudolph.keyboard.KeyboardButton;
import com.acunia.wonka.rudolph.keyboard.KeyboardDefault;
import com.acunia.wonka.rudolph.taskbar.TaskBar;
import java.awt.Component;
import java.awt.Font;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.MouseEvent;

public class KeyboardScalable
extends KeyboardDefault {
    private TextField textfield;
    private TextComponent target;

    protected void buildKbd() {
        int i;
        super.buildKbd();
        this.setLayout(null);
        this.textfield = new TextField();
        this.textfield.setFont(new Font("Helvetica", 0, 12));
        this.kbdWidth = Integer.parseInt(TaskBar.getTaskBar().getProperties().getProperty("applet.keyboard.width", "240"));
        this.kbdHeight = Integer.parseInt(TaskBar.getTaskBar().getProperties().getProperty("applet.keyboard.height", "81"));
        this.kbdHeight -= this.textfield.getPreferredSize().height;
        this.add(this.textfield);
        this.textfield.setBounds(2, 0, this.kbdWidth - 4, this.textfield.getPreferredSize().height);
        for (i = 0; i < this.keys_nrs.size(); ++i) {
            ((KeyboardButton)this.keys_nrs.elementAt(i)).setScale(this.kbdWidth, this.kbdHeight, 240, 81);
            ((KeyboardButton)this.keys_nrs.elementAt(i)).setTranslate(0, this.textfield.getPreferredSize().height);
        }
        for (i = 0; i < this.keys_low.size(); ++i) {
            ((KeyboardButton)this.keys_low.elementAt(i)).setScale(this.kbdWidth, this.kbdHeight, 240, 81);
            ((KeyboardButton)this.keys_low.elementAt(i)).setTranslate(0, this.textfield.getPreferredSize().height);
        }
        for (i = 0; i < this.keys_cap.size(); ++i) {
            ((KeyboardButton)this.keys_cap.elementAt(i)).setScale(this.kbdWidth, this.kbdHeight, 240, 81);
            ((KeyboardButton)this.keys_cap.elementAt(i)).setTranslate(0, this.textfield.getPreferredSize().height);
        }
    }

    public void open() {
        super.open();
        this.lastSource = Component.getFocusComponent();
        this.textfield.requestFocus();
        if (this.lastSource instanceof TextComponent) {
            this.target = (TextComponent)this.lastSource;
            this.textfield.setText(this.target.getText());
            this.textfield.setCaretPosition(this.target.getCaretPosition());
            this.textfield.select(this.target.getSelectionStart(), this.target.getSelectionEnd());
        }
    }

    public void close() {
        super.close();
        if (this.target != null) {
            this.target.requestFocus();
        }
    }

    public void sendKeyEvent(Component source, int id, int modifiers, int keyCode, char keyChar) {
        if (this.target != null) {
            this.target.setCaretPosition(this.textfield.getCaretPosition());
            this.target.select(this.textfield.getSelectionStart(), this.textfield.getSelectionEnd());
            super.sendKeyEvent(this.target, id, modifiers, keyCode, keyChar);
            this.textfield.setText(this.target.getText());
            this.textfield.setCaretPosition(this.target.getCaretPosition());
            this.textfield.select(this.target.getSelectionStart(), this.target.getSelectionEnd());
        }
    }

    public void mousePressed(MouseEvent e) {
        this.textfield.requestFocus();
        super.mousePressed(e);
    }
}

