/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.DefaultRMISocketFactory;
import com.acunia.wonka.rmi.ParameterSet;
import com.acunia.wonka.rmi.RMIConnection;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;

public class UnicastRef
implements RemoteRef {
    static final String REF_TYPE = "UnicastRef";
    String address;
    int port;
    ObjID id;
    RMIClientSocketFactory csf;

    public UnicastRef() {
        this.csf = DefaultRMISocketFactory.theDefault;
    }

    public UnicastRef(String address, int port, ObjID id, RMIClientSocketFactory csf) {
        this.address = address;
        this.port = port;
        this.id = id;
        this.csf = csf != null ? csf : DefaultRMISocketFactory.theDefault;
    }

    public String getRefClass(ObjectOutput out) {
        return REF_TYPE;
    }

    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        Socket s = this.csf.createSocket(this.address, this.port);
        Class ret = method.getReturnType();
        boolean type = ret != Void.TYPE;
        Object o = type && ret.isPrimitive() ? RMIConnection.requestPrimitive(s, opnum, -1, this.id, new ParameterSet(method, params), ret) : RMIConnection.requestObject(s, opnum, -1, this.id, new ParameterSet(method, params), type);
        return o;
    }

    public boolean remoteEquals(RemoteRef obj) {
        if (obj instanceof UnicastRef) {
            UnicastRef ref = (UnicastRef)obj;
            return this.address.equals(ref.address) && this.port == ref.port && this.id.equals(ref.id);
        }
        return false;
    }

    public int remoteHashCode() {
        return this.hashCode();
    }

    public String remoteToString() {
        return this.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.address = in.readUTF();
        this.port = in.readInt();
        this.id = ObjID.read(in);
        boolean bool = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.address);
        out.writeInt(this.port);
        this.id.write(out);
        out.writeBoolean(false);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(super.toString());
        return str.toString();
    }

    public void invoke(RemoteCall call) throws Exception {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }

    public void done(RemoteCall call) throws RemoteException {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] op, int opnum, long hash) throws RemoteException {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }
}

