/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.ObjIDData;
import com.acunia.wonka.rmi.ParameterSet;
import com.acunia.wonka.rmi.RMIConnection;
import com.acunia.wonka.rmi.RMIObjectInputStream;
import com.acunia.wonka.rmi.RMIObjectOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.UID;
import java.util.WeakHashMap;

class RMIRequestHandler
extends Thread {
    static final WeakHashMap clientHostNames = new WeakHashMap(13);
    private Socket s;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        WeakHashMap weakHashMap = clientHostNames;
        synchronized (weakHashMap) {
            clientHostNames.put(this, this.s.getInetAddress().getHostName());
        }
        try {
            try {
                RMIConnection.serverSideHandShake(this.s);
                InputStream in = this.s.getInputStream();
                DataOutputStream out = new DataOutputStream(this.s.getOutputStream());
                DataInputStream din = new DataInputStream(in);
                String address = din.readUTF();
                int port = din.readInt();
                while (true) {
                    int type;
                    if ((type = din.read()) == 80) {
                        RMIObjectInputStream oin = new RMIObjectInputStream(new PushbackInputStream(in));
                        ObjID id = ObjID.read(oin);
                        int operation = oin.readInt();
                        long hash = oin.readLong();
                        if (hash == -669196253586618813L) {
                            this.dirty(oin, operation, out);
                            continue;
                        }
                        ObjIDData data = (ObjIDData)RMIConnection.idData.get(id);
                        if (data == null) {
                            RMIConnection.wrapException(out, new NoSuchObjectException("object not found"));
                            continue;
                        }
                        Method method = (Method)data.methods.get(new Long(hash));
                        if (method == null) {
                            RMIConnection.wrapException(out, new NoSuchObjectException("method with hash '" + hash + "' not found in object"));
                            continue;
                        }
                        this.dispatch(oin, operation, out, data, method);
                        continue;
                    }
                    if (type == 82) {
                        out.write(83);
                        continue;
                    }
                    if (type == -1) break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Object var2_17 = null;
        }
        catch (Throwable throwable) {
            Object var2_16 = null;
            try {
                this.s.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        this.s.close();
        weakHashMap = clientHostNames;
        synchronized (weakHashMap) {
            clientHostNames.remove(this);
            return;
        }
    }

    private final void dirty(ObjectInputStream oin, int operation, OutputStream out) throws IOException, ClassNotFoundException {
        out.write(81);
        RMIObjectOutputStream oout = new RMIObjectOutputStream(out);
        if (operation == 1) {
            ObjID[] id = (ObjID[])oin.readObject();
            long sequenceNumber = oin.readLong();
            Lease lease = (Lease)oin.readObject();
            oout.write(1);
            new UID().write(oout);
            VMID vmID = lease.getVMID();
            oout.writeObject(new Lease(vmID, lease.getValue()));
        } else if (operation == 0) {
            ObjID[] id = (ObjID[])oin.readObject();
            long sequenceNumber = oin.readLong();
            VMID vmid = (VMID)oin.readObject();
            boolean strong = oin.readBoolean();
            oout.write(1);
            new UID().write(oout);
        } else {
            oout.write(2);
            new UID().write(oout);
            oout.writeObject(new RemoteException("invalid operation"));
        }
        oout.flush();
    }

    private final void dispatch(ObjectInputStream oin, int operation, OutputStream out, ObjIDData data, Method method) throws IOException, ClassNotFoundException {
        Class[] classes = method.getParameterTypes();
        Object[] params = new Object[classes.length];
        int i = 0;
        while (i < classes.length) {
            params[i] = classes[i].isPrimitive() ? ParameterSet.readPrimitive(classes[i], oin) : oin.readObject();
            ++i;
        }
        try {
            Object o = method.invoke(data.impl, params);
            out.write(81);
            RMIObjectOutputStream oout = new RMIObjectOutputStream(out);
            oout.write(1);
            new UID().write(oout);
            Class returntype = method.getReturnType();
            if (returntype != Void.TYPE) {
                if (returntype.isPrimitive()) {
                    ParameterSet.writePrimitive(returntype, o, oout);
                } else {
                    oout.writeObject(o);
                }
            }
            oout.flush();
        }
        catch (IllegalAccessException iae) {
            RMIConnection.wrapException(out, iae);
        }
        catch (InvocationTargetException ite) {
            RMIConnection.wrapException(out, ite);
        }
    }

    RMIRequestHandler(Socket s) {
        super("RMIRequestHandler Thread " + s);
        this.s = s;
        try {
            s.setSoLinger(true, 30000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.start();
    }
}

