/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.RMIConnection;
import com.acunia.wonka.rmi.RMIObjectInputStream;
import com.acunia.wonka.rmi.RegistryConstants;
import com.acunia.wonka.rmi.RegistryImpl;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;

class RMIRegistryRequest
extends Thread
implements RegistryConstants {
    private Socket s;
    private RegistryImpl registry;

    RMIRegistryRequest(Socket s, RegistryImpl registry) {
        super("RMIRegistryRequest Thread " + s);
        this.s = s;
        try {
            s.setSoLinger(true, 30000);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.registry = registry;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        OutputStream out = null;
        try {
            out = this.s.getOutputStream();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            int type;
            RMIConnection.serverSideHandShake(this.s);
            InputStream in = this.s.getInputStream();
            DataInputStream din = new DataInputStream(in);
            String address = din.readUTF();
            int port = din.readInt();
            while ((type = din.read()) != -1) {
                if (type == 80) {
                    RMIObjectInputStream oin = new RMIObjectInputStream(new PushbackInputStream(in));
                    ObjID id = ObjID.read(oin);
                    int operation = oin.readInt();
                    long hash = oin.readLong();
                    if (hash != 4905912898345647071L) {
                        RMIConnection.writeException(out, "unkwown request");
                        continue;
                    }
                    switch (operation) {
                        case 0: 
                        case 3: {
                            this.handleBind(oin, operation == 3);
                            break;
                        }
                        case 2: {
                            String name = (String)oin.readObject();
                            RMIConnection.writeResponse(out, this.registry.lookup(name));
                            break;
                        }
                        case 1: {
                            RMIConnection.writeResponse(out, this.registry.list());
                            break;
                        }
                        case 4: {
                            String remove = (String)oin.readObject();
                            this.registry.unbind(remove);
                            RMIConnection.writeVoidResponse(out);
                            break;
                        }
                        default: {
                            RMIConnection.writeException(out, "unkwown request");
                        }
                    }
                    continue;
                }
                if (type == 82) {
                    out.write(83);
                    continue;
                }
                RMIConnection.writeException(out, new RemoteException("invalid request"));
            }
        }
        catch (RemoteException rt) {
            RMIConnection.writeException(out, rt);
        }
        catch (Exception e) {
            e.printStackTrace();
            RMIConnection.wrapException(out, e);
        }
        finally {
            try {
                this.s.close();
            }
            catch (IOException _) {}
        }
    }

    private void handleBind(ObjectInputStream oin, boolean rebind) throws IOException, AlreadyBoundException, ClassNotFoundException {
        String name = (String)oin.readObject();
        Remote stub = (Remote)oin.readObject();
        if (rebind) {
            this.registry.rebind(name, stub);
        } else {
            this.registry.bind(name, stub);
        }
        RMIConnection.writeVoidResponse(this.s.getOutputStream());
    }
}

