/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.DGCClientReference;
import com.acunia.wonka.rmi.RMIConnection;
import com.acunia.wonka.rmi.RMIObjectInputStream;
import com.acunia.wonka.rmi.RMIObjectOutputStream;
import com.acunia.wonka.rmi.UnicastRef;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.ref.ReferenceQueue;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.dgc.Lease;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.Vector;
import wonka.vm.SystemTimer;

public class DGCClient {
    private static final ObjID DGCID = new ObjID(2);
    private static final ObjID[] ID_ARRAY = new ObjID[0];
    private static final ReferenceQueue QUEUE = new ReferenceQueue();
    private static final Lease LEASE = new Lease(RMIConnection.TheVMID, Long.getLong("java.rmi.dgc.leaseValue", 600000L));
    private static Hashtable remotes = new Hashtable(11);
    private static Hashtable DGCClients = new Hashtable(7);
    private static long sequenceNumber;
    private static DGCClientTask cleanerTask;
    private Vector ids = new Vector();
    private DGCClientTask currentTask;
    private int port;
    private String address;
    private RMIClientSocketFactory csf;
    private long duration;

    static void registerRemote(Remote obj) {
        if (obj instanceof RemoteObject) {
            RemoteObject remote = (RemoteObject)obj;
            DGCClient.registerObject(remote.getRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized void registerObject(RemoteRef obj) {
        Object o = remotes.get(obj);
        if (o != null || !(obj instanceof UnicastRef)) return;
        UnicastRef ref = (UnicastRef)obj;
        String key = ref.address + ref.port;
        DGCClient client = (DGCClient)DGCClients.get(key);
        if (client == null) {
            client = new DGCClient(ref.address, ref.port, ref.csf);
        }
        DGCClientReference dgcRef = new DGCClientReference(obj, QUEUE, ref.id);
        remotes.put(dgcRef, client);
        Hashtable hashtable = DGCClients;
        synchronized (hashtable) {
            DGCClients.put(key, client);
            if (cleanerTask == null) {
                cleanerTask = new DGCClientTask();
                SystemTimer.scheduleSystemTask(cleanerTask, 750L);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl19 : MonitorExitStatement: MONITOREXIT : var6_6
            new Registrator(dgcRef, obj, client, ref.id);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void add(ObjID id, Object key) throws IOException {
        Lease lease = this.reportDirty(new ObjID[]{id});
        if (lease != null) {
            long value = lease.getValue();
            this.ids.add(id);
            if (value < this.duration) {
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                }
                if (value < 500L) {
                    value = 500L;
                }
                this.duration = value;
                this.currentTask = new DGCClientTask(this);
                SystemTimer.scheduleOneTimeSystemTask(this.currentTask, value);
                return;
            }
            if (this.currentTask != null) return;
            this.currentTask = new DGCClientTask(this);
            if ((value -= 500L) < 500L) {
                value = 500L;
            }
            SystemTimer.scheduleOneTimeSystemTask(this.currentTask, value);
            return;
        }
        remotes.remove(key);
        if (!this.ids.isEmpty()) return;
        Hashtable hashtable = DGCClients;
        synchronized (hashtable) {
            DGCClients.remove(this.address + this.port);
            if (!DGCClients.isEmpty()) return;
            if (cleanerTask == null) return;
            cleanerTask.cancel();
            cleanerTask = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void remove(ObjID id, Object key) throws IOException {
        if (!this.ids.remove(id)) return;
        this.reportClean(new ObjID[]{id}, this.csf.createSocket(this.address, this.port), false);
        if (!this.ids.isEmpty()) return;
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
        Hashtable hashtable = DGCClients;
        synchronized (hashtable) {
            DGCClients.remove(this.address + this.port);
            if (!DGCClients.isEmpty() || cleanerTask == null) return;
            cleanerTask.cancel();
            cleanerTask = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void renewLeases() throws IOException {
        ObjID[] o = (ObjID[])this.ids.toArray(ID_ARRAY);
        if (o == ID_ARRAY) {
            this.currentTask = null;
            return;
        }
        Lease lease = this.reportDirty(o);
        if (lease != null) {
            long duration = lease.getValue() - 500L;
            if (duration < 500L) {
                duration = 500L;
            }
            this.duration = duration;
            this.currentTask = new DGCClientTask(this);
            SystemTimer.scheduleOneTimeSystemTask(this.currentTask, duration);
            return;
        }
        Hashtable hashtable = DGCClients;
        synchronized (hashtable) {
            DGCClients.remove(this.address + this.port);
            if (!DGCClients.isEmpty()) return;
            if (cleanerTask == null) return;
            cleanerTask.cancel();
            cleanerTask = null;
            return;
        }
    }

    private final void reportClean(Object arg, Socket socket, boolean strong) {
        try {
            RMIConnection.handShake(socket);
            OutputStream out = socket.getOutputStream();
            out.write(80);
            RMIObjectOutputStream oos = new RMIObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            DGCID.write(oos);
            oos.writeInt(0);
            oos.writeLong(-669196253586618813L);
            oos.writeObject(arg);
            oos.writeLong(sequenceNumber++);
            oos.writeObject(RMIConnection.TheVMID);
            oos.writeBoolean(strong);
            oos.flush();
            InputStream in = socket.getInputStream();
            int rd = in.read();
            RMIObjectInputStream ois = new RMIObjectInputStream(new PushbackInputStream(in));
            rd = ois.read();
            UID uid = UID.read(ois);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private final Lease reportDirty(Object arg) throws IOException {
        Socket socket = null;
        try {
            socket = this.csf.createSocket(this.address, this.port);
            RMIConnection.handShake(socket);
            OutputStream out = socket.getOutputStream();
            out.write(80);
            RMIObjectOutputStream oos = new RMIObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            DGCID.write(oos);
            oos.writeInt(1);
            oos.writeLong(-669196253586618813L);
            oos.writeObject(arg);
            oos.writeLong(sequenceNumber++);
            oos.writeObject(LEASE);
            oos.flush();
            InputStream in = socket.getInputStream();
            int rd = in.read();
            RMIObjectInputStream ois = new RMIObjectInputStream(new PushbackInputStream(in));
            rd = ois.read();
            UID uid = UID.read(ois);
            Object o = ois.readObject();
            if (o instanceof Lease) {
                return (Lease)o;
            }
        }
        catch (RemoteException e) {
            this.reportClean(arg, socket, true);
        }
        catch (IOException io) {
            if (socket != null) {
                socket.close();
                this.reportClean(arg, this.csf.createSocket(this.address, this.port), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private DGCClient(String addr, int p, RMIClientSocketFactory fact) {
        this.address = addr;
        this.port = p;
        this.csf = fact;
    }

    static class DGCClientTask
    extends TimerTask {
        private boolean started;
        private boolean cleanUp;
        private DGCClient client;

        public void run() {
            if (this.cleanUp) {
                try {
                    DGCClientReference ref = (DGCClientReference)QUEUE.poll();
                    while (ref != null) {
                        new Registrator((DGCClient)remotes.remove(ref), ref.id, ref);
                        ref = (DGCClientReference)QUEUE.poll();
                    }
                }
                catch (Throwable t) {}
            } else if (!this.started) {
                this.started = true;
                new Thread(this, "DGCClientTask Thread " + this).start();
            } else {
                try {
                    this.client.renewLeases();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        DGCClientTask(DGCClient client) {
            this.client = client;
        }

        DGCClientTask() {
            this.cleanUp = true;
        }
    }

    static class Registrator
    implements Runnable {
        private Object key;
        private Object remote;
        private DGCClient client;
        private ObjID id;
        private boolean remove;

        public void run() {
            try {
                if (this.remove) {
                    this.client.remove(this.id, this.key);
                } else {
                    this.client.add(this.id, this.key);
                }
            }
            catch (IOException re) {
                re.printStackTrace();
            }
        }

        Registrator(Object key, RemoteRef obj, DGCClient c, ObjID id) {
            this.remote = obj;
            this.client = c;
            this.key = key;
            this.id = id;
            new Thread(this, "DGCClient$Registrator for " + id).start();
        }

        Registrator(DGCClient c, ObjID id, Object key) {
            this.remove = true;
            this.client = c;
            this.id = id;
            this.key = key;
            new Thread(this, "DGCClient$Registrator for " + id).start();
        }
    }
}

