/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.net.http;

import com.acunia.wonka.net.http.BasicHttpURLConnection;
import java.io.IOException;
import java.io.OutputStream;

class HttpOutputStream
extends OutputStream {
    private static final byte[] CHUNKED = "Transfer-Encoding: chunked\r\n\r\n".getBytes();
    private static final byte[] NEWLINE = new byte[]{13, 10};
    private OutputStream out;
    private int count;
    private byte[] buffer;
    private boolean closed;
    private boolean chunked;
    private BasicHttpURLConnection httpCon;

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.chunked) {
                if (this.count > 0) {
                    this.flushBuffer(this.buffer, 0);
                }
                this.out.write(48);
                this.out.write(NEWLINE, 0, 2);
                this.out.write(NEWLINE, 0, 2);
            } else {
                this.out.write(("content-length: " + this.count + "\r\n\r\n").getBytes());
                this.out.write(this.buffer, 0, this.count);
                this.buffer = null;
            }
            this.out.flush();
            this.httpCon.parseResponse();
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.chunked && this.count > 0) {
            this.flushBuffer(this.buffer, 0);
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.count == this.buffer.length) {
            this.flushBuffer(this.buffer, 0);
        }
        this.buffer[this.count++] = (byte)b;
    }

    public void write(byte[] bytes, int off, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (length > this.buffer.length - this.count) {
            if (this.count > 0) {
                this.flushBuffer(this.buffer, 0);
            }
            if (length > this.buffer.length) {
                this.count = length;
                this.flushBuffer(bytes, off);
                return;
            }
        }
        System.arraycopy(bytes, off, this.buffer, this.count, length);
        this.count += length;
    }

    private final void flushBuffer(byte[] buf, int off) throws IOException {
        if (!this.chunked) {
            this.chunked = true;
            this.out.write(CHUNKED, 0, CHUNKED.length);
        }
        this.out.write((Integer.toHexString(this.count) + "\r\n").getBytes());
        this.out.write(buf, off, this.count);
        this.count = 0;
        this.out.write(NEWLINE, 0, 2);
        this.out.flush();
    }

    HttpOutputStream(OutputStream out, BasicHttpURLConnection httpC) throws IOException {
        this.out = out;
        this.httpCon = httpC;
        this.buffer = new byte[4096];
    }
}

