/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.net.handlers;

import com.acunia.wonka.rudolph.GIFImageSource;
import com.acunia.wonka.rudolph.JPEGImageSource;
import com.acunia.wonka.rudolph.PNGImageSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ContentHandler;
import java.net.URLConnection;

public class ImageContentHandler
extends ContentHandler {
    public Object getContent(URLConnection urlconn) throws IOException {
        byte[] bytes;
        String type = urlconn.getContentType();
        try {
            int len = urlconn.getContentLength();
            if (len > -1) {
                bytes = new byte[len];
                InputStream in = urlconn.getInputStream();
                int rd = in.read(bytes, 0, len);
                while (rd < len) {
                    int b = in.read(bytes, rd, len - rd);
                    if (b == -1) {
                        byte[] old = bytes;
                        bytes = new byte[rd];
                        System.arraycopy(old, 0, bytes, 0, rd);
                    }
                    rd += b;
                }
            } else {
                ByteArrayOutputStream bas = new ByteArrayOutputStream(2048);
                InputStream in = urlconn.getInputStream();
                bytes = new byte[1024];
                len = in.read(bytes, 0, 1024);
                while (len != -1) {
                    bas.write(bytes, 0, len);
                    len = in.read(bytes, 0, 1024);
                }
                bytes = bas.toByteArray();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (type.equals("image/gif")) {
            return new GIFImageSource(bytes);
        }
        if (type.equals("image/jpg") || type.equals("image/jpeg")) {
            return new JPEGImageSource(bytes);
        }
        if (type.equals("image/png")) {
            return new PNGImageSource(bytes);
        }
        return null;
    }
}

