/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.device.uart;

import com.acunia.device.uart.UARTControlStream;
import com.acunia.device.uart.UARTInputStream;
import com.acunia.device.uart.UARTOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UART
extends SerialPort
implements Runnable {
    private static final int BOGUS_ANSWER = 42;
    private int baudRate;
    private int dataBits;
    private int stopBits;
    private int parity;
    private int flowControlMode;
    private boolean rxThresholdEnabled;
    private boolean rxTimeoutEnabled;
    private boolean dtr;
    private boolean rts;
    private SerialPortEventListener eventlistener;
    private BitSet notifyon;
    private UARTInputStream in;
    private UARTOutputStream out;
    private UARTControlStream control;
    private Thread eventthread;

    public int getBaudRate() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.baudRate;
    }

    public int getDataBits() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.dataBits;
    }

    public int getStopBits() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.stopBits;
    }

    public int getParity() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.parity;
    }

    public void sendBreak(int millis) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.control.sendbreak(millis);
    }

    public void setFlowControlMode(int flowcontrol) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if ((flowcontrol & 3) != flowcontrol) {
            throw new UnsupportedCommOperationException();
        }
        this.control.setflowcontrol(flowcontrol);
        this.flowControlMode = flowcontrol;
    }

    public int getFlowControlMode() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.flowControlMode;
    }

    public void setSerialPortParams(int baudrate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (dataBits > 8 || dataBits < 5) {
            throw new UnsupportedCommOperationException();
        }
        if (stopBits < 1 || stopBits > 3) {
            throw new UnsupportedCommOperationException();
        }
        if (parity < 0 || parity > 4) {
            throw new UnsupportedCommOperationException();
        }
        if (baudrate <= 0) {
            throw new UnsupportedCommOperationException();
        }
        this.control.setdatabits(dataBits);
        this.dataBits = dataBits;
        this.control.setstopbits(stopBits);
        this.stopBits = stopBits;
        this.control.setparity(parity);
        this.parity = parity;
        this.baudRate = this.control.setbaudrate(baudrate);
    }

    public void setDTR(boolean newdtr) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.control.setdtr(newdtr);
        this.dtr = newdtr;
    }

    public boolean isDTR() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.dtr;
    }

    public void setRTS(boolean newrts) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.control.setrts(newrts);
        this.rts = newrts;
    }

    public boolean isRTS() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.rts;
    }

    public boolean isCTS() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.control.getcts();
    }

    public boolean isDSR() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.control.getdsr();
    }

    public boolean isRI() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.control.getri();
    }

    public boolean isCD() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.control.getcd();
    }

    public synchronized void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.eventlistener != null) {
            throw new TooManyListenersException();
        }
        this.eventlistener = lsnr;
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        this.eventthread = new Thread(this, this.getName() + " event notifier");
        this.eventthread.start();
    }

    public void removeEventListener() {
        this.notifyon = null;
        this.eventthread = null;
        this.eventlistener = null;
    }

    public void notifyOnDataAvailable(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(1);
        } else {
            this.notifyon.clear(1);
        }
    }

    public void notifyOnOutputEmpty(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(2);
        } else {
            this.notifyon.clear(2);
        }
    }

    public void notifyOnCTS(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(3);
        } else {
            this.notifyon.clear(3);
        }
    }

    public void notifyOnDSR(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(4);
        } else {
            this.notifyon.clear(4);
        }
    }

    public void notifyOnRingIndicator(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(5);
        } else {
            this.notifyon.clear(5);
        }
    }

    public void notifyOnCarrierDetect(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(6);
        } else {
            this.notifyon.clear(6);
        }
    }

    public void notifyOnOverrunError(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(7);
        } else {
            this.notifyon.clear(7);
        }
    }

    public void notifyOnParityError(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(8);
        } else {
            this.notifyon.clear(8);
        }
    }

    public void notifyOnFramingError(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(9);
        } else {
            this.notifyon.clear(9);
        }
    }

    public void notifyOnBreakInterrupt(boolean enable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.notifyon == null) {
            this.notifyon = new BitSet(11);
        }
        if (enable) {
            this.notifyon.set(10);
        } else {
            this.notifyon.clear(10);
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new UARTInputStream(this.name);
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new UARTOutputStream(this.name);
        }
        return this.out;
    }

    public void enableReceiveThreshold(int thresh) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.in != null) {
            this.in.setRxThreshold(thresh);
        }
        this.rxThresholdEnabled = true;
    }

    public void disableReceiveThreshold() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.in != null) {
            this.in.clearRxThreshold();
        }
        this.rxThresholdEnabled = false;
    }

    public boolean isReceiveThresholdEnabled() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.rxThresholdEnabled;
    }

    public int getReceiveThreshold() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return 42;
    }

    public void enableReceiveTimeout(int rcvTimeout) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.in != null) {
            this.in.setRxTimeout(rcvTimeout);
        }
        this.rxTimeoutEnabled = true;
    }

    public void disableReceiveTimeout() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.in != null) {
            this.in.clearRxTimeout();
        }
        this.rxTimeoutEnabled = false;
    }

    public boolean isReceiveTimeoutEnabled() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.rxTimeoutEnabled;
    }

    public int getReceiveTimeout() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return 42;
    }

    public void enableReceiveFraming(int framingByte) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        throw new UnsupportedCommOperationException();
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return false;
    }

    public int getReceiveFramingByte() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return 42;
    }

    public void setInputBufferSize(int i) {
    }

    public int getInputBufferSize() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return 42;
    }

    public void setOutputBufferSize(int i) {
    }

    public int getOutputBufferSize() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return 42;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.eventlistener != null) {
            SerialPortEvent newevent = this.control.getevent(this);
            UART uART = this;
            synchronized (uART) {
                if (this.eventlistener == null) {
                    return;
                }
                if (this.notifyon.get(newevent.getEventType())) {
                    this.eventlistener.serialEvent(newevent);
                }
            }
        }
    }

    public synchronized void close() {
        super.close();
        this.control.close();
    }

    private final /* synthetic */ void this() {
        this.rxThresholdEnabled = false;
        this.rxTimeoutEnabled = false;
        this.dtr = false;
        this.rts = false;
    }

    public UART(String name) throws SecurityException, IOException {
        this.this();
        this.name = name;
        this.control = new UARTControlStream(name);
        try {
            this.baudRate = this.control.getbaudrate();
            this.dataBits = this.control.getdatabits();
            this.stopBits = this.control.getstopbits();
            this.parity = this.control.getparity();
            this.flowControlMode = this.control.getflowcontrol();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

