/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonkax.microedition.io.Connector;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class AcuniaConnectorTest
implements Testlet,
Runnable {
    protected TestHarness th;
    private int port;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("javax.microedition.io.Connector");
        this.test_Datagram();
        this.test_Socket();
        this.test_ServerSocket();
        this.test_File();
        this.test_URL();
    }

    public void test_Datagram() {
        this.th.checkPoint("datagram");
        String text = "This is a simple test for datagram protocol of the javax.microedition.io API";
        String response = "I got the Message. It all works fine";
        try {
            this.port = 29666;
            Connection c1 = Connector.open((String)("datagram://:" + this.port + ";timeout=5234"));
            this.th.check(c1 instanceof DatagramConnection, "checking connection type");
            Connection c2 = Connector.open((String)("datagram://localhost:" + this.port + ";timeout=1234"));
            this.th.check(c2 instanceof DatagramConnection, "checking connection type");
            DatagramConnection dc2 = (DatagramConnection)c2;
            Datagram dgram2 = dc2.newDatagram(128);
            dgram2.writeUTF(text);
            dc2.send(dgram2);
            DatagramConnection dc1 = (DatagramConnection)c1;
            Datagram dgram1 = dc1.newDatagram(128);
            dc1.receive(dgram1);
            this.th.check(dgram1.readUTF(), text, "checking message");
            dgram1.reset();
            dgram1.writeUTF(response);
            dc1.send(dgram1);
            dgram2.reset();
            dc2.receive(dgram2);
            this.th.check(dgram2.readUTF(), response, "checking response message");
            try {
                dgram2.readBoolean();
                this.th.fail("should throw an EOFException");
            }
            catch (EOFException eofe) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("unwanted exception " + e);
            e.printStackTrace();
        }
    }

    public void test_Socket() {
        this.th.checkPoint("socket");
        Thread t = null;
        try {
            ServerSocket ss = new ServerSocket(29999);
            ss.setSoTimeout(1000);
            this.port = 29999;
            t = new Thread((Runnable)this, this.toString() + " SOCKET");
            t.start();
            Socket s = ss.accept();
            s.setSoTimeout(1000);
            InputStream in = s.getInputStream();
            byte[] bytes = new byte[256];
            int len = in.read(bytes);
            OutputStream out = s.getOutputStream();
            out.write(bytes, 0, len);
            s.close();
            t.join(1000L);
        }
        catch (BindException se) {
            this.th.debug("problems occured on serverside to create server");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception " + e);
            try {
                if (t != null) {
                    t.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        try {
            Connection c = Connector.open((String)("socket://localhost:" + this.port + ";timeout=12345"));
            this.th.check(c instanceof StreamConnection, "checking connection type");
            StreamConnection sc = (StreamConnection)c;
            OutputStream out = sc.openOutputStream();
            InputStream in = sc.openInputStream();
            String text = "testing the 'socket' connecting scheme via the javax.microedition.io API's";
            out.write(text.getBytes());
            byte[] bytes = new byte[256];
            int len = in.read(bytes);
            this.th.check(new String(bytes, 0, len), text, "checking message");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception " + e);
        }
    }

    public void test_ServerSocket() {
        this.th.checkPoint("serversocket");
        Thread t = null;
        try {
            Connection c = Connector.open((String)"serversocket://29998;timeout=1000", (int)3, (boolean)true);
            this.th.check(c instanceof StreamConnectionNotifier, "checking connection type -- 1");
            StreamConnectionNotifier scn = (StreamConnectionNotifier)c;
            this.port = 29998;
            t = new Thread((Runnable)this, this.toString() + " SERVERSOCKET");
            t.start();
            c = scn.acceptAndOpen();
            this.th.check(c instanceof StreamConnection, "checking connection type -- 2");
            StreamConnection sc = (StreamConnection)c;
            InputStream in = sc.openInputStream();
            byte[] bytes = new byte[256];
            int len = in.read(bytes);
            OutputStream out = sc.openOutputStream();
            out.write(bytes, 0, len);
            t.join(1000L);
        }
        catch (ConnectionNotFoundException cnfe) {
            this.th.debug("problems occured on serverside to create server");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception " + e);
            try {
                if (t != null) {
                    t.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void test_File() {
        this.th.checkPoint("file");
        String name = "/test/AcuniaConnectorTestFile";
        String text = "This is a simple test string\n";
        try {
            Connection c = Connector.open((String)"file:/system/system.properties", (int)1);
            this.th.check(c instanceof InputConnection);
            InputConnection in = (InputConnection)c;
            in.close();
            in.close();
            try {
                in.openInputStream();
                this.th.fail("connection is closed no streams may be created");
            }
            catch (IOException ioe) {
                this.th.check(true);
            }
        }
        catch (IOException ioe) {
            this.th.fail("unwanted Exception" + ioe + " -- 1");
        }
        File f = new File(name);
        if (f.isFile()) {
            this.th.check(f.delete(), "Unable to remove testfile");
        }
        try {
            Connection c = Connector.open((String)("file:" + name + ";nosuchOption=OK"), (int)2);
            this.th.check(c instanceof OutputConnection);
            OutputConnection out = (OutputConnection)c;
            DataOutputStream dos = out.openDataOutputStream();
            out.close();
            out.close();
            try {
                out.openOutputStream();
                this.th.fail("should throw an IOException");
            }
            catch (IOException ioe) {
                this.th.check(true);
            }
            dos.writeUTF(text);
            dos.close();
            c = Connector.open((String)("file:" + name + ";append=true"));
            this.th.check(c instanceof StreamConnection);
            StreamConnection stream = (StreamConnection)c;
            dos = stream.openDataOutputStream();
            DataInputStream dis = stream.openDataInputStream();
            stream.close();
            stream.close();
            try {
                stream.openOutputStream();
                this.th.fail("should throw an IOException");
            }
            catch (IOException ioe) {
                this.th.check(true);
            }
            dos.writeUTF(text);
            dos.close();
            this.th.check(dis.readUTF(), (Object)text);
            this.th.check(dis.readUTF(), (Object)text);
            dis.close();
        }
        catch (IOException ioe) {
            this.th.fail("unwanted Exception " + ioe + " -- 1");
        }
    }

    public void test_URL() {
        this.th.checkPoint("URL");
        try {
            Connection c = Connector.open((String)"jar:file:/test/mauve-suite.jar!/gnu/testlet/wonkax/microedition/io/Connector/AcuniaConnectorTest.class;a=b");
            this.th.check(c instanceof ContentConnection);
            ContentConnection cc = (ContentConnection)c;
            InputStream in = cc.openInputStream();
            this.th.check(in.read(new byte[128]), 128, "reading bytes from entry");
        }
        catch (IOException ioe) {
            this.th.fail("unwanted Exception " + ioe);
            ioe.printStackTrace();
        }
    }
}

