/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.SimpleTimeZone;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class SMSimpleTimeZoneTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.SimpleTimeZone");
        this.test_SimpleTimeZone();
        this.test_getOffset();
        this.test_getRawOffset();
        this.test_setRawOffset();
        this.test_hasSameRules();
        this.test_inDayligthTime();
        this.test_getDSTSavings();
        this.test_setDSTSavings();
        this.test_setEndRule();
        this.test_setStartRule();
        this.test_setStartYear();
        this.test_useDaylightTime();
        this.test_clone();
        this.test_equals();
        this.test_hashCode();
    }

    public void test_SimpleTimeZone() {
        this.th.checkPoint("SimpleTimeZone(int,java.lang.String)");
        SimpleTimeZone stz = new SimpleTimeZone(-123456, "MyTimeZone");
        this.th.check(stz.getID(), "MyTimeZone", "checking ID");
        this.th.check(stz.getRawOffset(), -123456, "checking Offset");
        this.th.check(stz.useDaylightTime() ^ true, "no daylight savings by default");
        try {
            new SimpleTimeZone(-123456, null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.th.checkPoint("SimpleTimeZone(int,java.lang.String,int,int,int,int,int,int,int,int)");
        this.th.checkPoint("SimpleTimeZone(int,java.lang.String,int,int,int,int,int,int,int,int,int)");
    }

    public void test_getOffset() {
        this.th.checkPoint("getOffset(int,int,int,int,int,int)int");
        SimpleTimeZone ect = (SimpleTimeZone)TimeZone.getTimeZone("ECT");
        int ad = 1;
        int bc = 0;
        this.th.check(ect.getOffset(ad, 2001, 0, 1, 1, 0), 3600000, "check normal offset -- 1");
        this.th.check(ect.getOffset(ad, 2001, 2, 28, 1, 0), 3600000, "check normal offset -- 2");
        this.th.check(ect.getOffset(ad, 2001, 2, 28, 1, 0x6DDD00), 0x6DDD00, "check dst offset -- 3");
        this.th.check(ect.getOffset(ad, 2001, 2, 29, 2, 0x6DDD00), 0x6DDD00, "check dst offset -- 4");
        this.th.check(ect.getOffset(bc, 1, 2, 28, 1, 0x6DDD00), 3600000, "check nrm offset -- 5");
        this.th.check(ect.getOffset(ad, 2001, 4, 28, 1, 0x6DDD00), 0x6DDD00, "check dst offset -- 6");
        this.th.check(ect.getOffset(ad, 2001, 8, 28, 1, 0x6DDD00), 0x6DDD00, "check dst offset -- 7");
        this.th.check(ect.getOffset(ad, 2001, 9, 28, 1, 0x6DDD00), 3600000, "check nrm offset -- 8");
        this.th.check(ect.getOffset(ad, 2001, 2, 27, 7, 3600000), 3600000, "check nrm offset -- 9");
        this.th.check(ect.getOffset(ad, 2001, 9, 29, 2, 3600000), 3600000, "check nrm offset -- 10");
        ect = new SimpleTimeZone(3600000, "MyTZ", 3, -2, 7, 300, 9, 2, 2, 300, 0x6DDD00);
        this.th.check(ect.getOffset(ad, 2001, 2, 21, 7, 299), 3600000, "check nrm offset -- 11");
        this.th.check(ect.getOffset(ad, 2001, 9, 12, 2, 300), 3600000, "check dst offset -- 12");
        this.th.check(ect.getOffset(ad, 2001, 2, 14, 1, 0x6DDD00), 3600000, "check nrm offset -- 13");
        this.th.check(ect.getOffset(ad, 2001, 9, 21, 1, 7199999), 3600000, "check nrm offset -- 14");
        ect = new SimpleTimeZone(3600000, "MyTZ", 6, -2, 7, 300, 2, -2, 7, 300, 0x6DDD00);
        this.th.check(ect.getOffset(ad, 2001, 2, 21, 7, 400), 3600000, "check nrm offset -- 15");
        this.th.check(ect.getOffset(ad, 2001, 2, 1, 7, 299), 10800000, "check dst offset -- 16");
    }

    public void test_getRawOffset() {
        this.th.checkPoint("getRawOffset()int");
        SimpleTimeZone ect = new SimpleTimeZone(3600000, "MyTZ");
        this.th.check(ect.getRawOffset(), 3600000, "checking returnvalue");
    }

    public void test_setRawOffset() {
        this.th.checkPoint("setRawOffset(int)void");
        SimpleTimeZone ect = new SimpleTimeZone(3600000, "MyTZ");
        ect.setRawOffset(12345);
        this.th.check(ect.getRawOffset(), 12345, "checking set value -- 1");
        ect.setRawOffset(-12345);
        this.th.check(ect.getRawOffset(), -12345, "checking set value -- 2");
        ect.setRawOffset(0);
        this.th.check(ect.getRawOffset(), 0, "checking set value -- 3");
    }

    public void test_hasSameRules() {
        this.th.checkPoint("()");
    }

    public void test_inDayligthTime() {
        this.th.checkPoint("()");
    }

    public void test_getDSTSavings() {
        this.th.checkPoint("getDSTSavings()int");
        SimpleTimeZone ect = new SimpleTimeZone(3600000, "MyTZ", 3, -2, 7, 300, 9, 2, 2, 300, 0x6DDD00);
        this.th.check(ect.getDSTSavings(), 0x6DDD00, "checking returnvalue -- 1");
        ect = new SimpleTimeZone(3600000, "MyTZ", 3, -2, 7, 300, 9, 2, 2, 300);
        this.th.check(ect.getDSTSavings(), 3600000, "checking returnvalue -- 2");
    }

    public void test_setDSTSavings() {
        this.th.checkPoint("setDSTSavings(int)void");
        SimpleTimeZone ect = new SimpleTimeZone(3600000, "MyTZ", 3, -2, 7, 300, 9, 2, 2, 300, 0x6DDD00);
        ect.setDSTSavings(122);
        this.th.check(ect.getDSTSavings(), 122, "checking returnvalue -- 1");
        try {
            ect.setDSTSavings(-122);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 1");
        }
    }

    public void test_setEndRule() {
        this.th.checkPoint("()");
    }

    public void test_setStartRule() {
        this.th.checkPoint("()");
    }

    public void test_setStartYear() {
        this.th.checkPoint("setStartYear(int)void");
        SimpleTimeZone ect = (SimpleTimeZone)TimeZone.getTimeZone("ECT");
        int ad = 1;
        boolean bc = false;
        ect.setStartYear(1000);
        this.th.check(ect.getOffset(ad, 1, 0, 1, 1, 0), 3600000, "check normal offset -- 1");
        this.th.check(ect.getOffset(ad, 1, 2, 28, 1, 0), 3600000, "check normal offset -- 2");
        this.th.check(ect.getOffset(ad, 1, 2, 28, 1, 0x6DDD00), 3600000, "check nrm offset -- 3");
        this.th.check(ect.getOffset(ad, 1, 2, 29, 2, 0x6DDD00), 3600000, "check nrm offset -- 4");
    }

    public void test_useDaylightTime() {
        this.th.checkPoint("()");
    }

    public void test_clone() {
        this.th.checkPoint("()");
    }

    public void test_equals() {
        this.th.checkPoint("()");
    }

    public void test_hashCode() {
        this.th.checkPoint("()");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_toString() {
        this.th.checkPoint("()");
        try {
            Vector v = null;
            try {
                try {
                    v.add("a");
                    this.th.debug("should throw NullPointerException");
                }
                catch (Exception e) {
                    this.th.debug("got exception " + e + " after try");
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    this.th.debug("clearing vector");
                    v.clear();
                    throw throwable;
                }
                catch (Exception e) {
                    this.th.check(true, "got exception " + e + " in finally blok");
                    e.printStackTrace();
                }
                throw throwable;
            }
            {
                Object var3_6 = null;
                try {}
                catch (Exception e) {
                    this.th.check(true, "got exception " + e + " in finally blok");
                    e.printStackTrace();
                    return;
                }
                this.th.debug("clearing vector");
                v.clear();
                return;
            }
        }
        catch (Exception e) {
            this.th.fail("got exception " + e + " in bottom catch");
        }
    }
}

