/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.AbstractList;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.util.AbstractList.SMExAbstractList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SMAbstractListTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.AbstractList");
        this.test_get();
        this.test_indexOf();
        this.test_lastIndexOf();
        this.test_add();
        this.test_addAll();
        this.test_clear();
        this.test_remove();
        this.test_removeRange();
        this.test_set();
        this.test_iterator();
        this.test_listIterator();
        this.test_subList();
        this.test_hashCode();
        this.test_equals();
    }

    public void test_get() {
        this.th.checkPoint("()");
    }

    public void test_indexOf() {
        this.th.checkPoint("indexOf(java.lang.Object)int");
        SMExAbstractList eal = new SMExAbstractList();
        eal.v.add("ab");
        eal.v.add("bc");
        eal.v.add(null);
        eal.v.add("ab");
        eal.v.add("cd");
        eal.v.add(this);
        boolean bl = false;
        if (eal.indexOf(this) == 5) {
            bl = true;
        }
        this.th.check(bl, "checking return value -- 1");
        boolean bl2 = false;
        if (eal.indexOf(null) == 2) {
            bl2 = true;
        }
        this.th.check(bl2, "checking return value -- 2");
        boolean bl3 = false;
        if (eal.indexOf("ab") == 0) {
            bl3 = true;
        }
        this.th.check(bl3, "checking return value -- 3");
        boolean bl4 = false;
        if (eal.indexOf("ab") == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "checking return value -- 4");
        boolean bl5 = false;
        if (eal.indexOf("b") == -1) {
            bl5 = true;
        }
        this.th.check(bl5, "checking return value -- 5");
        eal.v.remove(null);
        boolean bl6 = false;
        if (eal.indexOf(null) == -1) {
            bl6 = true;
        }
        this.th.check(bl6, "checking return value -- 6");
        eal.v.remove(this);
        boolean bl7 = false;
        if (eal.indexOf(this) == -1) {
            bl7 = true;
        }
        this.th.check(bl7, "checking return value -- 7");
    }

    public void test_lastIndexOf() {
        this.th.checkPoint("lastIndexOf(java.lang.Object)int");
        SMExAbstractList eal = new SMExAbstractList();
        eal.v.add("ab");
        eal.v.add("bc");
        eal.v.add(null);
        eal.v.add("ab");
        eal.v.add(null);
        eal.v.add(this);
        boolean bl = false;
        if (eal.lastIndexOf(this) == 5) {
            bl = true;
        }
        this.th.check(bl, "checking return value -- 1");
        boolean bl2 = false;
        if (eal.lastIndexOf(null) == 4) {
            bl2 = true;
        }
        this.th.check(bl2, "checking return value -- 2");
        boolean bl3 = false;
        if (eal.lastIndexOf("ab") == 3) {
            bl3 = true;
        }
        this.th.check(bl3, "checking return value -- 3");
        boolean bl4 = false;
        if (eal.lastIndexOf("ab") == 3) {
            bl4 = true;
        }
        this.th.check(bl4, "checking return value -- 4");
        boolean bl5 = false;
        if (eal.lastIndexOf("b") == -1) {
            bl5 = true;
        }
        this.th.check(bl5, "checking return value -- 5");
        eal.v.remove(4);
        boolean bl6 = false;
        if (eal.lastIndexOf(null) == 2) {
            bl6 = true;
        }
        this.th.check(bl6, "checking return value -- 6");
        eal.v.remove(null);
        boolean bl7 = false;
        if (eal.lastIndexOf(null) == -1) {
            bl7 = true;
        }
        this.th.check(bl7, "checking return value -- 7");
    }

    public void test_add() {
        this.th.checkPoint("add(java.lang.Object)boolean");
        SMExAbstractList eal = new SMExAbstractList();
        int mc = eal.getMC();
        this.th.check(eal.add(this), "checking return value -- 1");
        boolean bl = false;
        if (eal.v.get(0) == this) {
            bl = true;
        }
        this.th.check(bl, "checking add -- 1");
        this.th.check(eal.add("a"), "checking return value -- 2");
        this.th.check("a".equals(eal.v.get(1)), "checking add -- 2");
        this.th.check(eal.add("b"), "checking return value -- 3");
        this.th.check("b".equals(eal.v.get(2)), "checking add -- 3");
        this.th.check(eal.add(null), "checking return value -- 4");
        boolean bl2 = false;
        if (eal.v.get(3) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking add -- 4");
        this.th.check(eal.add(null), "checking return value -- 5");
        boolean bl3 = false;
        if (eal.v.get(4) == null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking add -- 5");
        eal.set_edit(false);
        try {
            eal.add("a");
            this.th.fail("should throw an UnsupportedOperationExeption");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        this.th.checkPoint("add(int,java.lang.Object)void");
        try {
            eal.add(3, "a");
            this.th.fail("should throw an UnsupportedOperationExeption");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_addAll() {
        this.th.checkPoint("addAll(java.util.Collection)boolean");
        this.th.checkPoint("addAll(int,java.util.Collection)boolean");
        SMExAbstractList eal = new SMExAbstractList();
        try {
            eal.addAll(0, null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Vector<Object> v = new Vector<Object>();
        this.th.check(eal.addAll(0, v) ^ true, "checking returnvalue -- 1");
        boolean bl = false;
        if (eal.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "nothing added yet");
        v.add(this);
        v.add(null);
        v.add("a");
        v.add("b");
        v.add("a");
        v.add(null);
        try {
            eal.addAll(-1, v);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        try {
            eal.addAll(1, v);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(eal.addAll(0, v), "checking returnvalue -- 1");
        boolean bl2 = false;
        if (eal.v.get(0) == this && eal.v.get(1) == null && eal.v.get(5) == null) {
            bl2 = true;
        }
        this.th.check(bl2);
        this.th.check(eal.addAll(3, v), "checking returnvalue -- 2");
        boolean bl3 = false;
        if (eal.v.get(0) == this && "a".equals(eal.v.get(2)) && eal.v.get(3) == this) {
            bl3 = true;
        }
        this.th.check(bl3);
        boolean bl4 = false;
        if (eal.v.get(8) == null && "b".equals(eal.v.get(9)) && eal.v.get(11) == null) {
            bl4 = true;
        }
        this.th.check(bl4);
        v = new Vector();
        this.th.check(eal.addAll(3, v) ^ true, "checking returnvalue -- 3");
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        SMExAbstractList eal = new SMExAbstractList();
        eal.set_updateMC(true);
        eal.clear();
        this.th.check(eal.get_dRR(), "check if removeRange was called");
        boolean bl = false;
        if (eal.get_from() == 0 && eal.get_to() == 0) {
            bl = true;
        }
        this.th.check(bl);
        eal = new SMExAbstractList();
        eal.v.add("a");
        eal.v.add("b");
        eal.v.add("c");
        eal.v.add("d");
        eal.clear();
        this.th.check(eal.get_dRR(), "check if removeRange was called");
        boolean bl2 = false;
        if (eal.get_from() == 0 && eal.get_to() == 4) {
            bl2 = true;
        }
        this.th.check(bl2);
        boolean bl3 = false;
        if (eal.v.size() == 0) {
            bl3 = true;
        }
        this.th.check(bl3, "checking if everything is gone");
    }

    public void test_remove() {
        this.th.checkPoint("remove(int)java.lang.Object");
        SMExAbstractList eal = new SMExAbstractList();
        eal.set_edit(false);
        eal.v.add("a");
        try {
            eal.remove(0);
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_removeRange() {
        this.th.checkPoint("removeRange(int,int)void");
        SMExAbstractList eal = new SMExAbstractList();
        int i = 0;
        while (i < 20) {
            eal.v.add("a" + i);
            ++i;
        }
        try {
            eal.removeRange(10, 25);
            this.th.fail("should throw an exception");
        }
        catch (NoSuchElementException e) {
            this.th.check(true);
        }
        Vector v = (Vector)eal.v.clone();
        eal.removeRange(10, 10);
        this.th.check(eal.v.equals(v), "nothing removed -- 1");
        eal.removeRange(9, 10);
        v.remove(9);
        this.th.check(eal.v.equals(v), "one element removed");
        eal.removeRange(5, 7);
        v.remove(5);
        v.remove(5);
        this.th.debug("got v = " + v + ", and eal.v = " + eal.v);
        this.th.check(eal.v.equals(v), "two elements removed");
        eal.removeRange(2, 1);
        this.th.check(eal.v.equals(v), "nothing removed -- 2");
        try {
            eal.removeRange(-1, 5);
            this.th.fail("should throw an exception");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
            this.th.debug(e);
        }
    }

    public void test_set() {
        this.th.checkPoint("set(int,java.lang.Object)java.lang.Object");
        SMExAbstractList eal = new SMExAbstractList();
        eal.set_edit(false);
        eal.v.add("a");
        try {
            eal.set(0, "b");
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_iterator() {
        this.th.checkPoint("iterator()java.util.Iterator");
        SMExAbstractList eal = new SMExAbstractList();
        eal.set_updateMC(true);
        eal.v.add("a");
        eal.v.add("b");
        eal.v.add("c");
        Iterator it = eal.iterator();
        this.th.check(it.hasNext(), "true -- 1");
        this.th.check("a".equals(it.next()), "order is important -- 1");
        this.th.check(it.hasNext(), "true -- 2");
        this.th.check("b".equals(it.next()), "order is important -- 2");
        this.th.check(it.hasNext(), "true -- 3");
        this.th.check("c".equals(it.next()), "order is important -- 3");
        this.th.check(it.hasNext() ^ true, "false -- 4");
        this.th.check(it.hasNext() ^ true, "false -- 5");
        try {
            it.next();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        eal.add("changed");
        try {
            it.remove();
            this.th.fail("should throw a ConcurrentModificationException -- 1");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "remove");
        }
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 2");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "next");
        }
        try {
            this.th.check(it.hasNext());
        }
        catch (ConcurrentModificationException cme) {
            this.th.fail("should not throw a ConcurrentModificationException -- 3");
        }
        it = eal.iterator();
        try {
            it.remove();
            this.th.fail("should throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            this.th.debug(eal.v.toString());
            it.next();
            it.hasNext();
            it.remove();
            boolean bl = false;
            if (!eal.v.contains("a") && eal.v.size() == 3) {
                bl = true;
            }
            this.th.check(bl, "first element removed");
            it.next();
            it.remove();
            boolean bl2 = false;
            if (!eal.v.contains("b") && eal.v.size() == 2) {
                bl2 = true;
            }
            this.th.check(bl2, "second element removed");
            it.next();
            it.remove();
            boolean bl3 = false;
            if (!eal.v.contains("c") && eal.v.size() == 1) {
                bl3 = true;
            }
            this.th.check(bl3, "third element removed");
            it.next();
            it.remove();
            this.th.check(eal.v.isEmpty(), "all are elements removed");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception !, got " + e);
        }
    }

    public void test_listIterator() {
        this.th.checkPoint("listIterator()java.util.ListIterator");
        SMExAbstractList ll = new SMExAbstractList();
        ll.set_updateMC(true);
        ListIterator<String> li = ll.listIterator();
        try {
            li.next();
            this.th.fail("should throw a NoSuchElementException -- 1");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exeption -- 1");
        }
        try {
            li.previous();
            this.th.fail("should throw a NoSuchElementException -- 2");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exeption -- 2");
        }
        this.th.check(li.hasNext() ^ true, "no elements ... -- 1");
        this.th.check(li.hasPrevious() ^ true, "no elements ... -- 1");
        this.th.check(li.nextIndex(), 0, "nextIndex == 0 -- 1");
        this.th.check(li.previousIndex(), -1, "previousIndex == -1 -- 1");
        li.add("a");
        this.th.check(li.hasNext() ^ true, "no elements ... -- 2");
        this.th.check(li.hasPrevious(), "one element ... -- 2");
        this.th.check(li.nextIndex(), 1, "nextIndex == 1 -- 2");
        this.th.check(li.previousIndex(), 0, "previousIndex == 0 -- 2");
        try {
            li.next();
            this.th.fail("should throw a NoSuchElementException -- 3");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exeption -- 3");
        }
        this.th.check("a".equals(li.previous()), "checking previous element -- 1");
        li.add(null);
        this.th.check(li.previousIndex(), 0, "previousIndex == 0 -- 3");
        boolean bl = false;
        if (li.previous() == null) {
            bl = true;
        }
        this.th.check(bl, "checking previous element -- 2");
        boolean bl2 = false;
        if (li.next() == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking next element -- 1");
        li.add("b");
        this.th.check("a".equals(li.next()), "checking next element -- 2");
        li.add("c");
        try {
            li.set("not");
            this.th.fail("should throw a IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 4");
        }
        this.th.check(ll.contains("not") ^ true, "set should not have been executed");
        try {
            li.remove();
            this.th.fail("should throw a IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 5");
        }
        this.th.check("c".equals(li.previous()), "checking previous element -- 3");
        li.set("new");
        this.th.check("new".equals(li.next()), "validating set");
        li.set("not");
        li.set("notOK");
        li.remove();
        try {
            li.set("not");
            this.th.fail("should throw a IllegalStateException -- 3");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 6");
        }
        this.th.check(ll.contains("not") ^ true, "set should not have been executed");
        try {
            li.remove();
            this.th.fail("should throw a IllegalStateException -- 4");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 7");
        }
        try {
            li.next();
            this.th.fail("should throw a NoSuchElementException -- 4");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exeption -- 8");
        }
        this.th.check("a", li.previous(), "checking on previous element");
        li.remove();
        try {
            li.set("not");
            this.th.fail("should throw a IllegalStateException -- 5");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 9");
        }
        this.th.check(ll.contains("not") ^ true, "set should not have been executed");
        try {
            li.remove();
            this.th.fail("should throw a IllegalStateException -- 6");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 10");
        }
    }

    public void test_subList() {
        this.th.checkPoint("subList(int,int)List");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        SMExAbstractList eal = new SMExAbstractList();
        boolean bl = false;
        if (eal.hashCode() == 1) {
            bl = true;
        }
        this.th.check(bl, "hashCode of empty list is 1");
        int hash2 = 1;
        hash2 = hash2 * 31 + "a".hashCode();
        eal.v.add("a");
        boolean bl2 = false;
        if (eal.hashCode() == hash2) {
            bl2 = true;
        }
        this.th.check(bl2, "checking hashCode algortihm -- 1");
        hash2 = hash2 * 31 + "adg".hashCode();
        eal.v.add("adg");
        boolean bl3 = false;
        if (eal.hashCode() == hash2) {
            bl3 = true;
        }
        this.th.check(bl3, "checking hashCode algortihm -- 2");
        eal.v.add(null);
        boolean bl4 = false;
        if (eal.hashCode() == (hash2 *= 31)) {
            bl4 = true;
        }
        this.th.check(bl4, "checking hashCode algortihm -- 3");
        hash2 = hash2 * 31 + this.hashCode();
        eal.v.add(this);
        boolean bl5 = false;
        if (eal.hashCode() == hash2) {
            bl5 = true;
        }
        this.th.check(bl5, "checking hashCode algortihm -- 4");
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        SMExAbstractList eal = new SMExAbstractList();
        Vector<Object> v = new Vector<Object>();
        this.th.check(eal.equals(null) ^ true, "null is allowed");
        this.th.check(eal.equals(this) ^ true, "not equal to an non-List Object");
        this.th.check(eal.equals(v), "equal == true -- 1");
        eal.v.add(null);
        v.add(null);
        this.th.check(eal.equals(v), "equal == true -- 2");
        eal.v.add(this);
        v.add(this);
        this.th.check(eal.equals(v), "equal == true -- 3");
        eal.v.add("a");
        v.add("b");
        this.th.check(eal.equals(v) ^ true, "equal != true -- 4");
        eal.v.add("b");
        v.add("a");
        this.th.check(eal.equals(v) ^ true, "equal != true -- 5");
        eal.v.remove("a");
        this.th.check(eal.equals(v) ^ true, "equal != true -- 5");
    }
}

