/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.AbstractCollection;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.util.AbstractCollection.SMAddCollection;
import gnu.testlet.wonka.util.AbstractCollection.SMExAbstractCollection;
import java.util.Vector;

public class SMAbstractCollectionTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.AbstractCollection");
        this.test_add();
        this.test_addAll();
        this.test_clear();
        this.test_remove();
        this.test_removeAll();
        this.test_retainAll();
        this.test_contains();
        this.test_containsAll();
        this.test_isEmpty();
        this.test_size();
        this.test_iterator();
        this.test_toArray();
        this.test_toString();
    }

    public void test_add() {
        this.th.checkPoint("add(java.lang.Object)boolean");
        SMExAbstractCollection eac = new SMExAbstractCollection();
        try {
            eac.add(this);
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_addAll() {
        this.th.checkPoint("addAll(java.util.Collection)boolean");
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("b");
        v.add("c");
        v.add("d");
        SMAddCollection ac = new SMAddCollection();
        this.th.check(ac.addAll(v), "should return true, v is modified");
        this.th.check(ac.v.equals(v), "check everything is added");
        ac.setRA(false);
        this.th.check(ac.addAll(v) ^ true, "should return false, v is  not modified");
        this.th.check(ac.v.equals(v), "check everything is added");
        try {
            ac.addAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        SMAddCollection ac = new SMAddCollection();
        ac.v.add("a");
        ac.v.add("b");
        ac.v.add("c");
        ac.v.add("d");
        ac.clear();
        boolean bl = false;
        if (ac.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "all elements are removed -- 1");
        ac.clear();
        boolean bl2 = false;
        if (ac.size() == 0) {
            bl2 = true;
        }
        this.th.check(bl2, "all elements are removed -- 2");
    }

    public void test_remove() {
        this.th.checkPoint("remove(java.lang.Object)boolean");
        SMAddCollection ac = new SMAddCollection();
        ac.v.add("a");
        ac.v.add(null);
        ac.v.add("c");
        ac.v.add("a");
        this.th.check(ac.remove("a"), "returns true if removed -- 1");
        boolean bl = false;
        if (ac.size() == 3) {
            bl = true;
        }
        this.th.check(bl, "one element was removed -- 1");
        this.th.check("a".equals(ac.v.get(0)) ^ true, "check if correct element was removed");
        this.th.check(ac.remove("a"), "returns true if removed -- 2");
        boolean bl2 = false;
        if (ac.size() == 2) {
            bl2 = true;
        }
        this.th.check(bl2, "one element was removed -- 2");
        this.th.check(ac.remove("a") ^ true, "returns false if not removed -- 3");
        boolean bl3 = false;
        if (ac.size() == 2) {
            bl3 = true;
        }
        this.th.check(bl3, "no elements were removed -- 3");
        this.th.check(ac.remove(null), "returns true if removed -- 4");
        boolean bl4 = false;
        if (ac.size() == 1) {
            bl4 = true;
        }
        this.th.check(bl4, "one element was removed -- 4");
        this.th.check(ac.remove(null) ^ true, "returns false if not removed -- 5");
        boolean bl5 = false;
        if (ac.size() == 1) {
            bl5 = true;
        }
        this.th.check(bl5, "no elements were removed -- 5");
        this.th.check("c".equals(ac.v.get(0)), "\"c\" is left");
    }

    public void test_removeAll() {
        this.th.checkPoint("removeAll(java.util.Collection)boolean");
        SMAddCollection ac = new SMAddCollection();
        ac.v.add("a");
        ac.v.add(null);
        ac.v.add("c");
        ac.v.add("a");
        try {
            ac.removeAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add(null);
        v.add("de");
        v.add("fdf");
        this.th.check(ac.removeAll(v), "should return true");
        boolean bl = false;
        if (ac.size() == 1) {
            bl = true;
        }
        this.th.check(bl, "duplicate elements are removed");
        this.th.check("c".equals(ac.v.get(0)), "check if correct elements were removed");
        this.th.check(ac.removeAll(v) ^ true, "should return false");
        boolean bl2 = false;
        if (ac.size() == 1) {
            bl2 = true;
        }
        this.th.check(bl2, "no elements were removed");
    }

    public void test_retainAll() {
        this.th.checkPoint("retainAll(java.util.Collection)boolean");
        SMAddCollection ac = new SMAddCollection();
        ac.v.add("a");
        ac.v.add(null);
        ac.v.add("c");
        ac.v.add("a");
        try {
            ac.retainAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add(null);
        v.add("de");
        v.add("fdf");
        this.th.check(ac.retainAll(v), "should return true");
        boolean bl = false;
        if (ac.size() == 3) {
            bl = true;
        }
        this.th.check(bl, "duplicate elements are retained");
        this.th.check(ac.retainAll(v) ^ true, "should return false");
        boolean bl2 = false;
        if (ac.size() == 3) {
            bl2 = true;
        }
        this.th.check(bl2, "all elements were retained");
        boolean bl3 = false;
        if (ac.v.contains(null) && ac.v.contains("a")) {
            bl3 = true;
        }
        this.th.check(bl3);
    }

    public void test_contains() {
        this.th.checkPoint("contains(java.lang.Object)boolean");
        SMAddCollection ac = new SMAddCollection();
        ac.v.add("a");
        ac.v.add(null);
        ac.v.add("c");
        ac.v.add("a");
        this.th.check(ac.contains("a"), "true -- 1");
        this.th.check(ac.contains(null), "true -- 2");
        this.th.check(ac.contains("c"), "true -- 3");
        this.th.check(ac.contains("ab") ^ true, "false -- 4");
        this.th.check(ac.contains("b") ^ true, "false -- 5");
        ac.remove(null);
        this.th.check(ac.contains(null) ^ true, "false -- 4");
    }

    public void test_containsAll() {
        this.th.checkPoint("containsAll(java.util.Collection)boolean");
        SMAddCollection ac = new SMAddCollection();
        ac.v.add("a");
        ac.v.add(null);
        ac.v.add("c");
        ac.v.add("a");
        try {
            ac.containsAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Vector<String> v = new Vector<String>();
        this.th.check(ac.containsAll(v), "should return true -- 1");
        v.add("a");
        v.add(null);
        v.add("a");
        v.add(null);
        v.add("a");
        this.th.check(ac.containsAll(v), "should return true -- 2");
        v.add("c");
        this.th.check(ac.containsAll(v), "should return true -- 3");
        v.add("c+");
        this.th.check(ac.containsAll(v) ^ true, "should return false -- 4");
        v.clear();
        ac.clear();
        this.th.check(ac.containsAll(v), "should return true -- 5");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        SMAddCollection ac = new SMAddCollection();
        this.th.check(ac.isEmpty(), "should return true -- 1");
        this.th.check(ac.isEmpty(), "should return true -- 2");
        ac.v.add(null);
        this.th.check(ac.isEmpty() ^ true, "should return false -- 3");
        ac.clear();
        this.th.check(ac.isEmpty(), "should return true -- 4");
    }

    public void test_size() {
        this.th.checkPoint("()");
    }

    public void test_iterator() {
        this.th.checkPoint("()");
    }

    public void test_toArray() {
        this.th.checkPoint("toArray()java.lang.Object[]");
        SMAddCollection ac = new SMAddCollection();
        Object[] oa = ac.toArray();
        boolean bl = false;
        if (oa != null) {
            bl = true;
        }
        this.th.check(bl, "returning null is not allowed");
        if (oa != null) {
            boolean bl2 = false;
            if (oa.length == 0) {
                bl2 = true;
            }
            this.th.check(bl2, "empty array");
        }
        ac.v.add("a");
        ac.v.add(null);
        ac.v.add("c");
        ac.v.add("a");
        oa = ac.toArray();
        boolean bl3 = false;
        if (oa[0].equals("a") && oa[1] == null && oa[2].equals("c") && oa[3].equals("a")) {
            bl3 = true;
        }
        this.th.check(bl3, "checking elements");
        this.th.checkPoint("toArray(java.lang.Object[])java.lang.Object[]");
        try {
            ac.toArray((T[])null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        String[] sa = new String[5];
        int i = 0;
        while (i < 5) {
            sa[i] = "ok";
            ++i;
        }
        oa = ac.toArray(sa);
        boolean bl4 = false;
        if (oa[0].equals("a") && oa[1] == null && oa[2].equals("c") && oa[3].equals("a")) {
            bl4 = true;
        }
        this.th.check(bl4, "checking elements");
        boolean bl5 = false;
        if (oa == sa) {
            bl5 = true;
        }
        this.th.check(bl5, "array large enough --> fill + return it");
        boolean bl6 = false;
        if (sa[4] == null) {
            bl6 = true;
        }
        this.th.check(bl6, "element at 'size' is set to null");
        sa = new String[3];
        i = 0;
        while (i < 3) {
            sa[i] = "ok";
            ++i;
        }
        oa = ac.toArray(sa);
        boolean bl7 = false;
        if (oa[0].equals("a") && oa[1] == null && oa[2].equals("c") && oa[3].equals("a")) {
            bl7 = true;
        }
        this.th.check(bl7, "checking elements");
        this.th.check(oa instanceof String[], "checking  class type of returnvalue");
        sa = new String[4];
        Class<?> asc = sa.getClass();
        int i2 = 0;
        while (i2 < 4) {
            sa[i2] = "ok";
            ++i2;
        }
        oa = ac.toArray(sa);
        boolean bl8 = false;
        if (oa[0].equals("a") && oa[1] == null && oa[2].equals("c") && oa[3].equals("a")) {
            bl8 = true;
        }
        this.th.check(bl8, "checking elements");
        this.th.check(oa instanceof String[], "checking  class type of returnvalue");
        boolean bl9 = false;
        if (oa == sa) {
            bl9 = true;
        }
        this.th.check(bl9, "array large enough --> fill + return it");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        SMAddCollection ac = new SMAddCollection();
        ac.v.add("smartmove");
        ac.v.add(null);
        ac.v.add("rules");
        ac.v.add("cars");
        String s = ac.toString();
        boolean bl = false;
        if (s.indexOf("smartmove") != -1) {
            bl = true;
        }
        this.th.check(bl, "checking representations");
        boolean bl2 = false;
        if (s.indexOf("rules") != -1) {
            bl2 = true;
        }
        this.th.check(bl2, "checking representations");
        boolean bl3 = false;
        if (s.indexOf("cars") != -1) {
            bl3 = true;
        }
        this.th.check(bl3, "checking representations");
        boolean bl4 = false;
        if (s.indexOf("null") != -1) {
            bl4 = true;
        }
        this.th.check(bl4, "checking representations");
        this.th.debug(s);
    }
}

