/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.text.SimpleDateFormat;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class regress
implements Testlet {
    public static String[] dates = new String[]{"Fri, 18 May 2001 12:18:06 CDT", "Fri, 18 May 2001 13:18:06 EDT", "Fri, 18 May 2001 12:18:06 EST", "Fri, 18 May 2001 17:18:06 GMT", "Fri, 18 May 2001 10:18:06 PDT"};

    public void test(TestHarness harness) {
        harness.setclass("java.text.SimpleDateFormat");
        harness.checkPoint("parsing regression");
        SimpleDateFormat cdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzzz");
        boolean ok = true;
        Date d = null;
        try {
            d = cdf.parse("Fri, 18 May 2001 20:18:06 GMT");
        }
        catch (ParseException _) {
            ok = false;
        }
        harness.check(ok);
        Calendar k = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        k.setTime(d);
        harness.check(k.get(10), 8, "check hour");
        harness.check(k.get(11), 20, "check hour-of-day");
        cdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        cdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        int i = 0;
        while (i < dates.length) {
            String tz = dates[i].substring(dates[i].lastIndexOf(32) + 1, dates[i].length());
            try {
                d = cdf.parse(dates[i]);
                harness.check(cdf.format(d), "Fri, 18 May 2001 17:18:06 GMT", tz);
            }
            catch (ParseException _) {
                harness.debug(_);
                harness.check(false, tz);
            }
            ++i;
        }
        cdf = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        try {
            d = cdf.parse("03-22-2001 15:54:27");
            harness.check(cdf.format(d), "03-22-2001 15:54:27", "local timezone");
        }
        catch (ParseException _) {
            harness.debug(_);
            harness.check(false, "local timezone");
        }
    }
}

