/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.text.SimpleDateFormat;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Test
implements Testlet {
    public void test(TestHarness harness) {
        harness.setclass("java.text.SimpleDateFormat");
        harness.checkPoint("basic tests");
        String pattern_chars = "GyMdhHmsSEDFwWakKz";
        String pattern = "EEEE, MMMM d, yyyy h:mm:ss 'o''clock' a";
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.US);
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, dfs);
        harness.check(sdf.getDateFormatSymbols(), dfs, "getDateFormatSymbols() init");
        String[] ampms = new String[]{"am ", "pm "};
        dfs.setAmPmStrings(ampms);
        sdf.setDateFormatSymbols(dfs);
        harness.check(sdf.getDateFormatSymbols(), dfs, "set/getDateFormatSymbols()");
        harness.check(sdf.toPattern(), pattern, "toPattern init");
        String new_pattern = "EMdyH";
        sdf.applyPattern(new_pattern);
        harness.check(sdf.toPattern(), new_pattern, "apply/toPattern()");
        sdf.applyPattern(pattern);
        harness.check(sdf.equals(new SimpleDateFormat(pattern, dfs)), "equals()");
        harness.check(sdf.clone().equals(sdf), "clone()");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = new Date(0L);
        String formatted_date = sdf.format(d);
        harness.debug(formatted_date);
        harness.check(formatted_date, "Thursday, January 1, 1970 12:00:00 o'clock am ", "format()");
        sdf.setLenient(false);
        try {
            harness.check(sdf.parse(formatted_date), d, "parse() strict");
        }
        catch (Throwable e) {
            harness.debug(e);
            harness.check(false, "parse() strict");
        }
        sdf.setTimeZone(TimeZone.getDefault());
        harness.debug(sdf.format(new Date(System.currentTimeMillis())));
        dfs = new DateFormatSymbols(Locale.US);
        sdf = new SimpleDateFormat(pattern, dfs);
        sdf.setLenient(true);
    }
}

