/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.text.MessageFormat;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;

public class format
implements Testlet {
    private final String checkFormat(MessageFormat mf, Object[] args, StringBuffer buf) {
        try {
            buf.setLength(0);
            mf.format(args, buf, (FieldPosition)null);
            return buf.toString();
        }
        catch (IllegalArgumentException x) {
            return "caught IllegalArgumentException";
        }
    }

    public void test(TestHarness harness) {
        harness.setclass("java.text.MessageFormat");
        harness.checkPoint("basic format tests");
        Locale loc = Locale.US;
        Locale.setDefault(loc);
        MessageFormat mf = new MessageFormat("no variables");
        mf.setLocale(loc);
        Object[] args = new Object[]{};
        StringBuffer buf = new StringBuffer();
        harness.checkPoint("no variable format");
        boolean bl = false;
        if (mf.format(args, buf, (FieldPosition)null) == buf) {
            bl = true;
        }
        harness.check(bl);
        harness.check(buf.toString(), (Object)"no variables");
        buf.setLength(0);
        boolean bl2 = false;
        if (mf.format(null, buf, null) == buf) {
            bl2 = true;
        }
        harness.check(bl2);
        harness.check(buf.toString(), (Object)"no variables");
        harness.check(MessageFormat.format("no variables", args), (Object)"no variables");
        harness.checkPoint("quoted brace");
        mf.applyPattern("no '{' variables");
        harness.check(this.checkFormat(mf, args, buf), (Object)"no { variables");
        harness.check(mf.toPattern(), (Object)"no '{' variables");
        harness.checkPoint("one variable");
        mf.applyPattern("the disk contains {0} files");
        args = new Object[]{new Long(23L)};
        harness.check(this.checkFormat(mf, args, buf), (Object)"the disk contains 23 files");
        args = new Object[10];
        args[0] = new Long(27L);
        harness.check(this.checkFormat(mf, args, buf), (Object)"the disk contains 27 files");
        mf.applyPattern("the disk contains {0,number} files");
        harness.check(this.checkFormat(mf, args, buf), (Object)"the disk contains 27 files");
        args[0] = "zap";
        harness.check(this.checkFormat(mf, args, buf), (Object)"caught IllegalArgumentException");
        args[0] = new Double(0.99);
        mf.applyPattern("the disk is {0,number,percent} full");
        harness.check(this.checkFormat(mf, args, buf), (Object)"the disk is 99% full");
        harness.checkPoint("choice format");
        args[0] = new Long(5);
        mf.applyPattern("There {0,choice,0#are no files|1#is one file|1<are {0, number, integer} files}.");
        harness.check(this.checkFormat(mf, args, buf), (Object)"There are 5 files.");
        args[0] = new Double(10.23);
        mf.applyPattern("Got {0,number,'#'.##}");
        harness.check(this.checkFormat(mf, args, buf), (Object)"Got #10.23");
        harness.checkPoint("array argument");
        mf.applyPattern("test Message = {0}");
        args = new Object[]{"a jolly string"};
        harness.check(mf.format(args), (Object)"test Message = a jolly string");
    }
}

