/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.text.DecimalFormat;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.text.DecimalFormat;
import java.util.Locale;

public class format
implements Testlet {
    public void apply(TestHarness harness, DecimalFormat df, String pattern) {
        harness.checkPoint("pattern " + pattern);
        boolean ok = true;
        try {
            df.applyPattern(pattern);
        }
        catch (IllegalArgumentException x) {
            ok = false;
        }
        harness.check(ok);
    }

    public void test(TestHarness harness) {
        harness.setclass("java.text.DecimalFormat");
        harness.checkPoint("format(double)java.lang.Number");
        Locale loc = Locale.US;
        Locale.setDefault(loc);
        DecimalFormat df = new DecimalFormat("0.##;-0.##");
        harness.check(df.format(-1234.56), (Object)"-1234.56");
        harness.check(df.format(1234.56), (Object)"1234.56");
        this.apply(harness, df, "0.#");
        harness.check(df.format(-1234.56), (Object)"-1234.6");
        harness.check(df.format(1234.56), (Object)"1234.6");
        this.apply(harness, df, "#,##0.##;-#");
        harness.check(df.format(-1234.56), (Object)"-1,234.56");
        harness.check(df.format(1234.56), (Object)"1,234.56");
        this.apply(harness, df, "00,000.000;-00,000.000");
        harness.check(df.format(-1234.56), (Object)"-01,234.560");
        harness.check(df.format(1234.56), (Object)"01,234.560");
        this.apply(harness, df, "##,###,####.");
        df.setDecimalSeparatorAlwaysShown(true);
        harness.check(df.format(-1234.56), (Object)"-1235.");
        harness.check(df.format(1234.56), (Object)"1235.");
        this.apply(harness, df, "0");
        harness.check(df.format(-1234.56), (Object)"-1235");
        harness.check(df.format(1234.56), (Object)"1235");
        harness.check(df.format(Long.MIN_VALUE), (Object)"-9223372036854775808");
        this.apply(harness, df, "###0.#;(###0.#)");
        harness.check(df.format(-1234.56), (Object)"(1234.6)");
        harness.check(df.format(1234.56), (Object)"1234.6");
        this.apply(harness, df, "###0.#;###0.#-");
        harness.check(df.format(-1234.56), (Object)"1234.6-");
        harness.check(df.format(1234.56), (Object)"1234.6");
        this.apply(harness, df, "#,##0%;-#,##0%");
        harness.check(df.format(-1234.56), (Object)"-123,456%");
        harness.check(df.format(1234.56), (Object)"123,456%");
        this.apply(harness, df, "#.#");
        harness.check(df.format(0.2), (Object)".2");
        this.apply(harness, df, "'#'#.#");
        harness.check(df.format(30L), (Object)"#30");
    }
}

