/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.text.ChoiceFormat;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ChoiceFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;

public class AcuniaChoiceFormatTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.text.ChoiceFormat");
        this.test_ChoiceFormat();
        this.test_format();
        this.test_parse();
        this.test_applyPattern();
        this.test_getFormats();
        this.test_getLimits();
        this.test_setChoices();
        this.test_toPattern();
        this.test_nextDouble();
        this.test_previousDouble();
        this.test_clone();
        this.test_equals();
        this.test_hashCode();
    }

    public void test_ChoiceFormat() {
        this.th.checkPoint("test_ChoiceFormat(java.lang.String)");
        try {
            new ChoiceFormat(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        try {
            new ChoiceFormat("bad < worse");
            this.th.fail("should throw a IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        catch (RuntimeException rte) {
            this.th.fail("should throw a IllegalArgumentException, but threw " + rte);
        }
        this.th.checkPoint("test_ChoiceFormat(double[],java.lang.String[])");
        try {
            new ChoiceFormat(null, new String[0]);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        try {
            new ChoiceFormat(new double[10], null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        try {
            String[] strings = new String[]{"bad news"};
            new ChoiceFormat(new double[2], strings);
            this.th.fail("should throw a IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
    }

    public void test_format() {
        this.th.checkPoint("format(long,java.lang.StringBuffer,java.text.FieldPosition)java.lang.StringBuffer");
        StringBuffer buf = new StringBuffer(128);
        double[] limits = new double[]{1.0, 5.0};
        String[] formats = new String[]{"bad", "ok"};
        ChoiceFormat cf = new ChoiceFormat(limits, formats);
        StringBuffer result = cf.format(-1L, buf, (FieldPosition)null);
        this.th.check(buf == result, "should return the 'same' StringBuffer");
        this.th.check(buf.toString(), (Object)"bad");
        cf.format(1L, buf, (FieldPosition)null);
        this.th.check(buf.toString(), (Object)"badbad");
        cf.format(3L, buf, (FieldPosition)null);
        this.th.check(buf.toString(), (Object)"badbadbad");
        cf.format(5L, buf, (FieldPosition)null);
        this.th.check(buf.toString(), (Object)"badbadbadok");
        cf.format(6L, buf, (FieldPosition)null);
        this.th.check(buf.toString(), (Object)"badbadbadokok");
        this.th.checkPoint("format(double,java.lang.StringBuffer,java.text.FieldPosition)java.lang.StringBuffer");
        buf.setLength(0);
        result = cf.format(-1L, buf, (FieldPosition)null);
        this.th.check(buf == result, "should return the 'same' StringBuffer");
        this.th.check(buf.toString(), (Object)"bad");
        cf.format(3.0, buf, (FieldPosition)null);
        this.th.check(buf.toString(), (Object)"badbad");
        cf.format(5.0, buf, (FieldPosition)null);
        this.th.check(buf.toString(), (Object)"badbadok");
        cf.format(ChoiceFormat.previousDouble(5.0), buf, (FieldPosition)null);
        this.th.check(buf.toString(), (Object)"badbadokbad");
    }

    public void test_parse() {
        this.th.checkPoint("parse(java.lang.String,java.text.ParsePosition)java.lang.Number");
        double[] limits = new double[]{1.0, 5.0};
        String[] formats = new String[]{"bad", "ok"};
        ChoiceFormat cf = new ChoiceFormat(limits, formats);
        Number num = cf.parse("badok", new ParsePosition(1));
        this.th.check(num instanceof Double, "checking class type");
        this.th.check(Double.isNaN(num.doubleValue()), "no valid pattern --> should return NaN");
    }

    public void test_applyPattern() {
        this.th.checkPoint("applyPattern(java.lang.String)void");
        ChoiceFormat cf = new ChoiceFormat("1<ok");
        try {
            cf.applyPattern("-1.0#Less than one|1.0<One|1.0#One to two, exclusive|2.0#Two to three, inclusive|3.0<Over three, up to four|4.0<Four to five, exclusive|5.0#Five and above");
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            cf.applyPattern("1.2 \u2264 token");
            this.th.check(true);
        }
        catch (IllegalArgumentException iae) {
            this.th.fail("should NOT throw an IllegalArgumentException -- 1");
        }
        try {
            cf.applyPattern("-\u221e# token|\u221e# token");
            double[] limits = cf.getLimits();
            this.th.check(limits[0], Double.NEGATIVE_INFINITY, "checking '-\\u221E' code");
            this.th.check(limits[1], Double.POSITIVE_INFINITY, "checking '\\u221E' code");
        }
        catch (IllegalArgumentException iae) {
            this.th.fail("should NOT throw an IllegalArgumentException -- 2");
        }
        try {
            cf.applyPattern("-Infinity #token|Infinity #token");
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
    }

    public void test_getFormats() {
        this.th.checkPoint("getFormats()java.lang.String[]");
        double[] limits = new double[]{1.0, 5.0};
        Object[] formats = new String[]{"bad", "ok"};
        ChoiceFormat cf = new ChoiceFormat(limits, (String[])formats);
        this.th.check(cf.getLimits() == limits);
        this.th.check(cf.getFormats() == formats);
        this.th.check(cf.format(6.0), (Object)"ok");
        formats[1] = "ok ???";
        this.th.check(cf.format(6.0), (Object)"ok ???");
        limits[0] = 7.0;
        this.th.check(cf.format(6.0), (Object)"bad");
        cf.applyPattern("1.0 #cool| 2.0 #fun| 3.0 #done");
        limits = new double[]{1.0, 2.0, 3.0};
        formats = new String[]{"cool", "fun", "done"};
        this.th.check(Arrays.equals(cf.getLimits(), limits), "checking new limits");
        this.th.check(Arrays.equals(cf.getFormats(), formats), "checking new formats");
    }

    public void test_getLimits() {
        this.th.checkPoint("()");
    }

    public void test_setChoices() {
        String[] strings;
        this.th.checkPoint("setChoices(double[],java.lang.String[])void");
        ChoiceFormat cf = new ChoiceFormat("1<a");
        try {
            cf.setChoices(null, new String[0]);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        try {
            cf.setChoices(new double[10], null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        try {
            strings = new String[]{"bad news"};
            cf.setChoices(new double[2], strings);
            this.th.fail("should throw a IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.check(cf.getLimits().length, 1, "feeding bad arguments should not mess up the ChoiceFormat -- 1");
        this.th.check(cf.getFormats().length, 1, "feeding bad arguments should not mess up the ChoiceFormat -- 2");
        strings = new String[2];
        strings[0] = "bad news";
        cf.setChoices(new double[2], strings);
        this.th.check(cf.format(1.0), "null", "null elements are harmless");
        this.th.check(cf.clone(), cf, "checking equals handles the 'null'");
        try {
            cf.hashCode();
        }
        catch (NullPointerException npe) {
            this.th.debug("Oops the 'null' string in the array crashes hashCode yet equals works");
        }
    }

    public void test_toPattern() {
        this.th.checkPoint("toPattern()java.lang.String");
        String pattern = "-1.0<Less than one|1.0<One to two, exclusive|2.0<Two to three, inclusive|3.0<Over three, up to four|4.0<Four to five, exclusive|5.0<Five and above";
        this.checkApplyToPattern(pattern);
        this.checkApplyToPattern("1.2345<a|2.34<b|3.45<c|4.56<d|5.67<e");
        this.checkApplyToPattern("1.2345<a|2.34#b|3.45<c|4.56#d|5.67<e");
        this.checkApplyToPattern("1.2345#a|2.34#b|3.45#c|4.56#d|5.67#e");
        this.checkApplyToPattern("1.2345#a|2.34<b|3.45#c|4.56<d|5.67#e");
    }

    private void checkApplyToPattern(String pattern) {
        try {
            ChoiceFormat cf1 = new ChoiceFormat(pattern);
            ChoiceFormat cf2 = new ChoiceFormat("1<a");
            cf2.applyPattern(cf1.toPattern());
            this.th.check(cf2, cf1, "checking equality '" + pattern + "'");
            this.th.check(Arrays.equals(cf2.getLimits(), cf1.getLimits()), "checking arrays '" + pattern + "'");
        }
        catch (IllegalArgumentException iae) {
            this.th.fail("caught an IllegalArgumentException for '" + pattern + "'");
        }
    }

    public void test_nextDouble() {
        this.th.checkPoint("nextDouble(double)double");
        this.th.check(Double.isNaN(ChoiceFormat.nextDouble(Double.NaN)), "checking NaN");
        this.th.check(ChoiceFormat.nextDouble(Double.POSITIVE_INFINITY), Double.POSITIVE_INFINITY, "checking POSITIVE_INFINITY ");
        this.th.check(ChoiceFormat.nextDouble(Double.NEGATIVE_INFINITY), -1.7976931348623157E308, "checking NEGATIVE_INFINITY");
        this.th.check(ChoiceFormat.nextDouble(Double.MAX_VALUE), Double.POSITIVE_INFINITY, "checking MAX_VALUE");
        this.th.check(ChoiceFormat.nextDouble(0.0), Double.MIN_VALUE, "checking 0.0");
        this.th.check(ChoiceFormat.nextDouble(-0.0), Double.MIN_VALUE, "checking -0.0");
        this.th.checkPoint("nextDouble(double,boolean)");
        this.th.check(Double.isNaN(ChoiceFormat.nextDouble(Double.NaN, true)), "checking NaN -- true");
        this.th.check(ChoiceFormat.nextDouble(Double.POSITIVE_INFINITY, true), Double.POSITIVE_INFINITY, "checking POSITIVE_INFINITY -- true");
        this.th.check(ChoiceFormat.nextDouble(Double.NEGATIVE_INFINITY, true), -1.7976931348623157E308, "checking NEGATIVE_INFINITY -- true");
        this.th.check(ChoiceFormat.nextDouble(Double.MAX_VALUE, true), Double.POSITIVE_INFINITY, "checking MAX_VALUE -- true");
        this.th.check(ChoiceFormat.nextDouble(0.0, true), Double.MIN_VALUE, "checking  0.0 -- true");
        this.th.check(ChoiceFormat.nextDouble(-0.0, true), Double.MIN_VALUE, "checking -0.0 -- true");
        this.th.check(Double.isNaN(ChoiceFormat.nextDouble(Double.NaN, false)), "checking NaN -- false");
        this.th.check(ChoiceFormat.nextDouble(Double.NEGATIVE_INFINITY, false), Double.NEGATIVE_INFINITY, "checking POSITIVE_INFINITY -- false");
        this.th.check(ChoiceFormat.nextDouble(Double.POSITIVE_INFINITY, false), Double.MAX_VALUE, "checking NEGATIVE_INFINITY -- false");
        this.th.check(ChoiceFormat.nextDouble(-1.7976931348623157E308, false), Double.NEGATIVE_INFINITY, "checking - MAX_VALUE -- false");
        this.th.check(ChoiceFormat.nextDouble(0.0, false), -4.9E-324, "checking  0.0 -- false");
        this.th.check(ChoiceFormat.nextDouble(-0.0, false), -4.9E-324, "checking -0.0 -- false");
        double d = 1.234345567E126;
        this.th.check(ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(d, true), false), d, "checking -- 1");
        this.th.check(ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(d, false), true), d, "checking -- 2");
        d = -1.234345567E-120;
        this.th.check(ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(d, true), false), d, "checking -- 1");
        this.th.check(ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(d, false), true), d, "checking -- 2");
    }

    public void test_previousDouble() {
        this.th.checkPoint("previousDouble(double)double");
        this.th.check(Double.isNaN(ChoiceFormat.previousDouble(Double.NaN)), "checking NaN");
        this.th.check(ChoiceFormat.previousDouble(Double.NEGATIVE_INFINITY), Double.NEGATIVE_INFINITY, "checking POSITIVE_INFINITY");
        this.th.check(ChoiceFormat.previousDouble(Double.POSITIVE_INFINITY), Double.MAX_VALUE, "checking NEGATIVE_INFINITY");
        this.th.check(ChoiceFormat.previousDouble(-1.7976931348623157E308), Double.NEGATIVE_INFINITY, "checking - MAX_VALUE");
        this.th.check(ChoiceFormat.previousDouble(0.0), -4.9E-324, "checking  0.0");
        this.th.check(ChoiceFormat.previousDouble(-0.0), -4.9E-324, "checking -0.0");
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        double[] limits = new double[]{1.0, 5.0};
        Object[] formats = new String[]{"bad", "ok"};
        ChoiceFormat cf = new ChoiceFormat(limits, (String[])formats);
        ChoiceFormat clone = (ChoiceFormat)cf.clone();
        this.th.check(cf, clone, "checking equality of the clone");
        this.th.check(cf != clone, "equals but not the some");
        double[] cloneLimits = clone.getLimits();
        Object[] cloneFormats = (String[])clone.getFormats();
        this.th.check(cloneLimits != limits, "internal object are not the same -- 1");
        this.th.check(cloneFormats != formats, "internal object are not the same -- 2");
        this.th.check(Arrays.equals(cloneLimits, limits), "equality of internal arrays -- 1");
        this.th.check(Arrays.equals(cloneFormats, formats), "equality of internal arrays -- 2");
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        double[] limits = new double[]{1.0, 5.0};
        String[] formats = new String[]{"bad", "ok"};
        ChoiceFormat cf = new ChoiceFormat(limits, formats);
        this.th.check(!cf.equals(null), "checking 'null'");
        this.th.check(!cf.equals(this), "checking 'this'");
        this.th.check(cf.equals(new ChoiceFormat(limits, formats)), "checking equal -- 1");
        this.th.check(cf.equals(new ChoiceFormat("1.0 #bad|5.0#ok")), "checking equal -- 2");
        this.th.check(!cf.equals(new ChoiceFormat("1.0 #bad|5.0#oke")), "checking non equal -- 1");
        this.th.check(!cf.equals(new ChoiceFormat("1.0 #bad|5.0<ok")), "checking non equal -- 2");
        this.th.check(!cf.equals(new ChoiceFormat("1.0 #bad|5.0#ok|6.0<Oops")), "checking non equal -- 2");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        double[] limits = new double[]{1.0, 5.0};
        String[] formats = new String[]{"bad", "ok"};
        ChoiceFormat cf = new ChoiceFormat(limits, formats);
        this.th.check(cf.hashCode(), new ChoiceFormat(limits, formats).hashCode(), "checking hashCode -- 1");
        this.th.check(cf.hashCode(), new ChoiceFormat("1.0 #bad|5.0#ok").hashCode(), "checking hashCode -- 2");
        this.th.check(cf.hashCode() != new ChoiceFormat("1.0 #bad|5.0#ok|6.0<Oops").hashCode(), "checking hashCode -- 3");
    }

    public void test_serialization() {
        this.th.checkPoint("()");
        String pattern = "-1.23456789<Less than one|1.23456789#One|1.23456789<One to two, exclusive|2.23456789#Two to three, inclusive|3.23456789<Over three, up to four|4.23456789<Four to five, exclusive|5.23456789#Five and above";
        try {
            ChoiceFormat cf = new ChoiceFormat(pattern);
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("ChoiceFormat.ser"));
            oos.writeObject(cf);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            int i;
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream("ChoiceFormat.ser"));
            ChoiceFormat cf = (ChoiceFormat)ois.readObject();
            Object[] formats = cf.getFormats();
            double[] limits = cf.getLimits();
            System.out.println("lengths " + formats.length + " and " + limits.length);
            for (i = 0; i < formats.length; ++i) {
                System.out.println("limit = " + limits[i] + " format = '" + formats[i] + "' <-- " + i);
            }
            cf = new ChoiceFormat(limits, (String[])formats);
            formats = cf.getFormats();
            limits = cf.getLimits();
            System.out.println("lengths " + formats.length + " and " + limits.length);
            for (i = 0; i < formats.length; ++i) {
                System.out.println("limit = " + limits[i] + " format = '" + formats[i] + "' <-- " + i);
            }
            this.th.check(cf.toPattern(), (Object)pattern);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

