/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.Socket;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.util.Vector;

public class AcuniaSocketTest
implements Testlet {
    protected static final int port = 54321;
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.net.Socket");
        MyServer msrv = new MyServer(54321);
        if (!msrv.start()) {
            this.th.fail("failed to setup server");
            return;
        }
        this.test_Socket();
        this.test_close();
        this.test_getInputStream();
        this.test_getOutputStream();
        this.test_getInetAddress();
        this.test_getLocalAddress();
        this.test_getLocalPort();
        this.test_getPort();
        this.test_toString();
        this.test_setSocketImplFactory();
        this.test_keepalive();
        this.test_shutdownInput();
        this.test_shutdownOutput();
        msrv.stop();
    }

    private final void close(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final void constructMustFail(InetAddress addr, int p, String excType, int count) {
        block2: {
            try {
                Socket s = new Socket(addr, p);
                this.th.fail("constructor didn't fail -- " + count);
                s.close();
            }
            catch (Exception e) {
                this.th.check(e.toString().startsWith(excType), "checking exception type -- " + count);
                if (e.toString().startsWith(excType)) break block2;
                this.th.debug("got " + e.getClass().getName() + ", but expected " + excType);
            }
        }
    }

    private final void constructMustFail(String addr, int p, String excType, int count) {
        block2: {
            try {
                Socket s = new Socket(addr, p);
                this.th.fail("constructor didn't fail -- " + count);
                s.close();
            }
            catch (Exception e) {
                this.th.check(e.toString().startsWith(excType), "checking exception type -- " + count);
                if (e.toString().startsWith(excType)) break block2;
                this.th.debug("got " + e.getClass().getName() + ", but expected " + excType);
            }
        }
    }

    private final void constructMustFail(String addr, int p, InetAddress laddr, int lp, String excType, int count) {
        block2: {
            try {
                Socket s = new Socket(addr, p, laddr, lp);
                this.th.fail("constructor didn't fail -- " + count);
                s.close();
            }
            catch (Exception e) {
                this.th.check(e.toString().startsWith(excType), "checking exception type -- " + count);
                if (e.toString().startsWith(excType)) break block2;
                this.th.debug("got " + e.getClass().getName() + ", but expected " + excType);
            }
        }
    }

    private final void constructMustFail(InetAddress addr, int p, InetAddress laddr, int lp, String excType, int count) {
        block2: {
            try {
                Socket s = new Socket(addr, p, laddr, lp);
                this.th.fail("constructor didn't fail -- " + count);
                s.close();
            }
            catch (Exception e) {
                this.th.check(e.toString().startsWith(excType), "checking exception type -- " + count);
                if (e.toString().startsWith(excType)) break block2;
                this.th.debug("got " + e.getClass().getName() + ", but expected " + excType);
            }
        }
    }

    public void test_Socket() {
        InetAddress local;
        Socket sock = null;
        this.th.checkPoint("Socket(java.net.InetAddress,int)");
        this.constructMustFail((InetAddress)null, 1, "java.lang.NullPointerException", 1);
        try {
            local = InetAddress.getLocalHost();
            this.constructMustFail(local, -1, "java.lang.IllegalArgumentException", 2);
            this.constructMustFail(local, 65536, "java.lang.IllegalArgumentException", 3);
            this.constructMustFail(local, (int)((char)-1), "java.net.ConnectException", 4);
            sock = new Socket(local, 54321);
            this.th.check(sock.getInetAddress(), local, "checking remote address");
            this.th.check(sock.getLocalAddress(), local, "checking local address");
            this.th.check(sock.getPort(), 54321, "checking remote port");
            boolean bl = false;
            if (sock.getLocalPort() > 1024) {
                bl = true;
            }
            this.th.check(bl, "checking local port > 1024, got " + sock.getLocalPort());
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
        this.close(sock);
        this.th.checkPoint("Socket(java.net.InetAddress,int,java.net.InetAddress,int)");
        try {
            local = InetAddress.getLocalHost();
            this.constructMustFail((InetAddress)null, 1, local, 10300, "java.lang.NullPointerException", 1);
            this.constructMustFail(local, -1, local, 10301, "java.lang.IllegalArgumentException", 2);
            this.constructMustFail(local, 65536, local, 10302, "java.lang.IllegalArgumentException", 3);
            this.constructMustFail(local, (int)((char)-1), local, 10303, "java.net.ConnectException", 4);
            this.constructMustFail(local, 54321, local, -1, "java.lang.IllegalArgumentException", 5);
            this.constructMustFail(local, 54321, local, 65536, "java.lang.IllegalArgumentException", 6);
            sock = new Socket(local, 54321, local, 10304);
            this.th.check(sock.getInetAddress(), local, "checking remote address -- 1");
            this.th.check(sock.getLocalAddress(), local, "checking local address -- 1");
            this.th.check(sock.getPort(), 54321, "checking remote port -- 1");
            this.th.check(sock.getLocalPort(), 10304, "checking local port -- 1");
            sock.close();
            sock = new Socket(local, 54321, null, 10305);
            this.th.check(sock.getInetAddress(), local, "checking remote address -- 2");
            this.th.check(sock.getLocalAddress(), local, "checking local address -- 2");
            this.th.check(sock.getPort(), 54321, "checking remote port -- 2");
            this.th.check(sock.getLocalPort(), 10305, "checking local port -- 2");
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(sock);
        this.th.checkPoint("Socket(java.lang.String,int)");
        this.constructMustFail((String)null, 1, "java.net.ConnectException", 1);
        this.constructMustFail("localhost", -1, "java.lang.IllegalArgumentException", 2);
        this.constructMustFail("localhost", 65536, "java.lang.IllegalArgumentException", 3);
        this.constructMustFail("localhost", (int)((char)-1), "java.net.ConnectException", 4);
        try {
            local = InetAddress.getLocalHost();
            sock = new Socket(local, 54321);
            this.th.check(sock.getInetAddress(), local, "checking remote address");
            this.th.check(sock.getLocalAddress(), local, "checking local address");
            this.th.check(sock.getPort(), 54321, "checking remote port");
            boolean bl = false;
            if (sock.getLocalPort() > 1024) {
                bl = true;
            }
            this.th.check(bl, "checking local port > 1024, got " + sock.getLocalPort());
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
        this.close(sock);
        this.th.checkPoint("Socket(java.lang.String,int,java.net.InetAddress,int)");
        try {
            local = InetAddress.getLocalHost();
            this.constructMustFail((String)null, 1, local, 10306, "java.net.ConnectException", 1);
            this.constructMustFail("localhost", -1, local, 10307, "java.lang.IllegalArgumentException", 2);
            this.constructMustFail("localhost", 65536, local, 10312, "java.lang.IllegalArgumentException", 3);
            this.constructMustFail("localhost", (int)((char)-1), local, 10313, "java.net.ConnectException", 4);
            this.constructMustFail("localhost", 54321, local, -1, "java.lang.IllegalArgumentException", 5);
            this.constructMustFail("localhost", 54321, local, 65536, "java.lang.IllegalArgumentException", 6);
            sock = new Socket("localhost", 54321, local, 10314);
            InetAddress loopb = InetAddress.getByName("127.0.0.1");
            this.th.check(sock.getInetAddress(), loopb, "checking remote address -- 1");
            this.th.check(sock.getLocalAddress(), local, "checking local address -- 1");
            this.th.check(sock.getPort(), 54321, "checking remote port -- 1");
            this.th.check(sock.getLocalPort(), 10314, "checking local port -- 1");
            sock.close();
            sock = new Socket("localhost", 54321, null, 10315);
            this.th.check(sock.getInetAddress(), loopb, "checking remote address -- 2");
            this.th.check(sock.getLocalAddress(), loopb, "checking local address -- 2");
            this.th.check(sock.getPort(), 54321, "checking remote port -- 2");
            this.th.check(sock.getLocalPort(), 10315, "checking local port -- 2");
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
        this.close(sock);
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        Socket sock = null;
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            sock = new Socket(laddr, 54321, null, 10335);
            sock.close();
            sock.close();
            sock.close();
            try {
                sock.getReceiveBufferSize();
                this.th.fail("should throw an SocketException -- 1");
            }
            catch (IOException e) {
                this.th.check(true);
            }
            try {
                sock.getOutputStream();
                this.th.fail("should throw an Exception -- 1");
            }
            catch (Exception e) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
    }

    public void test_getInputStream() {
        this.th.checkPoint("getInputStream()java.io.InputStream");
        Socket sock = null;
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            sock = new Socket(laddr, 54321, null, 10345);
            InputStream in = sock.getInputStream();
            this.th.check(in.available(), 0, "checking available -- 1");
            in.close();
            try {
                sock.getSendBufferSize();
                this.th.fail("should throw an SocketException -- 1");
            }
            catch (IOException e) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(sock);
    }

    public void test_getOutputStream() {
        this.th.checkPoint("getOutputStream()java.io.OutputStream");
        Socket sock = null;
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            sock = new Socket(laddr, 54321, null, 10355);
            OutputStream out = sock.getOutputStream();
            out.close();
            try {
                sock.getReceiveBufferSize();
                this.th.fail("should throw an SocketException -- 1");
            }
            catch (IOException e) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(sock);
    }

    public void test_getInetAddress() {
        this.th.checkPoint("()");
    }

    public void test_getLocalAddress() {
        this.th.checkPoint("()");
    }

    public void test_getLocalPort() {
        this.th.checkPoint("()");
    }

    public void test_getPort() {
        this.th.checkPoint("()");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        Socket sock = null;
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            sock = new Socket(laddr, 54321, null, 10325);
            boolean bl = false;
            if (sock.toString().indexOf(laddr.toString()) != -1) {
                bl = true;
            }
            this.th.check(bl, "should contain remote address");
            boolean bl2 = false;
            if (sock.toString().indexOf("10325") != -1) {
                bl2 = true;
            }
            this.th.check(bl2, "should contain local port");
            boolean bl3 = false;
            if (sock.toString().indexOf("54321") != -1) {
                bl3 = true;
            }
            this.th.check(bl3, "should contain remote port");
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(sock);
    }

    public void test_keepalive() {
        this.th.checkPoint("getKeepAlive()boolean");
        Socket sock = null;
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            sock = new Socket(laddr, 54321);
            this.th.check(sock.getKeepAlive() ^ true, "default is false");
            sock.setKeepAlive(true);
            this.th.check(sock.getKeepAlive(), "set to true");
            sock.setKeepAlive(false);
            this.th.check(sock.getKeepAlive() ^ true, "set to false");
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(sock);
    }

    public void test_shutdownInput() {
        this.th.checkPoint("shutdownInput()void");
        Socket sock = null;
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            sock = new Socket(laddr, 54321);
            InputStream in = sock.getInputStream();
            sock.shutdownInput();
            this.th.check(in.read(), -1, "EOF reached");
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(sock);
    }

    public void test_shutdownOutput() {
        this.th.checkPoint("shutdownOutput()void");
        Socket sock = null;
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            sock = new Socket(laddr, 54321);
            OutputStream out = sock.getOutputStream();
            sock.shutdownOutput();
            try {
                out.write(new byte[256]);
                this.th.fail("after shutdownOutput IOException should be thrown");
            }
            catch (IOException e) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(sock);
    }

    public void test_setSocketImplFactory() {
        this.th.checkPoint("setSocketImplFactory(java.net.SocketImplFactory)void");
        try {
            Socket.setSocketImplFactory(null);
            Socket.setSocketImplFactory(null);
            Socket.setSocketImplFactory(new TestFactory());
            try {
                Socket.setSocketImplFactory(new TestFactory());
                this.th.fail("Factory can be set only once -- 1");
            }
            catch (SocketException se) {
                this.th.check(true);
            }
            try {
                Socket.setSocketImplFactory(null);
                this.th.fail("Factory can be set only once -- 2");
            }
            catch (SocketException se) {
                this.th.check(true);
            }
            try {
                Socket.setSocketImplFactory(new TestFactory());
                this.th.fail("Factory can be set only once -- 3");
            }
            catch (SocketException se) {
                this.th.check(true);
            }
        }
        catch (IOException e) {
            this.th.fail("caught unwanted exception " + e);
        }
    }

    static class MyServer
    implements Runnable {
        private int port;
        private ServerSocket srv;
        private boolean stop;

        public void stop() {
            this.stop = true;
            try {
                this.srv.close();
            }
            catch (IOException iOException) {}
            while (this.stop) {
                Thread.yield();
            }
        }

        public boolean start() {
            try {
                this.srv = new ServerSocket(this.port);
                this.srv.setSoTimeout(150);
                new Thread((Runnable)this, "MyServer thread").start();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public void run() {
            try {
                Vector<Socket> v = new Vector<Socket>();
                while (!this.stop) {
                    try {
                        v.add(this.srv.accept());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                int i = 0;
                while (i < v.size()) {
                    try {
                        ((Socket)v.get(i)).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
                this.srv.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stop = false;
        }

        public MyServer(int port) {
            this.port = port;
        }
    }

    static class TestFactory
    implements SocketImplFactory {
        private static Constructor constructor;

        public SocketImpl createSocketImpl() {
            try {
                return (SocketImpl)constructor.newInstance(null);
            }
            catch (Exception e) {
                return null;
            }
        }

        public TestFactory() {
            if (constructor == null) {
                try {
                    Class<?> cl = Class.forName("java.net.PlainSocketImpl");
                    constructor = cl.getDeclaredConstructor(null);
                    constructor.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

