/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.ServerSocket;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AcuniaServerSocketTest
implements Testlet {
    protected TestHarness th;
    protected InetAddress zeros;
    protected boolean pass;
    protected int connectedPort;
    protected int count;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.net.ServerSocket");
        try {
            this.zeros = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException uhe) {
            this.th.fail("couldn't create InetAddress '0.0.0.0'");
        }
        this.test_ServerSocket();
        this.test_accept();
        this.test_close();
        this.test_getInetAddress();
        this.test_getLocalPort();
        this.test_toString();
        this.test_SoTimeout();
        this.test_implAccept();
        this.test_setSocketFactory();
    }

    private final void checkConstructFails(int port, int backlog, InetAddress addr, int count) {
        try {
            if (addr == null) {
                if (backlog == -1) {
                    new ServerSocket(port);
                } else {
                    new ServerSocket(port, backlog);
                }
            } else {
                new ServerSocket(port, backlog, addr);
            }
            this.th.fail("constructor must fail -- " + count);
        }
        catch (IOException ioe) {
            this.th.fail("caught wrong Exception -- " + count + " --> " + ioe);
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "constructor failed with correct exception " + count);
        }
    }

    private final void close(ServerSocket srv) {
        if (srv != null) {
            try {
                srv.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void test_ServerSocket() {
        this.th.checkPoint("ServerSocket(int)");
        ServerSocket srv = null;
        this.checkConstructFails(-1, -1, null, 1);
        this.checkConstructFails(65536, -1, null, 2);
        try {
            srv = new ServerSocket(55124);
            this.th.check(srv.getInetAddress(), this.zeros, "checking address");
            this.th.check(srv.getLocalPort(), 55124, "checking port");
            srv.close();
            srv = new ServerSocket(0);
            boolean bl = false;
            if (srv.getLocalPort() > 1024) {
                bl = true;
            }
            this.th.check(bl, "port should not be in the reserved area below 1024, got " + srv.getLocalPort());
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(srv);
        this.th.checkPoint("ServerSocket(int,int)");
        this.checkConstructFails(-1, 1, null, 1);
        this.checkConstructFails(65536, 1, null, 2);
        try {
            srv = new ServerSocket(55556, 1);
            this.th.check(srv.getInetAddress(), this.zeros, "checking address");
            this.th.check(srv.getLocalPort(), 55556, "checking port");
            srv.close();
            srv = new ServerSocket(0);
            boolean bl = false;
            if (srv.getLocalPort() > 1024) {
                bl = true;
            }
            this.th.check(bl, "port should not be in the reserved area below 1024, got " + srv.getLocalPort());
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
        this.close(srv);
        this.th.checkPoint("ServerSocket(int,int,java.net.InetAddress)");
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            this.checkConstructFails(-1, 1, null, 1);
            this.checkConstructFails(65536, 1, null, 2);
            srv = new ServerSocket(55557, 1, laddr);
            this.th.check(srv.getInetAddress(), laddr, "checking address -- 1");
            this.th.check(srv.getLocalPort(), 55557, "checking port");
            srv.close();
            srv = new ServerSocket(0);
            boolean bl = false;
            if (srv.getLocalPort() > 1024) {
                bl = true;
            }
            this.th.check(bl, "port should not be in the reserved area below 1024, got " + srv.getLocalPort());
            srv.close();
            srv = new ServerSocket(55558, 1, null);
            this.th.check(srv.getInetAddress(), this.zeros, "checking address -- 2");
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
        this.close(srv);
    }

    public void test_accept() {
        this.th.checkPoint("accept()java.net.Socket");
        ServerSocket srv = null;
        try {
            srv = new ServerSocket(55559);
            this.connectedPort = -1;
            new Connector(srv, this);
            Socket sock = srv.accept();
            while (this.connectedPort == -1) {
                Thread.yield();
            }
            InetAddress loopb = InetAddress.getByName("127.0.0.1");
            boolean bl = false;
            if (sock.getLocalPort() > 1024) {
                bl = true;
            }
            this.th.check(bl, "port should not be in the reserved area below 1024, got " + sock.getLocalPort());
            this.th.check(sock.getPort(), this.connectedPort, "checking port of connecting socket");
            this.th.check(sock.getInetAddress(), loopb, "checking address of connecting socket");
            InetAddress laddr = InetAddress.getLocalHost();
            InetAddress zeros = InetAddress.getByName("0.0.0.0");
            this.checkConnect(srv, zeros, true, 1);
            this.checkConnect(srv, laddr, true, 2);
            this.checkConnect(srv, loopb, true, 3);
            srv.close();
            srv = new ServerSocket(55550, 10, laddr);
            this.checkConnect(srv, zeros, laddr.equals(loopb), 4);
            this.checkConnect(srv, laddr, true, 5);
            this.checkConnect(srv, loopb, laddr.equals(loopb), 6);
            srv.close();
            srv = new ServerSocket(55551, 10, loopb);
            this.checkConnect(srv, zeros, true, 7);
            this.checkConnect(srv, laddr, laddr.equals(loopb), 8);
            this.checkConnect(srv, loopb, true, 9);
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
        this.close(srv);
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        this.th.checkPoint("toString()java.lang.String");
        ServerSocket srv = null;
        try {
            srv = new ServerSocket(55561);
            srv.close();
            srv.close();
            srv.close();
            try {
                srv.accept();
                this.th.fail("Cannot Accept -- socket is closed");
            }
            catch (IOException i) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
    }

    public void test_getInetAddress() {
        this.th.checkPoint("()");
    }

    public void test_getLocalPort() {
        this.th.checkPoint("()");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        ServerSocket srv = null;
        try {
            srv = new ServerSocket(55560);
            boolean bl = false;
            if (srv.toString().indexOf("55560") != -1) {
                bl = true;
            }
            this.th.check(bl, "should contain localPort");
            boolean bl2 = false;
            if (srv.toString().indexOf(srv.getInetAddress().toString()) != -1) {
                bl2 = true;
            }
            this.th.check(bl2, "should contain local address");
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
        this.close(srv);
    }

    public void test_SoTimeout() {
        this.th.checkPoint("getSoTimeout()int");
        ServerSocket srv = null;
        try {
            srv = new ServerSocket(55560);
            this.th.check(srv.getSoTimeout(), 0, "checking timeout value -- 1");
            this.th.checkPoint("setSoTimeout(int)void");
            srv.setSoTimeout(10);
            this.th.check(srv.getSoTimeout(), 10, "checking timeout value -- 2");
            try {
                srv.accept();
                this.th.fail("'accept' should have timed out ...");
            }
            catch (InterruptedIOException iioe) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
        }
        this.close(srv);
    }

    public void test_implAccept() {
        this.th.checkPoint("implAccept(java.net.Socket)void");
        MyServerSocket msrv = null;
        try {
            this.connectedPort = -1;
            msrv = new MyServerSocket(55123);
            new Connector(msrv, this);
            Socket sock = msrv.accept();
            while (this.connectedPort == -1) {
                Thread.yield();
            }
            this.th.check(sock instanceof MySocket, "checking class");
            boolean bl = false;
            if (sock.getLocalPort() > 1024) {
                bl = true;
            }
            this.th.check(bl, "checking localport is > 1024 --> " + sock.getLocalPort());
            this.th.check(sock.getPort(), this.connectedPort, "checking remote port");
            InetAddress loopb = InetAddress.getByName("127.0.0.1");
            this.th.check(sock.getLocalAddress(), loopb, "checking localAddress");
            this.th.check(sock.getInetAddress(), loopb, "checking remote address");
        }
        catch (Exception e) {
            this.th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
        this.close(msrv);
    }

    public void test_setSocketFactory() {
        this.th.checkPoint("setSocketFactory(java.net.SocketImplFactory)void");
        try {
            ServerSocket.setSocketFactory(null);
            ServerSocket.setSocketFactory(null);
            ServerSocket.setSocketFactory(new TestFactory());
            try {
                ServerSocket.setSocketFactory(new TestFactory());
                this.th.fail("Factory can be set only once -- 1");
            }
            catch (SocketException se) {
                this.th.check(true);
            }
            try {
                ServerSocket.setSocketFactory(null);
                this.th.fail("Factory can be set only once -- 2");
            }
            catch (SocketException se) {
                this.th.check(true);
            }
            try {
                ServerSocket.setSocketFactory(new TestFactory());
                this.th.fail("Factory can be set only once -- 3");
            }
            catch (SocketException se) {
                this.th.check(true);
            }
        }
        catch (IOException e) {
            this.th.fail("caught unwanted exception " + e);
        }
    }

    private final void checkConnect(ServerSocket srv, InetAddress from, boolean pass, int count) throws IOException {
        this.pass = pass;
        this.count = count;
        new Connector(from, srv.getLocalPort(), this);
        srv.setSoTimeout(250);
        try {
            srv.accept();
        }
        catch (InterruptedIOException iioe) {
            this.th.check(pass ^ true, "checkConnect -- " + count);
        }
    }

    private final /* synthetic */ void this() {
        this.connectedPort = -1;
        this.count = 0;
    }

    public AcuniaServerSocketTest() {
        this.this();
    }

    static class Connector
    implements Runnable {
        private InetAddress address;
        private int port;
        private boolean report;
        private AcuniaServerSocketTest test;

        public void run() {
            try {
                Socket sock = new Socket(this.address, this.port);
                if (this.report) {
                    this.test.th.check(this.test.pass, "check connecting -- " + this.test.count + " connection made");
                } else {
                    this.test.th.check(sock.getInetAddress(), this.address, "checking address in Connector");
                    this.test.th.check(sock.getPort(), this.port, "checking port in Connector");
                    this.test.connectedPort = sock.getLocalPort();
                }
                sock.close();
            }
            catch (IOException ioe) {
                if (this.report) {
                    this.test.th.check(this.test.pass ^ true, "check connecting -- " + this.test.count + " threw exception ");
                }
                this.test.th.fail("got unwanted exception " + ioe + " while Connecting");
            }
        }

        public Connector(ServerSocket srv, AcuniaServerSocketTest test) {
            this.port = srv.getLocalPort();
            this.address = srv.getInetAddress();
            this.test = test;
            this.report = false;
            new Thread((Runnable)this, "Connector Thread").start();
        }

        public Connector(InetAddress addr, int port, AcuniaServerSocketTest test) {
            this.port = port;
            this.address = addr;
            this.test = test;
            this.report = true;
            new Thread((Runnable)this, "Connector Thread").start();
        }
    }

    static class MyServerSocket
    extends ServerSocket {
        public Socket accept() throws IOException {
            MySocket s = new MySocket();
            this.implAccept(s);
            return s;
        }

        public MyServerSocket(int port) throws IOException {
            super(port);
        }
    }

    static class MySocket
    extends Socket {
        MySocket() {
        }
    }

    static class TestFactory
    implements SocketImplFactory {
        private static Constructor constructor;

        public SocketImpl createSocketImpl() {
            try {
                return (SocketImpl)constructor.newInstance(null);
            }
            catch (Exception e) {
                return null;
            }
        }

        public TestFactory() {
            if (constructor == null) {
                try {
                    Class<?> cl = Class.forName("java.net.PlainSocketImpl");
                    constructor = cl.getDeclaredConstructor(null);
                    constructor.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

