/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.reflect.Constructor;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.reflect.Constructor;

public class SMConstructorTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.reflect.Constructor");
        this.test_newInstance();
        this.test_getDeclaringClass();
        this.test_getExceptionTypes();
        this.test_getModifiers();
        this.test_getName();
        this.test_getParameterTypes();
        this.test_equals();
        this.test_hashcode();
        this.test_toString();
    }

    protected void test_newInstance() {
    }

    protected void test_getDeclaringClass() {
        this.th.checkPoint("getDeclaringClass()Ljava.lang.Class");
        Constructor<?> c = null;
        try {
            c.getDeclaringClass();
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            c = this.getClass().getConstructor(new Class[0]);
            this.th.check(c.getDeclaringClass().isInstance(this), "Classes are the same");
        }
        catch (Exception e) {
            this.th.fail("no exceptions expected");
        }
    }

    protected void test_getExceptionTypes() {
        this.th.checkPoint("getExceptionTypes()java.lang.Class[]");
        Constructor<?> c = null;
        try {
            c.getExceptionTypes();
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            c = this.getClass().getConstructor(null);
            Class<?>[] clh = c.getExceptionTypes();
            boolean bl = false;
            if (clh.length == 3) {
                bl = true;
            }
            this.th.check(bl, "this constructor throws 3 exceptions");
            boolean bl2 = false;
            if (clh[0] == new NullPointerException().getClass()) {
                bl2 = true;
            }
            this.th.check(bl2, "clh[0] is a NullPointerException");
            boolean bl3 = false;
            if (clh[1] == new IllegalArgumentException().getClass()) {
                bl3 = true;
            }
            this.th.check(bl3, "clh[1] is an IllegalArgumentException");
            boolean bl4 = false;
            if (clh[2] == new Exception().getClass()) {
                bl4 = true;
            }
            this.th.check(bl4, "clh[2] is an Exception");
            clh = new Class[]{new Object().getClass()};
            c = this.getClass().getConstructor(clh);
            clh = c.getExceptionTypes();
            boolean bl5 = false;
            if (clh.length == 0) {
                bl5 = true;
            }
            this.th.check(bl5, "this constructor doesn't throw Exceptions");
        }
        catch (Exception e) {
            this.th.fail("no exceptions expected");
        }
    }

    protected void test_getModifiers() {
        Constructor<?>[] ca;
        this.th.checkPoint("getModifiers()int");
        try {
            ca = this.getClass().getDeclaredConstructors();
            if (ca == null) {
                this.th.fail("this.getClass().getDeclaredConstructors() returned null");
            } else {
                int publics = 0;
                int privates = 0;
                int protecteds = 0;
                int defaults = 0;
                if (ca.length == 5) {
                    int i = 0;
                    while (i < 5) {
                        if (ca[i].getModifiers() == 1) {
                            ++publics;
                        }
                        if (ca[i].getModifiers() == 2) {
                            ++privates;
                        }
                        if (ca[i].getModifiers() == 4) {
                            ++protecteds;
                        }
                        if (ca[i].getModifiers() == 0) {
                            ++defaults;
                        }
                        ++i;
                    }
                    this.th.check(publics, 2, "should be 2 public constructors, got " + publics);
                    this.th.check(privates, 1, "should be 1 public constructor, got " + privates);
                    this.th.check(protecteds, 1, "should be 1 protected constructor, got " + protecteds);
                    this.th.check(defaults, 1, "should be 1 default constructor, got " + defaults);
                } else {
                    this.th.fail("Class.getDeclaredConstructors() failed found " + ca.length + " constructors, 5 expected");
                }
            }
        }
        catch (Exception e) {
            this.th.fail("no exceptions expected, got " + e + " (1)");
            e.printStackTrace();
        }
        try {
            ca = new Object().getClass().getConstructors();
            boolean bl = false;
            if (ca != null) {
                bl = true;
            }
            this.th.check(bl, "new Object().getClass().getConstructors() returned null");
            this.th.check(ca.length, 1, "new Object().getClass().getConstructors() should return 1 constructor, got " + ca.length);
            boolean bl2 = false;
            if (ca[0].getModifiers() == 1) {
                bl2 = true;
            }
            this.th.check(bl2, "new Object().getClass().getConstructors() should yield 1 PUBLIC constructor, but getModifiers() returned " + ca[0].getModifiers());
        }
        catch (Exception e) {
            this.th.fail("no exceptions expected, got " + e + " (2)");
            e.printStackTrace();
        }
    }

    protected void test_getName() {
        this.th.checkPoint("getName()java.lang.String");
        try {
            Constructor<?> c = this.getClass().getConstructor(new Class[0]);
            this.th.check(c.getName().equals("gnu.testlet.wonka.lang.reflect.Constructor.SMConstructorTest"), "wrong constructor name");
            Constructor<?>[] ca = this.getClass().getDeclaredConstructors();
            int i = 0;
            while (i < 4) {
                this.th.check(ca[i].getName().equals("gnu.testlet.wonka.lang.reflect.Constructor.SMConstructorTest"), "wrong constructor name -- " + (i + 1));
                ++i;
            }
            ca = new Object().getClass().getConstructors();
            this.th.check(ca[0].getName().equals("java.lang.Object"), "wrong name for Object Constructor");
        }
        catch (Exception e) {
            this.th.fail("no exceptions expected");
        }
    }

    protected void test_getParameterTypes() {
        this.th.checkPoint("getParameterTypes()java.lang.Class[]");
        Constructor<?> c = null;
        try {
            c.getParameterTypes();
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            c = this.getClass().getConstructor(null);
            Class<?>[] clh = c.getParameterTypes();
            if (clh != null) {
                boolean bl = false;
                if (clh.length == 0) {
                    bl = true;
                }
                this.th.check(bl, "Constructor has no parameters");
            } else {
                this.th.fail("getParameterTypes should not return null");
            }
            Constructor<?>[] ca = this.getClass().getDeclaredConstructors();
            clh = ca[1].getParameterTypes();
            boolean bl = false;
            if (clh.length == 1) {
                bl = true;
            }
            this.th.check(bl, "Constructor takes only one Parameter -- 1");
            boolean bl2 = false;
            if (clh[0] == Integer.TYPE) {
                bl2 = true;
            }
            this.th.check(bl2, "parameter is an int");
            clh = ca[2].getParameterTypes();
            boolean bl3 = false;
            if (clh.length == 1) {
                bl3 = true;
            }
            this.th.check(bl3, "Constructor takes only one Parameter -- 1");
            boolean bl4 = false;
            if (clh[0] == Long.TYPE) {
                bl4 = true;
            }
            this.th.check(bl4, "parameter is a long");
            clh = ca[3].getParameterTypes();
            boolean bl5 = false;
            if (clh.length == 1) {
                bl5 = true;
            }
            this.th.check(bl5, "Constructor takes only one Parameter -- 1");
            boolean bl6 = false;
            if (clh[0] == new Object().getClass()) {
                bl6 = true;
            }
            this.th.check(bl6, "parameter is an Object");
            clh = new Class[4];
            clh[0] = new byte[1].getClass();
            clh[2] = clh[1] = Integer.TYPE;
            clh[3] = "a".getClass();
            c = "a".getClass().getConstructor(clh);
            Class<?>[] clh1 = c.getParameterTypes();
            boolean bl7 = false;
            if (clh1.length == 4) {
                bl7 = true;
            }
            this.th.check(bl7, "array should have length  1");
            boolean bl8 = false;
            if (clh1[0] == new byte[1].getClass()) {
                bl8 = true;
            }
            this.th.check(bl8, "parameter is a String");
            boolean bl9 = false;
            if (clh1[1] == Integer.TYPE) {
                bl9 = true;
            }
            this.th.check(bl9, "parameter is a String");
            boolean bl10 = false;
            if (clh1[2] == Integer.TYPE) {
                bl10 = true;
            }
            this.th.check(bl10, "parameter is a String");
            boolean bl11 = false;
            if (clh1[3] == "a".getClass()) {
                bl11 = true;
            }
            this.th.check(bl11, "parameter is a String");
        }
        catch (Exception e) {
            this.th.fail("no exceptions expected caught " + e);
        }
    }

    protected void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        Constructor<?> c1 = null;
        Constructor<?> c2 = null;
        try {
            c1 = this.getClass().getConstructor(new Class[0]);
            this.th.check(c1.equals(c2) ^ true, "should return false");
            c2 = this.getClass().getConstructor(null);
            this.th.check(c2.equals(c1), "constructors are equal");
            c2 = new Object().getClass().getConstructor(new Class[0]);
            this.th.check(c2.equals(c1) ^ true, "constructors are not equal -- 1");
            Class[] clh = new Class[]{new Object().getClass()};
            c2 = this.getClass().getConstructor(clh);
            this.th.check(c2.equals(c1) ^ true, "constructors are not equal -- 2");
        }
        catch (Exception e) {
            this.th.fail("no exception expected " + e);
            e.printStackTrace();
        }
    }

    protected void test_hashcode() {
        this.th.checkPoint("hashCode()int");
        Constructor c = null;
        try {
            c.hashCode();
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Constructor<?>[] ca = this.getClass().getDeclaredConstructors();
            int h = ca[0].hashCode();
            int j = ca[0].getDeclaringClass().getName().hashCode();
            boolean bl = false;
            if (h == j) {
                bl = true;
            }
            this.th.check(bl, "checking hashCode Algorithm");
            boolean bl2 = false;
            if (ca[0].hashCode() == h) {
                bl2 = true;
            }
            this.th.check(bl2, "hashCodes are Equal -- 1");
            boolean bl3 = false;
            if (ca[0].hashCode() == ca[1].hashCode()) {
                bl3 = true;
            }
            this.th.check(bl3, "hashCodes are Equal -- 2");
        }
        catch (Exception e) {
            this.th.fail("no exceptions expected caught " + e);
        }
    }

    protected void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        Constructor<?> c = null;
        try {
            c.getParameterTypes();
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            c = new Object().getClass().getConstructor(null);
            this.th.check(c.toString().equals("public java.lang.Object()"));
            Constructor<?>[] ca = this.getClass().getDeclaredConstructors();
            this.th.check(ca[0].toString(), (Object)"public gnu.testlet.wonka.lang.reflect.Constructor.SMConstructorTest() throws java.lang.NullPointerException,java.lang.IllegalArgumentException,java.lang.Exception");
            this.th.check(ca[1].toString(), (Object)"private gnu.testlet.wonka.lang.reflect.Constructor.SMConstructorTest(int)");
            this.th.check(ca[2].toString(), (Object)"protected gnu.testlet.wonka.lang.reflect.Constructor.SMConstructorTest(long)");
            this.th.check(ca[3].toString(), (Object)"public gnu.testlet.wonka.lang.reflect.Constructor.SMConstructorTest(java.lang.Object)");
            this.th.check(ca[4].toString(), (Object)"gnu.testlet.wonka.lang.reflect.Constructor.SMConstructorTest(java.lang.Object[],int,byte[]) throws java.lang.RuntimeException");
            Class[] clh = new Class[4];
            clh[0] = new byte[1].getClass();
            clh[2] = clh[1] = Integer.TYPE;
            clh[3] = "a".getClass();
            c = "a".getClass().getConstructor(clh);
            this.th.check(c.toString(), (Object)"public java.lang.String(byte[],int,int,java.lang.String) throws java.io.UnsupportedEncodingException");
        }
        catch (Exception e) {
            this.th.fail("no exceptions expected caught " + e);
            e.printStackTrace();
        }
    }

    public SMConstructorTest() throws NullPointerException, IllegalArgumentException, Exception {
    }

    private SMConstructorTest(int i) {
    }

    protected SMConstructorTest(long l) {
    }

    public SMConstructorTest(Object o) {
    }

    SMConstructorTest(Object[] o, int k, byte[] b) throws RuntimeException {
    }
}

