/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.ref.WeakReference;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.lang.ref.Reference.Garbage;
import gnu.testlet.wonka.lang.ref.Reference.GarbageListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class AcuniaWeakReferenceTest
implements Testlet,
GarbageListener {
    protected TestHarness th;
    private Runtime rt = Runtime.getRuntime();
    private long mem;
    private boolean got1;
    private boolean got2;
    private boolean got3;
    private boolean done;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.ref.WeakReference");
        this.test_WeakReference();
        this.test_get();
        this.test_clear();
        this.test_enqueue();
        this.test_isEnqueued();
        this.test_behaviour();
    }

    public void test_WeakReference() {
        this.th.checkPoint("WeakReference(java.lang.Object)");
        ReferenceQueue rq = new ReferenceQueue();
        try {
            new WeakReference<Object>(null, rq);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true, "correct exception was thrown -- 1");
        }
        this.th.checkPoint("WeakReference(java.lang.Object,java.lang.ref.ReferenceQueue)");
        try {
            new WeakReference<Object>(null, rq);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true, "correct exception was thrown -- 1");
        }
        try {
            new WeakReference<Object>(new Object(), null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException np) {
            this.th.check(true, "correct exception was thrown -- 2");
        }
    }

    public void test_get() {
        this.th.checkPoint("get()java.lang.Object");
        String msg = "always returns null";
        WeakReference<String> wr = new WeakReference<String>(msg, new ReferenceQueue());
        this.th.check(wr.get(), msg, msg);
        wr.clear();
        this.th.check(wr.get(), null, msg);
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        ReferenceQueue rq = new ReferenceQueue();
        WeakReference wr = this.makeWeak(rq, 1000000);
        Reference ref = null;
        for (int i = 0; ref == null && i < 10; ++i) {
            try {
                System.gc();
                System.runFinalization();
                ref = rq.remove(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.th.check(ref, wr, "reference should be the same");
        if (ref != null) {
            this.th.check(ref.get(), null, "referent is collected");
        } else {
            this.th.fail("WeakReference was not put on the queue");
        }
        long memNow = this.rt.totalMemory() - this.rt.freeMemory();
        this.th.debug("Memory used is now " + memNow + ", was " + this.mem);
        this.th.check(memNow + 1000000L < this.mem);
    }

    public void test_enqueue() {
        this.th.checkPoint("enqueue()boolean");
        String msg = "checking return value -- ";
        int i = 1;
        ReferenceQueue rq = new ReferenceQueue();
        WeakReference<String> wr = new WeakReference<String>(msg, rq);
        this.th.check(wr.enqueue(), msg + i++);
        this.th.check(!wr.enqueue(), msg + i++);
        Reference ref = rq.poll();
        this.th.check(ref, wr, "reference was put into the queue");
        if (ref != null) {
            this.th.check(ref.get(), msg, "Object was not collected yet");
        }
        this.th.check(!wr.enqueue(), msg + i++);
        wr.clear();
        msg = "special case -- ";
        i = 1;
        wr = new WeakReference<String>(msg, rq);
        wr.clear();
        this.th.check(!wr.isEnqueued(), msg + i++);
        this.th.check(wr.enqueue(), msg + i++);
        this.th.check(!wr.enqueue(), msg + i++);
        this.th.check(rq.poll(), wr, "reference was put into the queue");
    }

    public void test_isEnqueued() {
        this.th.checkPoint("isEnqueued()boolean");
        String msg = "checking return value -- ";
        int i = 1;
        ReferenceQueue rq = new ReferenceQueue();
        WeakReference<String> wr = new WeakReference<String>(msg, rq);
        this.th.check(!wr.isEnqueued(), msg + i++);
        this.th.check(wr.enqueue(), msg + i++);
        this.th.check(wr.isEnqueued(), msg + i++);
        this.th.check(rq.poll(), wr, "reference was put into the queue");
        this.th.check(!wr.isEnqueued(), msg + i++);
        wr.clear();
    }

    public void test_behaviour() {
        this.th.checkPoint("WeakReference(java.lang.Object,java.lang.ref.ReferenceQueue)");
        ReferenceQueue rq = new ReferenceQueue();
        Garbage gb = new Garbage(this, null, 1);
        gb = new Garbage(this, gb, 2);
        WeakReference<Garbage> wr = new WeakReference<Garbage>(gb, rq);
        gb = new Garbage(this, null, 3);
        wr = new WeakReference<Garbage>(gb, rq);
        gb = null;
        while (!(this.got1 || this.got2 || this.got3)) {
            System.gc();
            System.runFinalization();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {}
        }
        this.th.check(rq.poll(), wr, "WeakReference got collected --> reference put in the queue");
        this.th.check(wr.get(), null, "Object is collected");
        gb = new Garbage(this, null, 4);
        new WeakReference<Garbage>(new Garbage(this, gb, 2), rq);
        this.got2 = false;
        while (!this.got2) {
            System.gc();
            System.runFinalization();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {}
        }
        this.done = true;
        wr = null;
    }

    public void reportFinalize(int id) {
        if (id == 3 && !this.got3) {
            this.got3 = true;
            this.th.check(true, "collecting Garbage object 3");
        } else if (id == 2 && !this.got2) {
            this.got2 = true;
            this.th.check(true, "collecting Garbage object 2");
        } else if (id == 1 && !this.got1) {
            this.got1 = true;
            this.th.check(true, "collecting Garbage object 1");
        } else if (!this.done) {
            this.th.fail("collected wrong object (id = " + id + ")");
        }
    }

    private WeakReference makeWeak(ReferenceQueue rq, int size) {
        long[] obj = new long[size];
        this.mem = this.rt.totalMemory() - this.rt.freeMemory();
        return new WeakReference<long[]>(obj, rq);
    }
}

