/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Throwable;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class AcuniaThrowableTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.Throwable");
        this.test_Handling();
        this.test_fillInStackTrace();
    }

    private final void check() throws MyFirstException, MySecondException {
        throw new MyFirstException();
    }

    private final void check2() throws MyFirstException {
        try {
            this.check();
        }
        catch (MySecondException mse) {
            this.th.fail("no MySecondException should be thrown got " + mse);
        }
    }

    private final void check3() throws MyFirstException {
        try {
            this.check();
        }
        catch (MyFirstException mfe) {
            throw (MyFirstException)mfe.fillInStackTrace();
        }
        catch (MySecondException mse) {
            this.th.fail("no MySecondException should be thrown got " + mse);
        }
    }

    public void test_Handling() {
        this.th.checkPoint("internal exception handling");
        try {
            this.check2();
        }
        catch (MyFirstException mfe) {
            this.th.check(true, "Exception was caught in the right place");
        }
    }

    public void test_fillInStackTrace() {
        this.th.checkPoint("fillInStackTrace()");
        try {
            this.check3();
        }
        catch (MyFirstException mfe) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            mfe.printStackTrace(ps);
            byte[] bytes = baos.toByteArray();
            BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
            try {
                String line = r.readLine();
                line = r.readLine();
                line = r.readLine();
                boolean bl = false;
                if (line.indexOf("check3()") >= 0) {
                    bl = true;
                }
                this.th.check(bl, "Third line of stack trace must mention check3()");
            }
            catch (IOException ioe) {
                this.th.fail("no IOException should be thrown got " + ioe);
            }
        }
    }

    public void test_() {
        this.th.checkPoint("()");
    }

    static class MyFirstException
    extends Exception {
        MyFirstException() {
        }
    }

    static class MySecondException
    extends Exception {
        MySecondException() {
        }
    }
}

