/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.System;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class arraycopy
implements Testlet {
    public void fill(int[] a) {
        int i = 0;
        while (i < a.length) {
            a[i] = i;
            ++i;
        }
    }

    public void check(TestHarness harness, int[] expect, int[] result) {
        boolean bl = false;
        if (expect.length == result.length) {
            bl = true;
        }
        boolean ok = bl;
        int i = 0;
        while (ok && i < expect.length) {
            if (expect[i] != result[i]) {
                ok = false;
            }
            ++i;
        }
        harness.check(ok);
    }

    public Object copy(Object from, int a, Object to2, int b, int c) {
        try {
            System.arraycopy(from, a, to2, b, c);
        }
        catch (ArrayStoreException xa) {
            return "caught ArrayStoreException";
        }
        catch (IndexOutOfBoundsException xb) {
            return "caught IndexOutOfBoundsException";
        }
        catch (NullPointerException xc) {
            return "caught NullPointerException";
        }
        catch (Throwable xd) {
            return "caught unexpected exception";
        }
        return null;
    }

    public void test(TestHarness harness) {
        harness.setclass("java.lang.System");
        harness.checkPoint("arraycopy(java.lang.Object,int,java.lang.Object,int,int)void");
        int[] x = new int[5];
        int[] y = new int[5];
        this.fill(x);
        harness.check(this.copy(x, 0, y, 0, x.length), null);
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        int[] one = nArray;
        this.check(harness, y, one);
        harness.check(this.copy(x, 1, y, 0, x.length - 1), null);
        harness.check(this.copy(x, 0, y, x.length - 1, 1), null);
        int[] nArray2 = new int[5];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 4;
        int[] two = nArray2;
        this.check(harness, y, two);
        Object[] z = new Object[5];
        harness.check(this.copy(x, 0, z, 0, x.length), (Object)"caught ArrayStoreException");
        harness.check(this.copy(x, 0, y, 0, -23), (Object)"caught IndexOutOfBoundsException");
        harness.check(this.copy(null, 0, y, 0, -23), (Object)"caught NullPointerException");
        harness.check(this.copy(x, 0, null, 0, -23), (Object)"caught NullPointerException");
        String q = "metonymy";
        harness.check(this.copy(q, 0, y, 0, 19), (Object)"caught ArrayStoreException");
        harness.check(this.copy(x, 0, q, 0, 19), (Object)"caught ArrayStoreException");
        double[] v = new double[5];
        harness.check(this.copy(x, 0, v, 0, 5), (Object)"caught ArrayStoreException");
        harness.check(this.copy(x, -1, y, 0, 1), (Object)"caught IndexOutOfBoundsException");
        harness.check(this.copy(x, 0, z, 0, x.length), (Object)"caught ArrayStoreException");
        harness.check(this.copy(x, 0, y, -1, 1), (Object)"caught IndexOutOfBoundsException");
        harness.check(this.copy(x, 3, y, 0, 5), (Object)"caught IndexOutOfBoundsException");
        harness.check(this.copy(x, 0, y, 3, 5), (Object)"caught IndexOutOfBoundsException");
        Object[] w = new Object[5];
        String[] ss = new String[5];
        int i = 0;
        while (i < 5) {
            w[i] = "" + i;
            ss[i] = "" + (i + 23);
            ++i;
        }
        w[3] = new Integer(23);
        harness.check(this.copy(w, 0, ss, 0, 5), (Object)"caught ArrayStoreException");
        harness.check(ss[0], (Object)"0");
        harness.check(ss[1], (Object)"1");
        harness.check(ss[2], (Object)"2");
        harness.check(ss[3], (Object)"26");
        harness.check(ss[4], (Object)"27");
        TestHarness th = harness;
        char[] chararray = new char[]{'a'};
        Vector[] va = new Vector[5];
        List[] l = new List[5];
        ss = new String[5];
        w = new Object[5];
        int i2 = 0;
        while (i2 < 5) {
            va[i2] = new Vector();
            l[i2] = new ArrayList();
            w[i2] = "" + i2;
            ss[i2] = "" + (i2 + 23);
            ++i2;
        }
        try {
            System.arraycopy(null, 0, null, 0, 1);
            harness.fail("where is the NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            th.check(true, "nr 1");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 1, got:" + e);
        }
        try {
            System.arraycopy(l, 0, null, 0, 1);
            harness.fail("where is the NullPointerException -- 2");
        }
        catch (NullPointerException ne) {
            th.check(true, "nr 2");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 2, got:" + e);
        }
        try {
            System.arraycopy(null, 0, l, 0, 1);
            harness.fail("where is the NullPointerException -- 3");
        }
        catch (NullPointerException ne) {
            th.check(true, "nr 3");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 3, got:" + e);
        }
        Object noarray = new Object();
        try {
            System.arraycopy(noarray, 0, l, 0, 1);
            harness.fail("where is the ArrayStoreException -- 4");
        }
        catch (ArrayStoreException ne) {
            th.check(true, "nr 4");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 4, got:" + e);
        }
        try {
            System.arraycopy(l, 0, noarray, 0, 1);
            harness.fail("where is the ArrayStoreException -- 5");
        }
        catch (ArrayStoreException ne) {
            th.check(true, "nr 5");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 5, got:" + e);
        }
        try {
            System.arraycopy(x, 0, chararray, 0, 1);
            harness.fail("where is the ArrayStoreException -- 6");
        }
        catch (ArrayStoreException ne) {
            th.check(true, "nr 6");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 6, got:" + e);
        }
        try {
            System.arraycopy(x, 0, l, 0, 1);
            harness.fail("where is the ArrayStoreException -- 7");
        }
        catch (ArrayStoreException ne) {
            th.check(true, "nr 7");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 7, got:" + e);
        }
        try {
            System.arraycopy(l, 0, x, 0, 1);
            harness.fail("where is the ArrayStoreException -- 8");
        }
        catch (ArrayStoreException ne) {
            th.check(true, "nr 8");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 8, got:" + e);
        }
        try {
            System.arraycopy(l, 0, va, 0, -1);
            harness.fail("where is the IndexOutOfBoundsException -- 9");
        }
        catch (IndexOutOfBoundsException ne) {
            th.check(true, "nr 9");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 9, got:" + e);
        }
        try {
            System.arraycopy(l, 0, va, -1, 1);
            harness.fail("where is the IndexOutOfBoundsException -- 10");
        }
        catch (IndexOutOfBoundsException ne) {
            th.check(true, "nr 10");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 10, got:" + e);
        }
        try {
            System.arraycopy(l, -1, va, 1, 1);
            harness.fail("where is the IndexOutOfBoundsException -- 11");
        }
        catch (IndexOutOfBoundsException ne) {
            th.check(true, "nr 11");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 11, got:" + e);
        }
        try {
            System.arraycopy(l, 1, va, 0, 5);
            harness.fail("where is the IndexOutOfBoundsException -- 12");
        }
        catch (IndexOutOfBoundsException ne) {
            th.check(true, "nr 12");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 12, got:" + e);
        }
        try {
            System.arraycopy(l, 0, va, 1, 5);
            harness.fail("where is the IndexOutOfBoundsException -- 13");
        }
        catch (IndexOutOfBoundsException ne) {
            th.check(true, "nr 13");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 13, got:" + e);
        }
        try {
            System.arraycopy(l, 0, va, 0, 5);
            harness.fail("where is the ArrayStoreException -- 14");
        }
        catch (ArrayStoreException ne) {
            th.check(true, "nr 14");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 14, got:" + e);
        }
        try {
            System.arraycopy(va, 0, l, 0, 5);
            th.check(true, "nr 15");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 15, got:" + e);
        }
        try {
            System.arraycopy(w, 0, ss, 0, 5);
            th.check(true, "nr 16");
            harness.check(ss[0].equals("0"), "checking value -1- 0");
            harness.check(ss[1].equals("1"), "checking value -1- 1");
            harness.check(ss[2].equals("2"), "checking value -1- 2");
            harness.check(ss[3].equals("3"), "checking value -1- 3");
            harness.check(ss[4].equals("4"), "checking value -1- 4");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 16, got:" + e);
        }
        try {
            w[3] = null;
            w[0] = "a";
            w[1] = "b";
            w[2] = "c";
            w[4] = "e";
            System.arraycopy(w, 0, ss, 0, 5);
            th.check(true, "nr 16");
        }
        catch (Exception e) {
            th.fail("got wrong exception -- 16, got:" + e);
        }
        harness.check(ss[0].equals("a"), "checking value -2- 0");
        harness.check(ss[1].equals("b"), "checking value -2- 1");
        harness.check(ss[2].equals("c"), "checking value -2- 2");
        boolean bl = false;
        if (ss[3] == null) {
            bl = true;
        }
        harness.check(bl, "checking value -2- 3");
        harness.check(ss[4].equals("e"), "checking value -2- 4");
    }
}

