/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.StringBuffer;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class SMStringBufferTest
implements Testlet {
    protected static TestHarness th;

    public void test(TestHarness harness) {
        th = harness;
        th.setclass("java.lang.StringBuffer");
        th.checkPoint("setCharAt(int,char)void");
        this.test_setCharAt();
        th.checkPoint("ensureCapacity(int)void");
        this.test_ensureCapacity();
        th.checkPoint("delete(int,int)java.lang.StringBuffer");
        this.test_delete();
        th.checkPoint("deleteCharAt(int)java.lang.StringBuffer");
        this.test_deleteCharAt();
        th.checkPoint("replace(int,int,java.lang.String)java.lang.StringBuffer");
        this.test_replace();
        this.test_substring();
    }

    public void test_delete() {
        StringBuffer sb = new StringBuffer("test delete");
        try {
            sb.delete(-1, 2);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException se) {
            th.check(true);
        }
        try {
            sb.delete(5, 2);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException se) {
            th.check(true);
        }
        try {
            sb.delete(20, 25);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException se) {
            th.check(true);
        }
        boolean bl = false;
        if (sb.delete(1, 1) == sb) {
            bl = true;
        }
        th.check(bl, "sb.delete(1,1) == sb");
        th.check("test delete".equals(new String(sb)), "check if no elements were removed");
        boolean bl2 = false;
        if (sb.length() == 11) {
            bl2 = true;
        }
        th.check(bl2, "size hasn't changed");
        th.check(sb.delete(4, 100).toString().equals("test"), " end may be greater then length");
        boolean bl3 = false;
        if (sb.length() == 4) {
            bl3 = true;
        }
        th.check(bl3, "size should be updated -- 1");
        th.check(sb.delete(0, 4).toString().equals(""), "everything can be deleted");
        boolean bl4 = false;
        if (sb.length() == 0) {
            bl4 = true;
        }
        th.check(bl4, "size should be updated -- 2");
        sb.delete(0, 0);
        sb = new StringBuffer("test delete");
        th.check(sb.delete(2, 3).toString().equals("tet delete"), "testing on delete ... -- 1");
        th.check(sb.delete(3, 5).toString().equals("tetelete"), "testing on delete ... -- 2");
        th.check(sb.delete(3, 4).toString().equals("tetlete"), "testing on delete ... -- 3");
        th.check(sb.delete(1, 6).toString().equals("te"), "testing on delete ... -- 4");
        th.check(sb.delete(1, 6).toString().equals("t"), "testing on delete ... -- 5");
        th.check(sb.delete(0, 1).toString().equals(""), "testing on delete ... -- 6");
    }

    public void test_deleteCharAt() {
        StringBuffer sb = new StringBuffer("test delete");
        try {
            sb.deleteCharAt(-1);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException se) {
            th.check(true);
        }
        try {
            sb.deleteCharAt(20);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException se) {
            th.check(true);
        }
        th.check(sb.deleteCharAt(0).toString().equals("est delete"), "test deleteCharAt");
        th.check(sb.deleteCharAt(3).toString().equals("estdelete"), "test deleteCharAt");
        th.check(sb.deleteCharAt(3).toString().equals("estelete"), "test deleteCharAt");
        th.check(sb.deleteCharAt(1).toString().equals("etelete"), "test deleteCharAt");
        th.check(sb.deleteCharAt(6).toString().equals("etelet"), "test deleteCharAt");
        th.check(sb.deleteCharAt(0).toString().equals("telet"), "test deleteCharAt");
        th.check(sb.deleteCharAt(4).toString().equals("tele"), "test deleteCharAt");
    }

    public void test_replace() {
        StringBuffer sb = new StringBuffer("test replace");
        String s = new String("SmartMove ");
        try {
            sb.replace(1, 3, null);
            th.fail("NullPointerException should be thrown");
        }
        catch (NullPointerException ne) {
            th.check(true);
        }
        try {
            sb.replace(-1, 3, s);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        try {
            sb.replace(4, 3, s);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        try {
            sb.replace(19, 23, s);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        sb.replace(0, 0, s);
        boolean bl = false;
        if (sb.length() == 22) {
            bl = true;
        }
        th.check(bl, "length is " + sb.length() + ", should be 22");
        th.check(sb.toString().equals("SmartMove test replace"), "result is ``" + sb + "'', should be ``SmartMove test replace''");
        sb.replace(0, 35, s);
        th.check(sb.toString().equals("SmartMove "), "result is ``" + sb + "'', should be ``SmartMove''");
        boolean bl2 = false;
        if (sb.length() == 10) {
            bl2 = true;
        }
        th.check(bl2, "length is " + sb.length() + ", should be 10");
        sb = new StringBuffer("test replace");
        sb.replace(1, 11, s);
        th.check(sb.toString().equals("tSmartMove e"), "result is ``" + sb + "'', should be ``tSmartMove e''");
    }

    public void test_substring() {
        th.checkPoint("substring(int)java.lang.String");
        StringBuffer sb = new StringBuffer("test substring");
        try {
            sb.substring(-1);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        try {
            sb.substring(19);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        th.check(sb.substring(0).equals(sb.toString()), "test substring(0)\t1");
        th.check(sb.substring(0).equals("test substring"), "test substring(0)\t2");
        th.check(sb.substring(13).equals("g"), "test substring(length -1) == last char");
        th.check(sb.substring(5).equals("substring"), "test substring(5) ");
        th.checkPoint("substring(int,int)java.lang.String");
        try {
            sb.substring(-1, 1);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        try {
            sb.substring(19, 4);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        try {
            sb.substring(4, 19);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        try {
            sb.substring(5, 3);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        try {
            sb.substring(1, -2);
            th.fail("StringIndexOutOfBoundsException should be thrown");
        }
        catch (StringIndexOutOfBoundsException ne) {
            th.check(true);
        }
        th.check(sb.substring(0, 0).equals(""), "test substring(0,O)\t1");
        th.check(sb.substring(0, 13).equals("test substrin"), "test substring(0)\t2");
        th.check(sb.substring(0, 14).equals("test substring"), "test substring(0, length ) == last char");
        th.check(sb.substring(5, 6).equals("s"), "test substring(5,6) ");
    }

    public void test_ensureCapacity() {
        StringBuffer buf = new StringBuffer("abcdefgh");
        buf.ensureCapacity(-2);
        boolean bl = false;
        if (buf.capacity() == 24) {
            bl = true;
        }
        th.check(bl, "capacity shouldn't change");
        buf.ensureCapacity(20);
        boolean bl2 = false;
        if (buf.capacity() == 24) {
            bl2 = true;
        }
        th.check(bl2, "capacity shouldn't change");
        buf.ensureCapacity(25);
        boolean bl3 = false;
        if (buf.capacity() == 50) {
            bl3 = true;
        }
        th.check(bl3, "capacity should change to max (Cnew,Cold * 2)");
        buf.ensureCapacity(125);
        boolean bl4 = false;
        if (buf.capacity() == 125) {
            bl4 = true;
        }
        th.check(bl4, "capacity should be 125");
    }

    public void test_setCharAt() {
        StringBuffer buf = new StringBuffer("abcdefgh");
        buf.setCharAt(4, 'a');
        boolean bl = false;
        if (buf.charAt(4) == 'a') {
            bl = true;
        }
        th.check(bl, "setCharAt failed");
        int i = 0;
        while (i < 8) {
            buf.setCharAt(i, 'a');
            ++i;
        }
        th.check(buf.toString().equals("aaaaaaaa"), "setCharAt failed");
        i = 0;
        while (i < 8) {
            buf.setCharAt(i, '\u0001');
            ++i;
        }
        th.check(buf.toString().equals("\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001"), "setCharAt failed");
        try {
            buf.setCharAt(-1, 'b');
            th.fail("should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ie) {
            th.check(true);
        }
        try {
            buf.setCharAt(8, 'b');
            th.fail("should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ie) {
            th.check(true);
        }
    }
}

