/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Math;

import gnu.testlet.Mv_Assert;

public class TESTMath
extends Mv_Assert {
    public static final String id = "$Id: TESTMath.java,v 1.93 2002/08/14 11:09:03 vandeneede Exp $";
    private static final double DEVIATION = 1.0E-6;

    protected void runTest() {
        th.setclass("java.lang.Math");
        this.testBasics();
        th.checkPoint("sqrt(double)double");
        this.testSqrt();
        th.checkPoint("pow(double,double)double");
        this.testPow();
        this.testRound();
        this.testAbs();
        this.testExtra();
    }

    public static boolean approx(double value, double expectedValue, double deviation) {
        double test = value;
        if (expectedValue != 0.0) {
            test = (expectedValue - value) / expectedValue;
        }
        test = test < 0.0 ? -test : test;
        return test < deviation;
    }

    protected void setUp() {
    }

    public void testBasics() {
        th.checkPoint("E(public)double");
        TESTMath.assert("Math.E == 2.7182818284590452354", true);
        th.checkPoint("PI(public)double");
        TESTMath.assert("Math.PI == 3.14159265358979323846", true);
    }

    public void testSqrt() {
        TESTMath.assert("Double.isNaN ( Math.sqrt ( Double.NaN))", Double.isNaN(Math.sqrt(Double.NaN)));
        TESTMath.assert("Double.isNaN ( Math.sqrt ( -10.0D))", Double.isNaN(Math.sqrt(-10.0)));
        TESTMath.assert("Double.isInfinite ( Math.sqrt ( Double.POSITIVE_INFINITY)) ==>" + Math.sqrt(Double.POSITIVE_INFINITY), Double.isInfinite(Math.sqrt(Double.POSITIVE_INFINITY)));
        TESTMath.assert("Double.isNaN ( Math.sqrt ( Double.NEGATIVE_INFINITY))", Double.isNaN(Math.sqrt(Double.NEGATIVE_INFINITY)));
        TESTMath.assert("Math.sqrt ( 0.0) == 0.0", Math.sqrt(0.0) == 0.0);
        TESTMath.assert("Math.sqrt ( -0.0) == -0.0", Math.sqrt(-0.0) == -0.0);
        TESTMath.assert("Math.sqrt ( 2.0D)", TESTMath.approx(Math.sqrt(2.0), 1.4142136, 1.0E-6));
    }

    public void testPow() {
        TESTMath.assert("Math.pow ( 456.7689798D, 0.0) == 1.0", Math.pow(456.7689798, 0.0) == 1.0);
        TESTMath.assert("Math.pow ( 682.5464, -0.0) == 1.0", Math.pow(682.5464, -0.0) == 1.0);
        TESTMath.assert("Math.pow ( +Inf, 0.0) == 1.0", Math.pow(Double.POSITIVE_INFINITY, 0.0) == 1.0);
        TESTMath.assert("Math.pow ( -Inf, -0.0) == 1.0", Math.pow(Double.NEGATIVE_INFINITY, -0.0) == 1.0);
        TESTMath.assert("Math.pow( NaN, 0,0) got: " + Math.pow(Double.NaN, 0.0), Math.pow(Double.NaN, 0.0) == 1.0);
        TESTMath.assert("Math.pow ( 123.747, 1.0) == 123.747", TESTMath.approx(Math.pow(123.747, 1.0), 123.747, 1.0E-6));
        TESTMath.assert("Double.isNaN ( Math.pow ( 10.0, Double.NaN))", Double.isNaN(Math.pow(10.0, Double.NaN)));
        TESTMath.assert("Double.isNaN ( Math.pow ( Double.NaN, 89.23))", Double.isNaN(Math.pow(Double.NaN, 89.23)));
        TESTMath.assert("Double.isInfinite ( Math.pow ( 647.585, Double.POSITIVE_INFINITY))", Double.isInfinite(Math.pow(647.585, Double.POSITIVE_INFINITY)));
        TESTMath.assert("Double.isInfinite ( Math.pow ( -647.585, Double.POSITIVE_INFINITY))", Double.isInfinite(Math.pow(-647.585, Double.POSITIVE_INFINITY)));
        TESTMath.assert("Double.isInfinite ( Math.pow ( 0.647, Double.NEGATIVE_INFINITY))", Double.isInfinite(Math.pow(0.647, Double.NEGATIVE_INFINITY)));
        TESTMath.assert("Double.isInfinite ( Math.pow ( -0.647, Double.NEGATIVE_INFINITY))", Double.isInfinite(Math.pow(-0.647, Double.NEGATIVE_INFINITY)));
        TESTMath.assert("Math.pow ( 1.5, Double.NEGATIVE_INFINITY) == 0.0", Math.pow(1.5, Double.NEGATIVE_INFINITY), 0.0);
        TESTMath.assert("Math.pow ( -1.5, Double.NEGATIVE_INFINITY) == 0.0", Math.pow(-1.5, Double.NEGATIVE_INFINITY), 0.0);
        TESTMath.assert("Math.pow ( 0.5, Double.POSITIVE_INFINITY) == 0.0", Math.pow(0.5, Double.POSITIVE_INFINITY), 0.0);
        TESTMath.assert("Math.pow ( -0.5, Double.POSITIVE_INFINITY) == 0.0", Math.pow(-0.5, Double.POSITIVE_INFINITY), 0.0);
        TESTMath.assert("Double.isNaN ( Math.pow ( 1.0, Double.POSITIVE_INFINITY))", Double.isNaN(Math.pow(1.0, Double.POSITIVE_INFINITY)));
        TESTMath.assert("Double.isNaN ( Math.pow ( -1.0, Double.NEGATIVE_INFINITY))", Double.isNaN(Math.pow(-1.0, Double.NEGATIVE_INFINITY)));
        TESTMath.assert("Double.isNaN ( Math.pow ( 1.0, Double.POSITIVE_INFINITY))", Double.isNaN(Math.pow(1.0, Double.POSITIVE_INFINITY)));
        TESTMath.assert("Double.isNaN ( Math.pow ( -1.0, Double.NEGATIVE_INFINITY))", Double.isNaN(Math.pow(-1.0, Double.NEGATIVE_INFINITY)));
        TESTMath.assert("Math.pow ( 0.0, 0.00005) == 0.0", Math.pow(0.0, 5.0E-5) == 0.0);
        TESTMath.assert("Math.pow ( Double.POSITIVE_INFINITY, -0.00005) == 0.0", Math.pow(Double.POSITIVE_INFINITY, -5.0E-5) == 0.0);
        TESTMath.assert("Double.isInfinite ( Math.pow ( 0.0, -0.00005))", Double.isInfinite(Math.pow(0.0, -5.0E-5)));
        TESTMath.assert("Double.isInfinite ( Math.pow ( Double.POSITIVE_INFINITY, 0.00005))", Double.isInfinite(Math.pow(Double.POSITIVE_INFINITY, 5.0E-5)));
        TESTMath.assert("Math.pow ( -0.0, 6.0) == 0.0", Math.pow(-0.0, 6.0) == 0.0);
        TESTMath.assert("Math.pow ( Double.NEGATIVE_INFINITY, -8.0) == 0.0", Math.pow(Double.NEGATIVE_INFINITY, -8.0) == 0.0);
        TESTMath.assert("Math.pow ( -0.0, 5.0) == -0.0", Math.pow(-0.0, 5.0) == -0.0);
        TESTMath.assert("Math.pow ( Double.NEGATIVE_INFINITY, -7.0) == -0.0", Math.pow(Double.NEGATIVE_INFINITY, -7.0) == -0.0);
        TESTMath.assert("Double.isInfinite ( Math.pow ( -0.0, -6.0))", Double.isInfinite(Math.pow(-0.0, -6.0)));
        TESTMath.assert("Double.isInfinite ( Math.pow ( Double.NEGATIVE_INFINITY, 6.0))", Double.isInfinite(Math.pow(Double.NEGATIVE_INFINITY, 6.0)));
        TESTMath.assert("Double.isInfinite ( Math.pow ( -0.0, -7.0))", Double.isInfinite(Math.pow(-0.0, -7.0)));
        TESTMath.assert("Double.isInfinite ( Math.pow ( Double.NEGATIVE_INFINITY, 7.0))", Double.isInfinite(Math.pow(Double.NEGATIVE_INFINITY, 7.0)));
        TESTMath.assert("Math.pow ( -0.00005, 6.0) == Math.pow ( Math.abs ( -0.00005), 6.0)", Math.pow(-5.0E-5, 6.0) == Math.pow(Math.abs(-5.0E-5), 6.0));
        TESTMath.assert("Math.pow ( -0.00005, 3.0) == -Math.pow ( Math.abs ( -0.00005), 3.0)", Math.pow(-5.0E-5, 3.0) == -Math.pow(Math.abs(-5.0E-5), 3.0));
        TESTMath.assert("Double.isNaN ( Math.pow ( -6.0, 464.44678))", Double.isNaN(Math.pow(-6.0, 464.44678)));
    }

    public void testRound() {
        th.checkPoint("round(double)long");
        TESTMath.assert("Math.round ( 3.4D) == 3L", Math.round(3.4) == 3L);
        TESTMath.assert("Math.round ( 9.55D) == 10L", Math.round(9.55) == 10L);
        TESTMath.assert("Math.round ( Double.NaN) == 0L", Math.round(Double.NaN) == 0L);
        double d1 = -9.223372036854776E18;
        TESTMath.assert("Math.round ( Long.MIN_VALUE - 5) == Long.MIN_VALUE", Math.round(d1 -= 5.0) == Long.MIN_VALUE);
        TESTMath.assert("Math.round ( Double.NEGATIVE_INFINITY) == Long.MIN_VALUE", Math.round(Double.NEGATIVE_INFINITY) == Long.MIN_VALUE);
        d1 = 9.223372036854776E18;
        TESTMath.assert("Math.round ( Long.MAX_VALUE + 5) == Long.MAX_VALUE", Math.round(d1 += 5.0) == Long.MAX_VALUE);
        TESTMath.assert("Math.round ( Double.POSITIVE_INFINITY) == Long.MAX_VALUE", Math.round(Double.POSITIVE_INFINITY) == Long.MAX_VALUE);
    }

    public void testAbs() {
        th.checkPoint("abs(double)double");
        TESTMath.assert("Math.abs ( 0.0D) == 0.0D", Math.abs(0.0) == 0.0);
        TESTMath.assert("Math.abs ( -0.0D) == 0.0D", Math.abs(-0.0) == 0.0);
        TESTMath.assert("Double.isInfinite ( Math.abs ( Double.POSITIVE_INFINITY))", Double.isInfinite(Math.abs(Double.POSITIVE_INFINITY)));
        TESTMath.assert("Double.isNaN ( Math.abs ( Double.NaN))", Double.isNaN(Math.abs(Double.NaN)));
        TESTMath.assert("Math.abs ( 10.0D) == 10.0D", Math.abs(10.0) == 10.0);
        TESTMath.assert("Math.abs( -23.0D) == 23.0D", Math.abs(-23.0) == 23.0);
        TESTMath.assert("Math.abs( 1000L ) == 1000", Math.abs(1000L) == 1000L);
        TESTMath.assert("Math.abs ( -2334242L) == 2334242", Math.abs(-2334242L) == 2334242L);
        TESTMath.assert("Math.abs ( Long.MIN_VALUE) == Long.MIN_VALUE", Math.abs(Long.MIN_VALUE) == Long.MIN_VALUE);
        TESTMath.assert("Math.abs ( -23.34D) == 23.34D", Math.abs(-23.34) == 23.34);
    }

    public void testExtra() {
        th.checkPoint("sqrt(double)double");
        for (double d = 0.0; d < 10000.0; d += 123.45) {
            TESTMath.assert(TESTMath.approx(Math.pow(Math.sqrt(d), 2.0), d, 1.0E-6));
        }
    }
}

