/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Cloneable;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CloneableTest
implements Testlet,
Cloneable {
    int a;
    char b;
    Float c;
    protected TestHarness harness;

    public void test_clone() {
        CloneableTest tst = null;
        try {
            tst = (CloneableTest)this.clone();
            this.harness.check(true);
        }
        catch (CloneNotSupportedException e) {
            this.harness.fail("$$java.lang.Cloneable$$Error: CloneNotSupportedException should not be thrown here");
        }
        if (tst == null) {
            this.harness.fail("Error: Clone method on Object did not work properly");
        } else {
            this.harness.check(true);
            if (tst.a != this.a || tst.b != this.b || tst.c.floatValue() != this.c.floatValue()) {
                this.harness.fail("Error: Clone method on Object did not clone data properly");
            } else {
                this.harness.check(true);
            }
        }
        try {
            /*
             * Illegal identifiers - consider using --renameillegalidents true
             */
            class Tstc {
                public Object clone() throws CloneNotSupportedException {
                    return super.clone();
                }

                Tstc() {
                }
            }
            Tstc bln = new Tstc();
            bln.clone();
            this.harness.fail("Error: CloneNotSupportedException should be thrown here");
        }
        catch (CloneNotSupportedException e) {
            this.harness.check(true);
        }
    }

    public void test_array() {
        int[] ia = new int[5];
        int i = 0;
        while (i < ia.length) {
            ia[i] = i;
            ++i;
        }
        int[] o = ia;
        if (!(ia instanceof Cloneable)) {
            this.harness.fail("Error: arrays should implement Cloneable");
        } else {
            this.harness.check(true);
        }
        int[] ib = (int[])ia.clone();
        Class<?> cla = ia.getClass();
        Class<?> clb = ib.getClass();
        if (cla != clb) {
            this.harness.fail("Error: array classes should be equal");
        } else {
            this.harness.check(true);
        }
        i = 0;
        while (i < ia.length) {
            if (ib[i] != ia[i]) {
                this.harness.fail("Error: mismatch on cloned array at " + i);
            } else {
                this.harness.check(true);
            }
            ++i;
        }
    }

    public void testall() {
        this.test_clone();
        this.test_array();
    }

    public void test(TestHarness the_harness) {
        this.harness = the_harness;
        this.testall();
    }

    private final /* synthetic */ void this() {
        this.a = 20;
        this.b = (char)98;
        this.c = new Float(10.0f);
    }

    public CloneableTest() {
        this.this();
    }
}

