/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.jni;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.jni.JNIObjectFunctionAccessTest;

public class JNIPrimitiveFunctionAccessTest
extends JNIObjectFunctionAccessTest
implements Testlet {
    protected void testAVByteFunctions() {
        this.varB = (byte)64;
        harness.checkPoint("CallByteMethod,");
        harness.verbose("entering byteArray, calls getMaximum(byte...)");
        byte[] barray = this.byteArray((byte)-48, (byte)-125, (byte)112);
        harness.check(barray[0], 64);
        harness.check(barray[1], -125);
        harness.check(barray[2], -125);
        harness.checkPoint("CallStaticByteMethod");
        barray = this.staticByteArray((byte)-48, (byte)65, (byte)-126, (byte)112);
        harness.check(barray[0], 65);
        harness.check(barray[1], -126);
        harness.check(barray[2], -126);
        harness.checkPoint("CallStaticByteMethod (2)");
        barray = this.staticByteArray((byte)-32, (byte)33, (byte)-126, (byte)-37);
        harness.check(barray[0], 33);
        harness.check(barray[1], -126);
        harness.check(barray[2], -126);
        harness.checkPoint("CallNonvirtualByteMethod");
        barray = this.nonvirtualByteArray((byte)-48, (byte)-127, (byte)112);
        harness.check(barray[0], -64);
        harness.check(barray[1], 127);
        harness.check(barray[2], 127);
    }

    native byte[] byteArray(byte var1, byte var2, byte var3);

    native byte[] staticByteArray(byte var1, byte var2, byte var3, byte var4);

    native byte[] nonvirtualByteArray(byte var1, byte var2, byte var3);

    protected void testAVByteFunctionsA() {
        this.varB = (byte)64;
        harness.checkPoint("CallByteMethodA,");
        harness.verbose("entering byteArrayA, calls getMaximum(byte...)");
        byte[] barray = this.byteArrayA((byte)-48, (byte)-125, (byte)112);
        harness.check(barray[0], 64);
        harness.check(barray[1], -125);
        harness.check(barray[2], -125);
        harness.checkPoint("CallStaticByteMethodA");
        barray = this.staticByteArrayA((byte)-48, (byte)65, (byte)-126, (byte)112);
        harness.check(barray[0], 65);
        harness.check(barray[1], -126);
        harness.check(barray[2], -126);
        harness.checkPoint("CallStaticByteMethodA (2)");
        barray = this.staticByteArrayA((byte)-32, (byte)33, (byte)-126, (byte)-37);
        harness.check(barray[0], 33);
        harness.check(barray[1], -126);
        harness.check(barray[2], -126);
        harness.checkPoint("CallNonvirtualByteMethodA");
        barray = this.nonvirtualByteArrayA((byte)-48, (byte)-127, (byte)112);
        harness.check(barray[0], -64);
        harness.check(barray[1], 127);
        harness.check(barray[2], 127);
    }

    native byte[] byteArrayA(byte var1, byte var2, byte var3);

    native byte[] staticByteArrayA(byte var1, byte var2, byte var3, byte var4);

    native byte[] nonvirtualByteArrayA(byte var1, byte var2, byte var3);

    protected void testAVByteFunctionsV() {
        this.varB = (byte)64;
        harness.checkPoint("CallByteMethodV");
        byte[] barray = this.byteArrayV((byte)-48, (byte)-125, (byte)112);
        harness.check(barray[0], 64);
        harness.check(barray[1], -125);
        harness.check(barray[2], -125);
        harness.checkPoint("CallStaticByteMethodV");
        barray = this.staticByteArrayV((byte)-48, (byte)65, (byte)-126, (byte)112);
        harness.check(barray[0], 65);
        harness.check(barray[1], -126);
        harness.check(barray[2], -126);
        harness.checkPoint("CallStaticByteMethodV (2)");
        barray = this.staticByteArrayV((byte)-32, (byte)33, (byte)-126, (byte)-37);
        harness.check(barray[0], 33);
        harness.check(barray[1], -126);
        harness.check(barray[2], -126);
        harness.checkPoint("CallNonvirtualByteMethodV");
        barray = this.nonvirtualByteArrayV((byte)-48, (byte)-127, (byte)112);
        harness.check(barray[0], -64);
        harness.check(barray[1], 127);
        harness.check(barray[2], 127);
    }

    native byte[] byteArrayV(byte var1, byte var2, byte var3);

    native byte[] staticByteArrayV(byte var1, byte var2, byte var3, byte var4);

    native byte[] nonvirtualByteArrayV(byte var1, byte var2, byte var3);

    protected void testAVCharFunctions() {
        this.varC = (char)32896;
        harness.checkPoint("sheck CallCharMethod");
        char[] carray = this.charArray('\u6060', '\ufffc', '\ufff0');
        harness.check(carray[0], 32896);
        harness.check(carray[1], 65532);
        harness.check(carray[2], 65532);
        harness.checkPoint("CallStaticCharMethod");
        carray = this.staticCharArray('\u6060', '\u8081', '\ufffc', '\ufff0');
        harness.check(carray[0], 32897);
        harness.check(carray[1], 65532);
        harness.check(carray[2], 65532);
        harness.checkPoint("CallNonvirtualCharMethod");
        carray = this.nonvirtualCharArray('\u6060', '\ufffc', '\ufff0');
        harness.check(carray[0], 32639);
        harness.check(carray[1], 3);
        harness.check(carray[2], 3);
    }

    native char[] charArray(char var1, char var2, char var3);

    native char[] staticCharArray(char var1, char var2, char var3, char var4);

    native char[] nonvirtualCharArray(char var1, char var2, char var3);

    protected void testAVCharFunctionsA() {
        this.varC = (char)32898;
        harness.checkPoint("sheck CallCharMethodA");
        char[] carray = this.charArrayA('\u6060', '\ufffd', '\ufff0');
        harness.check(carray[0], 32898);
        harness.check(carray[1], 65533);
        harness.check(carray[2], 65533);
        harness.checkPoint("CallStaticCharMethodV");
        carray = this.staticCharArrayA('\u6060', '\u8083', '\ufffd', '\ufff0');
        harness.check(carray[0], 32899);
        harness.check(carray[1], 65533);
        harness.check(carray[2], 65533);
        harness.checkPoint("CallNonvirtualCharMethodV");
        carray = this.nonvirtualCharArrayA('\u6060', '\ufffd', '\ufff0');
        harness.check(carray[0], 32637);
        harness.check(carray[1], 2);
        harness.check(carray[2], 2);
    }

    native char[] charArrayA(char var1, char var2, char var3);

    native char[] staticCharArrayA(char var1, char var2, char var3, char var4);

    native char[] nonvirtualCharArrayA(char var1, char var2, char var3);

    protected void testAVCharFunctionsV() {
        this.varC = (char)32900;
        harness.checkPoint("CallCharMethodV");
        char[] carray = this.charArrayA('\u6060', '\ufffe', '\ufff0');
        harness.check(carray[0], 32900);
        harness.check(carray[1], 65534);
        harness.check(carray[2], 65534);
        harness.checkPoint("CallStaticCharMethodV");
        carray = this.staticCharArrayV('\u6060', '\u8085', '\ufffe', '\ufff0');
        harness.check(carray[0], 32901);
        harness.check(carray[1], 65534);
        harness.check(carray[2], 65534);
        harness.checkPoint("CallNonvirtualCharMethodV");
        carray = this.nonvirtualCharArrayV('\u6060', '\ufffe', '\ufff0');
        harness.check(carray[0], 32635);
        harness.check(carray[1], 1);
        harness.check(carray[2], 1);
    }

    native char[] charArrayV(char var1, char var2, char var3);

    native char[] staticCharArrayV(char var1, char var2, char var3, char var4);

    native char[] nonvirtualCharArrayV(char var1, char var2, char var3);

    protected void testAVShortFunctions() {
        this.varS = (short)16448;
        harness.checkPoint("sheck CallShortMethod");
        short[] sarray = this.shortArrayA((short)-12336, (short)-28797, (short)28784);
        harness.check(sarray[0], 16448);
        harness.check(sarray[1], -28797);
        harness.check(sarray[2], -28797);
        harness.checkPoint("CallStaticShortMethod");
        sarray = this.staticShortArrayA((short)-12336, (short)16449, (short)-28798, (short)28784);
        harness.check(sarray[0], 16449);
        harness.check(sarray[1], -28798);
        harness.check(sarray[2], -28798);
        harness.checkPoint("CallNonvirtualShortMethod");
        sarray = this.nonvirtualShortArrayA((short)-12336, (short)-28799, (short)28784);
        harness.check(sarray[0], -16448);
        harness.check(sarray[1], 28799);
        harness.check(sarray[2], 28799);
    }

    native short[] shortArray(short var1, short var2, short var3);

    native short[] staticShortArray(short var1, short var2, short var3, short var4);

    native short[] nonvirtualShortArray(short var1, short var2, short var3);

    protected void testAVShortFunctionsA() {
        this.varS = (short)16448;
        harness.checkPoint("sheck CallShortMethodA");
        short[] sarray = this.shortArrayA((short)-12336, (short)-28797, (short)28784);
        harness.check(sarray[0], 16448);
        harness.check(sarray[1], -28797);
        harness.check(sarray[2], -28797);
        harness.checkPoint("CallStaticShortMethodA");
        sarray = this.staticShortArrayA((short)-12336, (short)16449, (short)-28798, (short)28784);
        harness.check(sarray[0], 16449);
        harness.check(sarray[1], -28798);
        harness.check(sarray[2], -28798);
        harness.checkPoint("CallNonvirtualShortMethodA");
        sarray = this.nonvirtualShortArrayA((short)-12336, (short)-28799, (short)28784);
        harness.check(sarray[0], -16448);
        harness.check(sarray[1], 28799);
        harness.check(sarray[2], 28799);
    }

    native short[] shortArrayA(short var1, short var2, short var3);

    native short[] staticShortArrayA(short var1, short var2, short var3, short var4);

    native short[] nonvirtualShortArrayA(short var1, short var2, short var3);

    protected void testAVShortFunctionsV() {
        this.varS = (short)16448;
        harness.checkPoint("CallShortMethodV");
        harness.verbose("CallShortMethodV");
        short[] sarray = this.shortArrayV((short)-12336, (short)-28797, (short)28784);
        harness.verbose("sarray.length = " + sarray.length);
        harness.verbose("sarray[0] = " + sarray[0]);
        harness.verbose("sarray[1] = " + sarray[1]);
        harness.check(sarray[0], 16448);
        harness.check(sarray[1], -28797);
        harness.check(sarray[2], -28797);
        harness.checkPoint("CallStaticShortMethodV");
        sarray = this.staticShortArrayV((short)-12336, (short)16449, (short)-28798, (short)28784);
        harness.check(sarray[0], 16449);
        harness.check(sarray[1], -28798);
        harness.check(sarray[2], -28798);
        harness.checkPoint("CallNonvirtualShortMethodV");
        sarray = this.nonvirtualShortArrayV((short)-12336, (short)-28799, (short)28784);
        harness.check(sarray[0], -16448);
        harness.check(sarray[1], 28799);
        harness.check(sarray[2], 28799);
    }

    native short[] shortArrayV(short var1, short var2, short var3);

    native short[] staticShortArrayV(short var1, short var2, short var3, short var4);

    native short[] nonvirtualShortArrayV(short var1, short var2, short var3);

    protected void testAVIntFunctions() {
        this.varI = 0x40404040;
        harness.checkPoint("CallIntMethod");
        int[] iarray = this.intArrayA(-808464432, -1886417022, 0x70707070);
        harness.check(iarray[0], 0x40404040);
        harness.check(iarray[1], -1886417022);
        harness.check(iarray[2], -1886417022);
        harness.checkPoint("CallStaticIntMethod");
        iarray = this.staticIntArrayA(-808464432, 0x40404041, -1886417022, 0x70707070);
        harness.check(iarray[0], 0x40404041);
        harness.check(iarray[1], -1886417022);
        harness.check(iarray[2], -1886417022);
        harness.checkPoint("CallNonvirtualIntMethod");
        iarray = this.nonvirtualIntArrayA(-808464432, -1886417022, 0x70707070);
        harness.check(iarray[0], -1077952576);
        harness.check(iarray[1], 0x7070707E);
        harness.check(iarray[2], 0x7070707E);
    }

    native int[] intArray(int var1, int var2, int var3);

    native int[] staticIntArray(int var1, int var2, int var3, int var4);

    native int[] nonvirtualIntArray(int var1, int var2, int var3);

    protected void testAVIntFunctionsA() {
        this.varI = 0x40404040;
        harness.checkPoint("CallIntMethodA");
        int[] iarray = this.intArrayA(-808464432, -1886417022, 0x70707070);
        harness.check(iarray[0], 0x40404040);
        harness.check(iarray[1], -1886417022);
        harness.check(iarray[2], -1886417022);
        harness.checkPoint("CallStaticIntMethodA");
        iarray = this.staticIntArrayA(-808464432, 0x40404041, -1886417022, 0x70707070);
        harness.check(iarray[0], 0x40404041);
        harness.check(iarray[1], -1886417022);
        harness.check(iarray[2], -1886417022);
        harness.checkPoint("CallNonvirtualIntMethodA");
        iarray = this.nonvirtualIntArrayA(-808464432, -1886417022, 0x70707070);
        harness.check(iarray[0], -1077952576);
        harness.check(iarray[1], 0x7070707E);
        harness.check(iarray[2], 0x7070707E);
    }

    native int[] intArrayA(int var1, int var2, int var3);

    native int[] staticIntArrayA(int var1, int var2, int var3, int var4);

    native int[] nonvirtualIntArrayA(int var1, int var2, int var3);

    protected void testAVIntFunctionsV() {
        this.varI = 0x40404040;
        harness.checkPoint("CallIntMethodV");
        int[] iarray = this.intArrayV(-808464432, -1886417022, 0x70707070);
        harness.check(iarray[0], 0x40404040);
        harness.check(iarray[1], -1886417022);
        harness.check(iarray[2], -1886417022);
        harness.checkPoint("CallStaticIntMethodV");
        iarray = this.staticIntArrayV(-808464432, 0x40404041, -1886417022, 0x70707070);
        harness.check(iarray[0], 0x40404041);
        harness.check(iarray[1], -1886417022);
        harness.check(iarray[2], -1886417022);
        harness.checkPoint("CallNonvirtualIntMethodV");
        iarray = this.nonvirtualIntArrayV(-808464432, -1886417022, 0x70707070);
        harness.check(iarray[0], -1077952576);
        harness.check(iarray[1], 0x7070707E);
        harness.check(iarray[2], 0x7070707E);
    }

    native int[] intArrayV(int var1, int var2, int var3);

    native int[] staticIntArrayV(int var1, int var2, int var3, int var4);

    native int[] nonvirtualIntArrayV(int var1, int var2, int var3);

    protected void testAVLongFunctions() {
        this.varJ = 0x4040404040404040L;
        harness.checkPoint("CallLongMethod");
        long[] larray = this.longArrayA(-3472328296227680304L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], 0x4040404040404040L);
        harness.check(larray[1], -8102099357864587386L);
        harness.check(larray[2], -8102099357864587386L);
        harness.checkPoint("CallStaticLongMethod");
        larray = this.staticLongArrayA(-3472328296227680304L, 0x4040404040404041L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], 0x4040404040404041L);
        harness.check(larray[1], -8102099357864587386L);
        harness.check(larray[2], -8102099357864587386L);
        harness.checkPoint("CallNonvirtualLongMethod");
        larray = this.nonvirtualLongArrayA(-3472328296227680304L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], -4629771061636907072L);
        harness.check(larray[1], 0x707070707070707AL);
        harness.check(larray[2], 0x707070707070707AL);
    }

    native long[] longArray(long var1, long var3, long var5);

    native long[] staticLongArray(long var1, long var3, long var5, long var7);

    native long[] nonvirtualLongArray(long var1, long var3, long var5);

    protected void testAVLongFunctionsA() {
        this.varJ = 0x4040404040404040L;
        harness.checkPoint("CallLongMethodA");
        long[] larray = this.longArrayA(-3472328296227680304L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], 0x4040404040404040L);
        harness.check(larray[1], -8102099357864587386L);
        harness.check(larray[2], -8102099357864587386L);
        harness.checkPoint("CallStaticLongMethodA");
        larray = this.staticLongArrayA(-3472328296227680304L, 0x4040404040404041L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], 0x4040404040404041L);
        harness.check(larray[1], -8102099357864587386L);
        harness.check(larray[2], -8102099357864587386L);
        harness.checkPoint("CallNonvirtualLongMethodA");
        larray = this.nonvirtualLongArrayA(-3472328296227680304L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], -4629771061636907072L);
        harness.check(larray[1], 0x707070707070707AL);
        harness.check(larray[2], 0x707070707070707AL);
    }

    native long[] longArrayA(long var1, long var3, long var5);

    native long[] staticLongArrayA(long var1, long var3, long var5, long var7);

    native long[] nonvirtualLongArrayA(long var1, long var3, long var5);

    protected void testAVLongFunctionsV() {
        this.varJ = 0x4040404040404040L;
        harness.checkPoint("CallLongMethodV");
        long[] larray = this.longArrayV(-3472328296227680304L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], 0x4040404040404040L);
        harness.check(larray[1], -8102099357864587386L);
        harness.check(larray[2], -8102099357864587386L);
        harness.checkPoint("CallStaticLongMethodV");
        larray = this.staticLongArrayV(-3472328296227680304L, 0x4040404040404041L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], 0x4040404040404041L);
        harness.check(larray[1], -8102099357864587386L);
        harness.check(larray[2], -8102099357864587386L);
        harness.checkPoint("CallNonvirtualLongMethodV");
        larray = this.nonvirtualLongArrayV(-3472328296227680304L, -8102099357864587386L, 0x7070707070707070L);
        harness.check(larray[0], -4629771061636907072L);
        harness.check(larray[1], 0x707070707070707AL);
        harness.check(larray[2], 0x707070707070707AL);
    }

    native long[] longArrayV(long var1, long var3, long var5);

    native long[] staticLongArrayV(long var1, long var3, long var5, long var7);

    native long[] nonvirtualLongArrayV(long var1, long var3, long var5);

    protected void testAVFloatFunctions() {
        this.varF = 0.75f;
        harness.checkPoint("CallFloatMethod");
        float[] farray = this.floatArrayA(-0.5f, -10.2f, 10.0f);
        harness.check(farray[0], 0.75);
        harness.check(farray[1], -10.2f);
        harness.check(farray[2], -10.2f);
        harness.checkPoint("CallStaticFloatMethod");
        farray = this.staticFloatArrayA(-0.5f, 0.77f, -10.2f, 10.0f);
        harness.check(farray[0], 0.77f);
        harness.check(farray[1], -10.2f);
        harness.check(farray[2], -10.2f);
        harness.checkPoint("CallNonvirtualFloatMethod");
        farray = this.nonvirtualFloatArrayA(-0.5f, -10.2f, 10.0f);
        harness.check(farray[0], -0.75);
        harness.check(farray[1], 10.2f);
        harness.check(farray[2], 10.2f);
    }

    native float[] floatArray(float var1, float var2, float var3);

    native float[] staticFloatArray(float var1, float var2, float var3, float var4);

    native float[] nonvirtualFloatArray(float var1, float var2, float var3);

    protected void testAVFloatFunctionsA() {
        this.varF = 0.75f;
        harness.checkPoint("CallFloatMethodA");
        float[] farray = this.floatArrayA(-0.5f, -10.2f, 10.0f);
        harness.check(farray[0], 0.75);
        harness.check(farray[1], -10.2f);
        harness.check(farray[2], -10.2f);
        harness.checkPoint("CallStaticFloatMethodA");
        farray = this.staticFloatArrayA(-0.5f, 0.77f, -10.2f, 10.0f);
        harness.check(farray[0], 0.77f);
        harness.check(farray[1], -10.2f);
        harness.check(farray[2], -10.2f);
        harness.checkPoint("CallNonvirtualFloatMethodA");
        farray = this.nonvirtualFloatArrayA(-0.5f, -10.2f, 10.0f);
        harness.check(farray[0], -0.75);
        harness.check(farray[1], 10.2f);
        harness.check(farray[2], 10.2f);
    }

    native float[] floatArrayA(float var1, float var2, float var3);

    native float[] staticFloatArrayA(float var1, float var2, float var3, float var4);

    native float[] nonvirtualFloatArrayA(float var1, float var2, float var3);

    protected void testAVFloatFunctionsV() {
        this.varF = 0.75f;
        harness.checkPoint("CallFloatMethodV");
        float[] farray = this.floatArrayV(-0.5f, -10.2f, 10.0f);
        harness.check(farray[0], 0.75);
        harness.check(farray[1], -10.2f);
        harness.check(farray[2], -10.2f);
        harness.checkPoint("CallStaticFloatMethodV");
        farray = this.staticFloatArrayV(-0.5f, 0.77f, -10.2f, 10.0f);
        harness.check(farray[0], 0.77f);
        harness.check(farray[1], -10.2f);
        harness.check(farray[2], -10.2f);
        harness.checkPoint("CallNonvirtualFloatMethodV");
        farray = this.nonvirtualFloatArrayV(-0.5f, -10.2f, 10.0f);
        harness.check(farray[0], -0.75);
        harness.check(farray[1], 10.2f);
        harness.check(farray[2], 10.2f);
    }

    native float[] floatArrayV(float var1, float var2, float var3);

    native float[] staticFloatArrayV(float var1, float var2, float var3, float var4);

    native float[] nonvirtualFloatArrayV(float var1, float var2, float var3);

    protected void testAVDoubleFunctions() {
        this.varD = 0.075;
        harness.checkPoint("CallDoubleMethod");
        double[] darray = this.doubleArrayA(-0.05, -102.2, 100.0);
        harness.check(darray[0], 0.075);
        harness.check(darray[1], -102.2);
        harness.check(darray[2], -102.2);
        harness.checkPoint("CallStaticDoubleMethod");
        darray = this.staticDoubleArrayA(-0.05, 0.077, -102.2, 100.0);
        harness.check(darray[0], 0.077);
        harness.check(darray[1], -102.2);
        harness.check(darray[2], -102.2);
        harness.checkPoint("CallNonvirtualDoubleMethod");
        darray = this.nonvirtualDoubleArrayA(-0.05, -102.2, 100.0);
        harness.check(darray[0], -0.075);
        harness.check(darray[1], 102.2);
        harness.check(darray[2], 102.2);
    }

    native double[] doubleArray(double var1, double var3, double var5);

    native double[] staticDoubleArray(double var1, double var3, double var5, double var7);

    native double[] nonvirtualDoubleArray(double var1, double var3, double var5);

    protected void testAVDoubleFunctionsA() {
        this.varD = 0.075;
        harness.checkPoint("CallDoubleMethodA");
        double[] darray = this.doubleArrayA(-0.05, -102.2, 100.0);
        harness.check(darray[0], 0.075);
        harness.check(darray[1], -102.2);
        harness.check(darray[2], -102.2);
        harness.checkPoint("CallStaticDoubleMethodA");
        darray = this.staticDoubleArrayA(-0.05, 0.077, -102.2, 100.0);
        harness.check(darray[0], 0.077);
        harness.check(darray[1], -102.2);
        harness.check(darray[2], -102.2);
        harness.checkPoint("CallNonvirtualDoubleMethodA");
        darray = this.nonvirtualDoubleArrayA(-0.05, -102.2, 100.0);
        harness.check(darray[0], -0.075);
        harness.check(darray[1], 102.2);
        harness.check(darray[2], 102.2);
    }

    native double[] doubleArrayA(double var1, double var3, double var5);

    native double[] staticDoubleArrayA(double var1, double var3, double var5, double var7);

    native double[] nonvirtualDoubleArrayA(double var1, double var3, double var5);

    protected void testAVDoubleFunctionsV() {
        this.varD = 0.075;
        harness.checkPoint("CallDoubleMethodV");
        double[] darray = this.doubleArrayV(-0.05, -102.2, 100.0);
        harness.check(darray[0], 0.075);
        harness.check(darray[1], -102.2);
        harness.check(darray[2], -102.2);
        harness.checkPoint("CallStaticDoubleMethodV");
        darray = this.staticDoubleArrayV(-0.05, 0.077, -102.2, 100.0);
        harness.check(darray[0], 0.077);
        harness.check(darray[1], -102.2);
        harness.check(darray[2], -102.2);
        harness.checkPoint("CallNonvirtualDoubleMethodV");
        darray = this.nonvirtualDoubleArrayV(-0.05, -102.2, 100.0);
        harness.check(darray[0], -0.075);
        harness.check(darray[1], 102.2);
        harness.check(darray[2], 102.2);
    }

    native double[] doubleArrayV(double var1, double var3, double var5);

    native double[] staticDoubleArrayV(double var1, double var3, double var5, double var7);

    native double[] nonvirtualDoubleArrayV(double var1, double var3, double var5);

    protected void testAVBooleanFunctions() {
        this.varZ = false;
        harness.checkPoint("CallBooleanMethod");
        boolean[] zarray = this.booleanArray(true, false, true);
        harness.check(zarray[0]);
        harness.check(zarray[1]);
        harness.check(zarray[2] ^ true);
        harness.checkPoint("CallStaticBooleanMethod");
        zarray = this.staticBooleanArray(true, false, false, true);
        harness.check(zarray[0]);
        harness.check(zarray[1]);
        harness.check(zarray[2] ^ true);
        harness.checkPoint("CallNonvirtualBooleanMethod");
        zarray = this.nonvirtualBooleanArray(true, false, true);
        harness.check(zarray[0] ^ true);
        harness.check(zarray[1] ^ true);
        harness.check(zarray[2]);
    }

    native boolean[] booleanArray(boolean var1, boolean var2, boolean var3);

    native boolean[] staticBooleanArray(boolean var1, boolean var2, boolean var3, boolean var4);

    native boolean[] nonvirtualBooleanArray(boolean var1, boolean var2, boolean var3);

    protected void testAVBooleanFunctionsA() {
        this.varZ = false;
        harness.checkPoint("CallBooleanMethodA");
        boolean[] zarray = this.booleanArrayA(true, false, true);
        harness.check(zarray[0]);
        harness.check(zarray[1]);
        harness.check(zarray[2] ^ true);
        harness.checkPoint("CallStaticBooleanMethodA");
        zarray = this.staticBooleanArrayA(true, false, false, true);
        harness.check(zarray[0]);
        harness.check(zarray[1]);
        harness.check(zarray[2] ^ true);
        harness.checkPoint("CallNonvirtualBooleanMethodA");
        zarray = this.nonvirtualBooleanArrayA(true, false, true);
        harness.check(zarray[0] ^ true);
        harness.check(zarray[1] ^ true);
        harness.check(zarray[2]);
    }

    native boolean[] booleanArrayA(boolean var1, boolean var2, boolean var3);

    native boolean[] staticBooleanArrayA(boolean var1, boolean var2, boolean var3, boolean var4);

    native boolean[] nonvirtualBooleanArrayA(boolean var1, boolean var2, boolean var3);

    protected void testAVBooleanFunctionsV() {
        this.varZ = false;
        harness.checkPoint("CallBooleanMethodV");
        boolean[] zarray = this.booleanArrayV(true, false, true);
        harness.check(zarray[0]);
        harness.check(zarray[1]);
        harness.check(zarray[2] ^ true);
        harness.checkPoint("CallStaticBooleanMethodV");
        zarray = this.staticBooleanArrayV(true, false, false, true);
        harness.check(zarray[0]);
        harness.check(zarray[1]);
        harness.check(zarray[2] ^ true);
        harness.checkPoint("CallNonvirtualBooleanMethodV");
        zarray = this.nonvirtualBooleanArrayV(true, false, true);
        harness.check(zarray[0] ^ true);
        harness.check(zarray[1] ^ true);
        harness.check(zarray[2]);
    }

    native boolean[] booleanArrayV(boolean var1, boolean var2, boolean var3);

    native boolean[] staticBooleanArrayV(boolean var1, boolean var2, boolean var3, boolean var4);

    native boolean[] nonvirtualBooleanArrayV(boolean var1, boolean var2, boolean var3);

    public byte getMaximum(byte x1) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varB, x1);
    }

    public char getMaximum(char x1) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varC, x1);
    }

    public short getMaximum(short x1) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varS, x1);
    }

    public int getMaximum(int x1) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varI, x1);
    }

    public long getMaximum(long x1) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varJ, x1);
    }

    public float getMaximum(float x1) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varF, x1);
    }

    public double getMaximum(double x1) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varD, x1);
    }

    public byte getMaximum(byte x1, byte x2) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varB, x1, x2);
    }

    public char getMaximum(char x1, char x2) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varC, x1, x2);
    }

    public short getMaximum(short x1, short x2) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varS, x1, x2);
    }

    public int getMaximum(int x1, int x2) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varI, x1, x2);
    }

    public long getMaximum(long x1, long x2) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varJ, x1, x2);
    }

    public float getMaximum(float x1, float x2) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varF, x1, x2);
    }

    public double getMaximum(double x1, double x2) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varD, x1, x2);
    }

    public byte getMaximum(byte x1, byte x2, byte x3) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varB, x1, x2, x3);
    }

    public char getMaximum(char x1, char x2, char x3) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varC, x1, x2, x3);
    }

    public short getMaximum(short x1, short x2, short x3) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varS, x1, x2, x3);
    }

    public int getMaximum(int x1, int x2, int x3) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varI, x1, x2, x3);
    }

    public long getMaximum(long x1, long x2, long x3) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varJ, x1, x2, x3);
    }

    public float getMaximum(float x1, float x2, float x3) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varF, x1, x2, x3);
    }

    public double getMaximum(double x1, double x2, double x3) {
        return JNIPrimitiveFunctionAccessTest.absmax(this.varD, x1, x2, x3);
    }

    public boolean countBinary(boolean x1) {
        return JNIPrimitiveFunctionAccessTest.binary(this.varZ, x1);
    }

    public boolean countBinary(boolean x1, boolean x2) {
        return JNIPrimitiveFunctionAccessTest.binary(this.varZ, x1, x2);
    }

    public boolean countBinary(boolean x1, boolean x2, boolean x3) {
        return JNIPrimitiveFunctionAccessTest.binary(this.varZ, x1, x2, x3);
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("JNI class and array construction/ class dependencies");
        harness.verbose("byte function access normal");
        this.testAVByteFunctions();
        harness.verbose("byte function access -a");
        this.testAVByteFunctionsA();
        harness.verbose("byte function access -v");
        this.testAVByteFunctionsV();
        harness.verbose("char  function access normal");
        this.testAVCharFunctions();
        harness.verbose("char  function access -a");
        this.testAVCharFunctionsA();
        harness.verbose("char  function access -v");
        this.testAVCharFunctionsV();
        harness.verbose("short  function access normal");
        this.testAVShortFunctions();
        harness.verbose("short  function access -a");
        this.testAVShortFunctionsA();
        harness.verbose("short  function access -v");
        this.testAVShortFunctionsV();
        harness.verbose("int  function access normal");
        this.testAVIntFunctions();
        harness.verbose("int  function access -a");
        this.testAVIntFunctionsA();
        harness.verbose("int  function access -v");
        this.testAVIntFunctionsV();
        harness.verbose("long  function access normal");
        this.testAVLongFunctions();
        harness.verbose("long  function access -a");
        this.testAVLongFunctionsA();
        harness.verbose("long  function access -v");
        this.testAVLongFunctionsV();
        harness.verbose("float  function access normal");
        this.testAVFloatFunctions();
        harness.verbose("float  function access -a");
        this.testAVFloatFunctionsA();
        harness.verbose("float  function access -v");
        this.testAVFloatFunctionsV();
        harness.verbose("double  function access normal");
        this.testAVDoubleFunctions();
        harness.verbose("double  function access -a");
        this.testAVDoubleFunctionsA();
        harness.verbose("double  function access -v");
        this.testAVDoubleFunctionsV();
        harness.verbose("Boolean function access normal");
        this.testAVBooleanFunctions();
        harness.verbose("Boolean function access -a");
        this.testAVBooleanFunctionsA();
        harness.verbose("Boolean function access -v");
        this.testAVBooleanFunctionsV();
    }

    static {
        System.loadLibrary("JNIPrimitiveFunctionAccessTest");
    }
}

