/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.jni;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.jni.ContainerFunctions;
import gnu.testlet.wonka.jni.SimpleContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JNIMemberAccessTest
extends ContainerFunctions
implements Testlet {
    protected static TestHarness harness;
    int ourInt;
    String ourString;
    boolean[] ourArray;
    SimpleContainer ourSimpleContainer;

    private final void testMemberVariableAccess() {
        harness.checkPoint("Direct access member <primitive int> via native calls");
        this.ourInt = 1300;
        harness.check(this.getMemberInteger(), this.ourInt);
        this.setMemberInteger(1301);
        harness.check(this.ourInt, 1301);
        harness.checkPoint("Direct access member <String> via native calls");
        this.ourString = "Leopold I";
        harness.check(this.getMemberString(), (Object)this.ourString);
        this.setMemberString("Leopold II");
        harness.check(this.ourString, (Object)"Leopold II");
        harness.checkPoint("Direct access member <array> via native calls");
        this.ourArray = this.buildBoolArray(true, true, false);
        boolean[] testarray = this.getMemberArray();
        this.checkBoolArray(testarray, this.ourArray, harness);
        testarray = this.buildBoolArray(true, false, true);
        this.setMemberArray(testarray);
        this.checkBoolArray(this.ourArray, testarray, harness);
        harness.checkPoint("Direct access member <class SimpleContainer> via native calls");
        this.ourSimpleContainer = this.buildSimpleContainer(500, "alfred", this.buildBoolArray(true, false, false));
        SimpleContainer testcontainer = this.getMemberSimpleContainer();
        this.compareSimpleContainer(testcontainer, this.ourSimpleContainer, harness);
        testcontainer = this.buildSimpleContainer(501, "Berthold", this.buildBoolArray(false, true, true));
        this.setMemberSimpleContainer(testcontainer);
        this.compareSimpleContainer(this.ourSimpleContainer, testcontainer, harness);
    }

    private final native int getMemberInteger();

    private final native void setMemberInteger(int var1);

    private final native String getMemberString();

    private final native void setMemberString(String var1);

    private final native boolean[] getMemberArray();

    private final native void setMemberArray(boolean[] var1);

    private final native SimpleContainer getMemberSimpleContainer();

    private final native void setMemberSimpleContainer(SimpleContainer var1);

    private final void testMemberFunctionAccess() {
        harness.checkPoint("Direct access function <primitive int> via native calls");
        this.ourInt = 1302;
        harness.check(this.getInverseInteger(), -1302);
        this.setInverseInteger(1303);
        harness.check(this.ourInt, -1303);
        harness.checkPoint("Direct access function <String> via native calls");
        String teststring = "Albert I";
        String inversestring = JNIMemberAccessTest.inverse(teststring);
        this.ourString = teststring;
        harness.check(this.getInverseString(), (Object)inversestring);
        teststring = "Leopold III";
        inversestring = JNIMemberAccessTest.inverse(teststring);
        this.setInverseString(teststring);
        harness.check(this.ourString, (Object)inversestring);
        harness.checkPoint("Direct access function <array> via native calls");
        boolean[] testarray = this.buildBoolArray(false, true, false);
        boolean[] inversearray = JNIMemberAccessTest.inverse(testarray);
        this.ourArray = testarray;
        this.checkBoolArray(this.getInverseArray(), inversearray, harness);
        testarray = this.buildBoolArray(false, false, true);
        inversearray = JNIMemberAccessTest.inverse(testarray);
        this.setInverseArray(testarray);
        this.checkBoolArray(this.ourArray, inversearray, harness);
        harness.checkPoint("Direct access function <class SimpleContainer> via native calls");
        SimpleContainer testcontainer = this.buildSimpleContainer(502, "Clara", this.buildBoolArray(false, false, false));
        SimpleContainer inversecontainer = JNIMemberAccessTest.inverse(testcontainer);
        this.ourSimpleContainer = testcontainer;
        testcontainer = this.getInverseSimpleContainer();
        this.compareSimpleContainer(testcontainer, inversecontainer, harness);
        testcontainer = this.buildSimpleContainer(503, "Dieter", this.buildBoolArray(true, true, true));
        inversecontainer = JNIMemberAccessTest.inverse(testcontainer);
        this.setInverseSimpleContainer(testcontainer);
        this.compareSimpleContainer(this.ourSimpleContainer, inversecontainer, harness);
    }

    private final native int getInverseInteger();

    private final native void setInverseInteger(int var1);

    private final native String getInverseString();

    private final native void setInverseString(String var1);

    private final native boolean[] getInverseArray();

    private final native void setInverseArray(boolean[] var1);

    private final native SimpleContainer getInverseSimpleContainer();

    private final native void setInverseSimpleContainer(SimpleContainer var1);

    private final int getIntegerInverse() {
        return JNIMemberAccessTest.inverse(this.ourInt);
    }

    private final void setIntegerInverse(int i) {
        this.ourInt = JNIMemberAccessTest.inverse(i);
    }

    private final String getStringInverse() {
        return JNIMemberAccessTest.inverse(this.ourString);
    }

    private final void setStringInverse(String s) {
        this.ourString = JNIMemberAccessTest.inverse(s);
    }

    private final boolean[] getArrayInverse() {
        return JNIMemberAccessTest.inverse(this.ourArray);
    }

    private final void setArrayInverse(boolean[] bx) {
        this.ourArray = JNIMemberAccessTest.inverse(bx);
    }

    private final SimpleContainer getContainerInverse() {
        return JNIMemberAccessTest.inverse(this.ourSimpleContainer);
    }

    private final void setContainerInverse(SimpleContainer c) {
        this.ourSimpleContainer = JNIMemberAccessTest.inverse(c);
    }

    private final void testStaticFunctionAccess() {
        harness.checkPoint("Direct static function on <primitive int> via native calls");
        int testint = 1304;
        harness.check(this.getInverse(testint), JNIMemberAccessTest.inverse(testint));
        harness.checkPoint("Direct static function on <String> via native calls");
        String teststring = "Boudewijn I";
        harness.check(this.getInverse(teststring), (Object)JNIMemberAccessTest.inverse(teststring));
        harness.checkPoint("Direct static function on <array> via native calls");
        boolean[] testarray = this.buildBoolArray(true, true, false);
        this.checkBoolArray(this.getInverse(testarray), JNIMemberAccessTest.inverse(testarray), harness);
        harness.checkPoint("Direct static function on <class SimpleContainer> via native calls");
        SimpleContainer testcontainer = this.buildSimpleContainer(504, "Emil", this.buildBoolArray(true, false, true));
        this.compareSimpleContainer(this.getInverse(testcontainer), JNIMemberAccessTest.inverse(testcontainer), harness);
    }

    private final native int getInverse(int var1);

    private final native String getInverse(String var1);

    private final native boolean[] getInverse(boolean[] var1);

    private final native SimpleContainer getInverse(SimpleContainer var1);

    static int inverse(int i) {
        return -i;
    }

    static String inverse(String s) {
        return s.substring(1) + s.substring(0, 1);
    }

    static boolean[] inverse(boolean[] bx) {
        boolean[] bi = new boolean[]{bx[0] ^ true, bx[1] ^ true, bx[2] ^ true};
        return bi;
    }

    static SimpleContainer inverse(SimpleContainer c) {
        SimpleContainer ci = new SimpleContainer();
        ci.number = JNIMemberAccessTest.inverse(c.number);
        ci.name = JNIMemberAccessTest.inverse(c.name);
        ci.preferences = JNIMemberAccessTest.inverse(c.preferences);
        return ci;
    }

    private final void testSuperclassAccess() {
        byte baseversion = this.getBaseVersion();
        byte currentversion = this.getCurrentVersion();
        boolean bl = false;
        if (currentversion == this.getVersion()) {
            bl = true;
        }
        harness.check(bl, "Derived function returns " + currentversion + " instead of expected " + this.getVersion());
        boolean bl2 = false;
        if (baseversion != this.getVersion()) {
            bl2 = true;
        }
        harness.check(bl2, "Base function call returns derived functin output " + this.getVersion());
        boolean bl3 = false;
        if (baseversion == super.getVersion()) {
            bl3 = true;
        }
        harness.check(bl3, "Base function call returns " + baseversion + " instead of expected" + super.getVersion());
    }

    private final native byte getBaseVersion();

    private final native byte getCurrentVersion();

    protected byte getVersion() {
        return 2;
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("JNI member & function access");
        SimpleContainer.common = -1492;
        this.testMemberVariableAccess();
        this.testMemberFunctionAccess();
        this.testStaticFunctionAccess();
        this.testSuperclassAccess();
    }

    private final /* synthetic */ void this() {
        this.ourArray = new boolean[3];
        this.ourSimpleContainer = new SimpleContainer();
    }

    public JNIMemberAccessTest() {
        this.this();
    }

    static {
        System.loadLibrary("JNIMemberAccessTest");
    }
}

