/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.jni;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.jni.ConstructionContainer;
import gnu.testlet.wonka.jni.ContainerException;
import gnu.testlet.wonka.jni.ContainerFunctions;
import gnu.testlet.wonka.jni.FunctionContainer;
import gnu.testlet.wonka.jni.SimpleContainer;

public class JNIClassConstructionTest
extends ContainerFunctions
implements Testlet {
    protected static TestHarness harness;

    private final void testClassBuildingDefault() {
        SimpleContainer simplereference = this.buildSimpleContainer(1500, "zero", false, false, true, 1499);
        FunctionContainer functionreference = this.buildFunctionContainer(1501, "one", false, true, false, 1502, "two", false, true, true);
        harness.checkPoint("build default Containers using NewObject(void)");
        this.compareSimpleContainer(this.newDefaultSimpleContainer(), new SimpleContainer(), harness);
        this.compareFunctionContainer(this.newDefaultFunctionContainer(), new FunctionContainer(), harness);
        this.compareSimpleContainer(this.newClonedSimpleContainer(simplereference), new SimpleContainer(), harness);
        this.compareFunctionContainer(this.newClonedFunctionContainer(functionreference), new FunctionContainer(), harness);
    }

    private final native SimpleContainer newDefaultSimpleContainer();

    private final native FunctionContainer newDefaultFunctionContainer();

    private final native SimpleContainer newClonedSimpleContainer(SimpleContainer var1);

    private final native FunctionContainer newClonedFunctionContainer(FunctionContainer var1);

    private final void testClassBuildingConstructors() {
        harness.checkPoint("build ConstructionContainer using NewObject constructor");
        ConstructionContainer testcon = this.newConstructedContainer(1510, "ten", false, false, false);
        this.compareConstructionContainer(testcon, 1510, "ten", false, false, false, harness);
        testcon = this.newConstructedContainer(1511, "eleven", this.buildBoolArray(false, false, true));
        this.compareConstructionContainer(testcon, 1511, "eleven", false, false, true, harness);
        testcon = this.newConstructedContainer(this.buildSimpleContainer(1512, "twelve", false, true, false));
        this.compareConstructionContainer(testcon, 1512, "twelve", false, true, false, harness);
        harness.checkPoint("build ConstructionContainer using AllocObject and constructor");
        testcon = this.newAllocatedContainer(1513, "thirteen", false, true, true);
        this.compareConstructionContainer(testcon, 1513, "thirteen", false, true, true, harness);
        testcon = this.newAllocatedContainer(1514, "fourteen", this.buildBoolArray(true, false, false));
        this.compareConstructionContainer(testcon, 1514, "fourteen", true, false, false, harness);
        testcon = this.newAllocatedContainer(this.buildSimpleContainer(1515, "fifteen", true, false, true));
        this.compareConstructionContainer(testcon, 1515, "fifteen", true, false, true, harness);
        harness.checkPoint("build ConstructionContainer using NewObject(default) constructor and function calls");
        testcon = this.newInitialisedContainer(1516, "sixteen", true, true, false);
        this.compareConstructionContainer(testcon, 1516, "sixteen", true, true, false, harness);
        testcon = this.newInitialisedContainer(1517, "seventeen", this.buildBoolArray(true, true, true));
        this.compareConstructionContainer(testcon, 1517, "seventeen", true, true, true, harness);
        testcon = this.newInitialisedContainer(this.buildSimpleContainer(1518, "eightteen", false, false, false));
        this.compareConstructionContainer(testcon, 1518, "eightteen", false, false, false, harness);
    }

    private final native ConstructionContainer newConstructedContainer(int var1, String var2, boolean var3, boolean var4, boolean var5);

    private final native ConstructionContainer newConstructedContainer(int var1, String var2, boolean[] var3);

    private final native ConstructionContainer newConstructedContainer(SimpleContainer var1);

    private final native ConstructionContainer newAllocatedContainer(int var1, String var2, boolean var3, boolean var4, boolean var5);

    private final native ConstructionContainer newAllocatedContainer(int var1, String var2, boolean[] var3);

    private final native ConstructionContainer newAllocatedContainer(SimpleContainer var1);

    private final native ConstructionContainer newInitialisedContainer(int var1, String var2, boolean var3, boolean var4, boolean var5);

    private final native ConstructionContainer newInitialisedContainer(int var1, String var2, boolean[] var3);

    private final native ConstructionContainer newInitialisedContainer(SimpleContainer var1);

    private final void testClassArrayBuilding() {
        int testsize = 3;
        harness.checkPoint("using NewObjectArray to construct an array of copies from a template");
        ConstructionContainer testconstructed = this.buildConstructionContainer(1520, "twenty", false, false, true);
        ConstructionContainer[] arrayconstructed = this.buildStaticArray(testconstructed, testsize);
        int i = 0;
        while (i < testsize) {
            this.compareConstructionContainer(arrayconstructed[i], testconstructed, harness);
            ++i;
        }
        harness.checkPoint("using NewObjectArray to construct an array of a constructor-built class member");
        testconstructed = this.buildConstructionContainer(1521, "twenty-one", false, true, false);
        arrayconstructed = this.buildStaticArray(1521, "twenty-one", false, true, false, testsize);
        i = 0;
        while (i < testsize) {
            this.compareConstructionContainer(arrayconstructed[i], testconstructed, harness);
            ++i;
        }
        harness.checkPoint("NewObjectArray(template) and SetObjectArrayElement constructs an incrementing array");
        testconstructed = this.buildConstructionContainer(1522, "twenty-two", false, true, true);
        int containernumber = 1522;
        arrayconstructed = this.buildIncrementalArray(testconstructed, containernumber, testsize);
        i = 0;
        while (i < testsize) {
            this.compareConstructionContainer(arrayconstructed[i], ++containernumber, "twenty-two", false, true, true, harness);
            ++i;
        }
        harness.checkPoint("NewObjectArray(AllocObject) and SetObjectArrayElement constructs an incrementing array");
        containernumber = 1523;
        arrayconstructed = this.buildIncrementalArray(containernumber, "twenty-three", true, false, true, testsize);
        i = 0;
        while (i < testsize) {
            this.compareConstructionContainer(arrayconstructed[i], ++containernumber, "twenty-three", true, false, true, harness);
            ++i;
        }
    }

    private final native ConstructionContainer[] buildStaticArray(ConstructionContainer var1, int var2);

    private final native ConstructionContainer[] buildStaticArray(int var1, String var2, boolean var3, boolean var4, boolean var5, int var6);

    private final native ConstructionContainer[] buildIncrementalArray(ConstructionContainer var1, int var2, int var3);

    private final native ConstructionContainer[] buildIncrementalArray(int var1, String var2, boolean var3, boolean var4, boolean var5, int var6);

    private final void testClassExceptionBuilding() {
        harness.checkPoint("JNI call throwing a NullPointerException");
        try {
            this.throwsNullPointerException("null pointer exception thrown");
            harness.check(false, "no Exception thrown");
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                String errormsg = e.getMessage();
                if (errormsg.indexOf("null pointer exception thrown") >= 0) {
                    harness.check(true, "null pointer exception thrown");
                } else {
                    harness.fail("NullPointrException returned <" + errormsg + "> instead of desired message <null pointer exception thrown>");
                }
            }
            harness.check(false, "error not of type NullPointerException");
        }
        harness.checkPoint("JNI call throwing a ContainerException (built through constructor)");
        try {
            this.throwsConstructedContainerException(1540, "fourty", this.buildBoolArray(true, true, false), this.buildSimpleContainer(1541, "fourty-one", true, false, true));
            harness.check(false, "no Exception thrown");
        }
        catch (Exception e) {
            if (e instanceof ContainerException) {
                System.out.println("=> ce = (ContainerException)e");
                ContainerException ce = (ContainerException)e;
                System.out.println("=> fc = ce.getFunctionContainer()");
                FunctionContainer fc = ce.getFunctionContainer();
                System.out.println("=> comparing FunctionContainer()");
                this.compareFunctionContainer(fc, 1540, "fourty", true, true, false, 1541, "fourty-one", true, false, true, harness);
            }
            harness.check(false, "error not of type ContainerException");
        }
    }

    private final native void throwsNullPointerException(String var1) throws NullPointerException;

    private final native void throwsConstructedContainerException(int var1, String var2, boolean[] var3, SimpleContainer var4) throws ContainerException;

    private final void testClassExceptionHandling() {
        harness.checkPoint("JNI handling a java function that throws a ContainerException");
        FunctionContainer fc = this.handlesException();
        if (fc != null) {
            this.compareFunctionContainer(fc, 1550, "fifty", false, false, true, 1551, "fifty-one", false, true, false, harness);
        } else {
            harness.fail("Unable to catch ContainerException");
        }
    }

    private final native FunctionContainer handlesException();

    void throwsError() throws ContainerException {
        FunctionContainer fc = this.buildFunctionContainer(1550, "fifty", false, false, true, 1551, "fifty-one", false, true, false);
        throw new ContainerException(fc);
    }

    private final void testClassDependencies() {
        SimpleContainer sc1;
        harness.checkPoint("testing <IsAssignableForm()> JNI function");
        harness.check(this.testAssignable("gnu/testlet/wonka/jni/JNIClassConstructionTest", "gnu/testlet/wonka/jni/JNIClassConstructionTest"), "assignable to itself");
        harness.check(this.testAssignable("gnu/testlet/wonka/jni/JNIClassConstructionTest", "gnu/testlet/wonka/jni/ContainerFunctions"), "assignable to extends base class");
        harness.check(this.testAssignable("gnu/testlet/wonka/jni/JNIClassConstructionTest", "gnu/testlet/Testlet"), "assignable to implements class");
        harness.check(this.testAssignable("gnu/testlet/wonka/jni/JNIClassConstructionTest", "gnu/testlet/TestHarness") ^ true, "not assignable to complete stranger");
        harness.checkPoint("testing <IsInstanceOf()> JNI function");
        ContainerException ex = new ContainerException("error detecting instance");
        harness.check(this.testInstanceOf(ex, "gnu/testlet/wonka/jni/ContainerException"), "instance of its own class");
        harness.check(this.testInstanceOf(ex, "java/lang/Exception"), "instance of its base class");
        harness.check(this.testInstanceOf(null, "gnu/testlet/wonka/jni/ContainerException"), "null should be instance of all classes");
        harness.check(this.testInstanceOf(ex, "gnu/testlet/wonka/jni/SimpleContainer") ^ true, "instance of other class");
        SimpleContainer sc2 = sc1 = this.buildSimpleContainer(1611, "jikes", true, true, true);
        harness.checkPoint("testing <IsSameObject()>' JNI function");
        harness.check(this.testSame(sc1, sc1), "IsSameObject with itself");
        harness.check(this.testSame(sc1, sc2), "IsSameObject with equal name of itself");
        harness.check(this.testSame(sc1, this.buildSimpleContainer(1612, "kaboom", false, false, false)) ^ true, "IsSameObject new constructed (should fail)");
        harness.check(this.testSame(sc1, this.buildSimpleContainer(1611, "jikes", true, true, true)) ^ true, "IsSameObject with new constructed of same value (should fail)");
        harness.check(this.testSame(sc1, null) ^ true, "IsSameObject with null (should fail)");
        harness.check(this.testSame(null, sc1) ^ true, "IsSameObject with null (should fail)");
        harness.check(this.testSame(null, null), "null IsSameObject with null (should be true)");
    }

    private final native boolean testAssignable(String var1, String var2);

    private final native boolean testInstanceOf(ContainerException var1, String var2);

    private final native boolean testSame(SimpleContainer var1, SimpleContainer var2);

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("JNI class and array construction/ class dependencies");
        harness.verbose("Start tests dependencies");
        this.testClassDependencies();
        harness.verbose("Start tests building");
        this.testClassBuildingDefault();
        this.testClassBuildingConstructors();
        harness.verbose("Start tests array building");
        this.testClassArrayBuilding();
        harness.verbose("Start tests exception throwing");
        this.testClassExceptionBuilding();
        harness.verbose("Start tests exception catching and dispatching");
        this.testClassExceptionHandling();
    }

    static {
        System.loadLibrary("JNIClassConstructionTest");
    }
}

