/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.Serialization;

import gnu.testlet.Mv_Assert;
import gnu.testlet.wonka.io.Serialization.Assert;
import gnu.testlet.wonka.io.Serialization.ClassSubclass;
import gnu.testlet.wonka.io.Serialization.READ_File;
import gnu.testlet.wonka.io.Serialization.SAMPLE_SimpleOuterClass;
import gnu.testlet.wonka.io.Serialization.SM_ClassArray;
import gnu.testlet.wonka.io.Serialization.SM_ClassString;
import gnu.testlet.wonka.io.Serialization.SM_ClassUnderscore;
import gnu.testlet.wonka.io.Serialization.SM_Simple;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Vector;

public class SMObjectOutputStreamTest
extends Mv_Assert {
    private ByteArrayOutputStream baos;
    private ObjectOutputStream oos;

    public void setUp() {
    }

    private void setUpFile() {
        this.baos = new ByteArrayOutputStream();
        try {
            this.oos = new ObjectOutputStream(this.baos);
        }
        catch (Exception e) {
            th.debug("got Exception during Setup");
        }
    }

    private String toHex(int hexNumber) {
        if (hexNumber == 10) {
            return "A";
        }
        if (hexNumber == 11) {
            return "B";
        }
        if (hexNumber == 12) {
            return "C";
        }
        if (hexNumber == 13) {
            return "D";
        }
        if (hexNumber == 14) {
            return "E";
        }
        if (hexNumber == 15) {
            return "F";
        }
        if (hexNumber < 10) {
            return "" + hexNumber;
        }
        return "X";
    }

    private String toHex(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        int part1 = i / 16;
        int part2 = i % 16;
        return this.toHex(part1) + this.toHex(part2);
    }

    private void printHex(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            System.out.print(this.toHex(bytes[i]) + " ");
        }
    }

    private void printComparison(byte[] one, byte[] other) {
        int i;
        System.out.println("--- COMPARISON ---");
        int min = Math.min(one.length, other.length);
        for (i = 0; i < min; ++i) {
            System.out.print("" + i + ") " + this.toHex(one[i]) + " " + (char)one[i] + " --- " + this.toHex(other[i]) + " " + (char)other[i]);
            System.out.print(one[i] == other[i] ? "\n" : " *****\n");
        }
        if (one.length > other.length) {
            for (i = min; i < one.length; ++i) {
                System.out.println("" + i + ") " + this.toHex(one[i]) + " " + (char)one[i] + " --- ");
            }
        } else if (other.length > one.length) {
            for (i = min; i < other.length; ++i) {
                System.out.println("" + i + ")      --- " + this.toHex(other[i]) + " " + (char)other[i]);
            }
        }
        System.out.println("--- END COMPARISON ---");
    }

    public void tearDown() {
        this.oos = null;
        this.baos = null;
    }

    public void testBlockdata1() {
        this.setUpFile();
        try {
            this.oos.writeBoolean(false);
            this.oos.writeBoolean(true);
            this.oos.writeInt(10);
            this.oos.writeLong(16L);
            this.oos.writeShort(5);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        th.check(Arrays.equals(READ_File.DATABLOCK1, this.baos.toByteArray()), "checking written data");
    }

    public void testBlockdata2() {
        this.setUpFile();
        try {
            this.oos.writeDouble(1.0);
            this.oos.writeFloat(-1.0f);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        th.check(Arrays.equals(READ_File.DATABLOCK2, this.baos.toByteArray()), "checking written data");
    }

    public void testSimpleClass() {
        this.setUpFile();
        SM_Simple simple2 = new SM_Simple();
        try {
            this.oos.writeObject(simple2);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        th.check(Arrays.equals(READ_File.Simple, this.baos.toByteArray()), "checking written data");
    }

    public void testClassString() {
        this.setUpFile();
        SM_ClassString instance = new SM_ClassString();
        try {
            this.oos.writeObject(instance);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        th.check(Arrays.equals(READ_File.ClassString, this.baos.toByteArray()), "checking written data");
    }

    public void testClassArray() {
        this.setUpFile();
        SM_ClassArray instance = new SM_ClassArray();
        try {
            this.oos.writeObject(instance);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        th.check(Arrays.equals(READ_File.ClassArray, this.baos.toByteArray()), "checking written data");
        this.printComparison(READ_File.ClassArray, this.baos.toByteArray());
    }

    public void testVector() {
        this.setUpFile();
        Vector<Object> instance = new Vector<Object>();
        instance.add("Hello world");
        instance.add(new Integer(666));
        try {
            this.oos.writeObject(instance);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        th.check(Arrays.equals(READ_File.Vector, this.baos.toByteArray()), "checking written data");
    }

    public void testStringBuffer() {
        this.setUpFile();
        StringBuffer instance = new StringBuffer("Hello");
        try {
            this.oos.writeObject(instance);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem");
        }
        th.check(Arrays.equals(READ_File.StringBuffer, this.baos.toByteArray()), "checking written data");
        this.printComparison(READ_File.StringBuffer, this.baos.toByteArray());
    }

    public void testInheritance() {
        this.setUpFile();
        ClassSubclass instance = new ClassSubclass();
        try {
            this.oos.writeObject(instance);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem");
        }
        th.check(Arrays.equals(READ_File.ClassSubClass, this.baos.toByteArray()), "checking written data");
    }

    public void testUnderscore() {
        this.setUpFile();
        SM_ClassUnderscore instance = new SM_ClassUnderscore();
        try {
            this.oos.writeObject(instance);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem");
        }
        th.check(Arrays.equals(READ_File.SM_ClassUnderscore, this.baos.toByteArray()), "checking written data");
    }

    public void testSimpleOuterClass() {
        this.setUpFile();
        SAMPLE_SimpleOuterClass instance = new SAMPLE_SimpleOuterClass();
        try {
            this.oos.writeObject(instance);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem");
        }
        th.check(Arrays.equals(READ_File.SAMPLE_SimpleOuterClass, this.baos.toByteArray()), "checking written data");
    }

    public void testBlockdatalong() {
        this.setUpFile();
        try {
            byte[] blockdatabytes = new byte[1022];
            this.oos.write(blockdatabytes);
            this.oos.writeInt(16909060);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem");
        }
        th.check(Arrays.equals(READ_File.BLOCKDATALONG, this.baos.toByteArray()), "checking written data");
    }

    public void testStringBufferArray() {
        this.setUpFile();
        try {
            StringBuffer[] stringbufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
            this.oos.writeObject(stringbufferArray);
            this.oos.close();
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem");
        }
        th.check(Arrays.equals(READ_File.StringBufferArray, this.baos.toByteArray()), "checking written data");
        this.printComparison(READ_File.StringBufferArray, this.baos.toByteArray());
    }

    public void runTest() {
        th.setclass("java.io.ObjectOutputStream");
        th.checkPoint("testStringBufferArray;");
        this.testStringBufferArray();
        th.checkPoint("testBlockdatalong();");
        this.testBlockdatalong();
        th.checkPoint("testBlockdata1();");
        this.testBlockdata1();
        th.checkPoint("testBlockdata2();");
        this.testBlockdata2();
        th.checkPoint("testClassString();");
        this.testClassString();
        th.checkPoint("testClassArray();");
        this.testClassArray();
        th.checkPoint("testVector();");
        this.testVector();
        th.checkPoint("testStringBuffer();");
        this.testStringBuffer();
        th.checkPoint("testInheritance();");
        this.testInheritance();
        th.checkPoint("testUnderscore();");
        this.testUnderscore();
        th.checkPoint("testSimpleOuterClass();");
        this.testSimpleOuterClass();
    }
}

