/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.Serialization;

import gnu.testlet.Mv_Assert;
import gnu.testlet.wonka.io.Serialization.Assert;
import gnu.testlet.wonka.io.Serialization.ClassSubclass;
import gnu.testlet.wonka.io.Serialization.CreateByteArray;
import gnu.testlet.wonka.io.Serialization.READ_File;
import gnu.testlet.wonka.io.Serialization.SAMPLE_SimpleOuterClass;
import gnu.testlet.wonka.io.Serialization.SM_ClassArray;
import gnu.testlet.wonka.io.Serialization.SM_ClassString;
import gnu.testlet.wonka.io.Serialization.SM_ClassUnderscore;
import gnu.testlet.wonka.io.Serialization.SM_Simple;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class SMObjectInputStreamTest
extends Mv_Assert {
    private ObjectInputStream ois;
    private READ_File file;

    public void setUp() {
    }

    private void setUpFile(String filename) {
        this.ois = this.file.open(filename);
    }

    public void tearDown() {
        this.file.close();
        this.ois = null;
    }

    public void testBlockdata1() {
        this.setUpFile("DUMPdata1");
        System.out.println("If there was an IOException this cannot be printed, got ois " + this.ois);
        try {
            SMObjectInputStreamTest.assert(!this.ois.readBoolean());
            SMObjectInputStreamTest.assert(this.ois.readBoolean());
            SMObjectInputStreamTest.assertEquals(10L, this.ois.readInt());
            SMObjectInputStreamTest.assertEquals(16L, this.ois.readLong());
            SMObjectInputStreamTest.assertEquals(5L, this.ois.readShort());
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
    }

    public void testBlockdata2() {
        this.setUpFile("DUMPdata2");
        try {
            SMObjectInputStreamTest.assertEquals(1.0, this.ois.readDouble(), 0.001);
            SMObjectInputStreamTest.assertEquals(-1.0, this.ois.readFloat(), 0.001);
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
    }

    public void testSimpleClass() {
        this.setUpFile("DUMPSimple");
        try {
            SM_Simple memory = new SM_Simple();
            SM_Simple streamed = (SM_Simple)this.ois.readObject();
            SMObjectInputStreamTest.assertEquals(memory, streamed);
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void testClassString() {
        this.setUpFile("DUMPString");
        try {
            SM_ClassString memory = new SM_ClassString();
            SM_ClassString streamed = (SM_ClassString)this.ois.readObject();
            SMObjectInputStreamTest.assertEquals(memory, streamed);
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void testClassArray() {
        this.setUpFile("DUMPArray");
        try {
            SM_ClassArray memory = new SM_ClassArray();
            SM_ClassArray streamed = (SM_ClassArray)this.ois.readObject();
            SMObjectInputStreamTest.assertEquals(memory, streamed);
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void testVector() {
        this.setUpFile("DUMPVector");
        try {
            Vector streamed = (Vector)this.ois.readObject();
            SMObjectInputStreamTest.assertEquals(streamed.elementAt(0), "Hello world");
            SMObjectInputStreamTest.assertEquals(streamed.elementAt(1), new Integer(666));
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void testStringBuffer() {
        this.setUpFile("DUMPStringBuffer");
        try {
            StringBuffer streamed = (StringBuffer)this.ois.readObject();
            SMObjectInputStreamTest.assertEquals(new String(streamed), "Hello");
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void testInheritance() {
        this.setUpFile("DUMPSubclass");
        try {
            ClassSubclass memory = new ClassSubclass();
            ClassSubclass streamed = (ClassSubclass)this.ois.readObject();
            SMObjectInputStreamTest.assertEquals(memory, streamed);
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void testUnderscore() {
        this.setUpFile("DUMPUnderscore");
        try {
            SM_ClassUnderscore memory = new SM_ClassUnderscore();
            SM_ClassUnderscore streamed = (SM_ClassUnderscore)this.ois.readObject();
            SMObjectInputStreamTest.assertEquals(memory, streamed);
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void testSimpleOuterClass() {
        this.setUpFile("DUMPOuterClass");
        try {
            SAMPLE_SimpleOuterClass memory = new SAMPLE_SimpleOuterClass();
            SAMPLE_SimpleOuterClass streamed = (SAMPLE_SimpleOuterClass)this.ois.readObject();
            SMObjectInputStreamTest.assertEquals(memory, streamed);
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void testBlockdatalong() {
        this.setUpFile("DUMPBlockdatalong");
        try {
            for (int i = 0; i < 1022; ++i) {
                byte by = this.ois.readByte();
            }
            SMObjectInputStreamTest.assertEquals(16909060L, this.ois.readInt());
            try {
                this.ois.readByte();
                SMObjectInputStreamTest.fail("Should never be here!");
            }
            catch (Exception exc) {
                SMObjectInputStreamTest.assert(true);
            }
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO Problem.");
        }
    }

    public void testStringBufferArray() {
        this.setUpFile("DUMP_SBA");
        try {
            Object o = this.ois.readObject();
            System.out.println("CLASSNAME: " + o.getClass().getName());
            StringBuffer[] stringbufferArray = (StringBuffer[])o;
            SMObjectInputStreamTest.assert(stringbufferArray.length == 2);
            if (stringbufferArray[0] == null) {
                System.out.println("It fucking is null.");
            }
            System.out.println("CLASSNAME: " + stringbufferArray[0].getClass().getName());
            SMObjectInputStreamTest.assert(stringbufferArray[0].toString().equals(""));
            SMObjectInputStreamTest.assert(stringbufferArray[1].toString().equals(""));
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO Problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
            Assert.problem(exc, "Other problem....");
        }
    }

    public void testCreateByteArray() {
        this.setUpFile("DUMP_CreateByteArray");
        try {
            Object o = this.ois.readObject();
            th.check(o instanceof CreateByteArray, "got " + o);
        }
        catch (IOException exc) {
            Assert.problem(exc, "IO problem.");
        }
        catch (ClassNotFoundException exc) {
            Assert.problem(exc, "Class not found....");
        }
    }

    public void runTest() {
        this.file = new READ_File();
        th.checkPoint("CreateByteArray(<clinit>)");
        this.testCreateByteArray();
    }
}

