/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.PrintWriter;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.PrintWriter.SMErrorWriter;
import gnu.testlet.wonka.io.PrintWriter.SMExPrintWriter;
import gnu.testlet.wonka.io.PrintWriter.SMlockPrintWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Writer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMPrintWriterTest
implements Testlet {
    protected TestHarness th;
    protected String sep;
    protected String xsep;
    protected int accesed;
    private Thread t;
    private volatile boolean f1;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.PrintWriter");
        this.test_PrintWriter();
        this.test_print();
        this.test_println();
        this.test_write();
        this.test_checkError();
        this.test_setError();
        this.test_close();
        this.test_flush();
        this.test_lock();
    }

    public void test_PrintWriter() {
        this.th.checkPoint("PrintWriter(java.io.Writer)");
        CharArrayWriter caw = new CharArrayWriter();
        SMExPrintWriter xpw = new SMExPrintWriter(caw);
        boolean bl = false;
        if (xpw.getOut() == caw) {
            bl = true;
        }
        this.th.check(bl);
        this.th.checkPoint("PrintWriter(java.io.Writer,boolean)");
        xpw = new SMExPrintWriter((Writer)caw, true);
        boolean bl2 = false;
        if (xpw.getOut() == caw) {
            bl2 = true;
        }
        this.th.check(bl2);
        try {
            new SMExPrintWriter(null);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            new SMExPrintWriter(null, false);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        this.th.checkPoint("PrintWriter(java.io.OutputStream)");
        xpw = new SMExPrintWriter(new ByteArrayOutputStream());
        try {
            new SMExPrintWriter(null);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        this.th.checkPoint("PrintWriter(java.io.OutputStream,boolean)");
        xpw = new SMExPrintWriter(new ByteArrayOutputStream(), true);
        try {
            new SMExPrintWriter(null, false);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_print() {
        this.th.checkPoint("print(boolean)void");
        CharArrayWriter caw = new CharArrayWriter();
        SMExPrintWriter xpw = new SMExPrintWriter(caw);
        xpw.print(true);
        this.th.check(caw.toString().equals(String.valueOf(true)), "checking true");
        xpw.print(false);
        this.th.check(caw.toString().equals("truefalse"), "checking true+false");
        this.th.checkPoint("print(int)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.print(43);
        this.th.check(caw.toString().equals(String.valueOf(43)), "checking intValue");
        this.th.checkPoint("print(long)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.print(43L);
        this.th.check(caw.toString().equals(String.valueOf(43L)), "checking longValue");
        this.th.checkPoint("print(float)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.print(43.5f);
        this.th.check(caw.toString().equals(String.valueOf(43.5f)), "checking floatValue");
        this.th.checkPoint("print(double)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.print(43.25);
        this.th.check(caw.toString().equals(String.valueOf(43.25)), "checking doubleValue");
        this.th.checkPoint("print(java.lang.Object)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        Object o = new Object();
        xpw.print(o);
        this.th.check(caw.toString().equals(String.valueOf(o)), "checking doubleValue");
        try {
            xpw.print((Object)null);
            this.th.check(caw.toString().equals(String.valueOf(o) + "null"), "checking string");
        }
        catch (NullPointerException ne) {
            this.th.fail("should not throw a NullpointerException");
        }
        this.th.checkPoint("print(java.lang.String)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        String s = "smartmove rules!";
        xpw.print(s);
        this.th.check(caw.toString().equals(s), "checking string");
        try {
            xpw.print((String)null);
            this.th.check(caw.toString().equals(s + "null"), "checking string");
        }
        catch (NullPointerException ne) {
            this.th.fail("should not throw a NullpointerException");
        }
        this.th.checkPoint("print(char)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.print('a');
        this.th.check(caw.toString().equals(String.valueOf('a')), "checking char");
        this.th.checkPoint("print(char[])void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.print(s.toCharArray());
        this.th.check(caw.toString().equals(String.valueOf(s.toCharArray())), "checking charArray");
        try {
            xpw.print((char[])null);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_println() {
        this.th.checkPoint("println()void");
        CharArrayWriter caw = new CharArrayWriter();
        SMExPrintWriter xpw = new SMExPrintWriter(caw);
        xpw.println();
        this.th.check(caw.toString().equals(this.sep), "checking line separator");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println();
        this.th.check(caw.toString().equals(this.xsep), "checking line separator");
        SMErrorWriter ew = new SMErrorWriter();
        xpw = new SMExPrintWriter((Writer)ew, false);
        xpw.println();
        this.th.check(ew.isFlushed() ^ true, "not flushed --> auto_flush is off");
        xpw = new SMExPrintWriter((Writer)ew, true);
        xpw.println("abcdef");
        this.th.checkPoint("println(boolean)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.println(true);
        this.th.check(caw.toString().equals(String.valueOf(true) + this.sep), "checking true");
        xpw.println(false);
        this.th.check(caw.toString().equals("true" + this.sep + "false" + this.sep), "checking true+false");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println(true);
        this.th.check(caw.toString().equals(String.valueOf(true) + this.xsep), "checking use of println()");
        this.th.checkPoint("println(int)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.println(43);
        this.th.check(caw.toString().equals(String.valueOf(43) + this.sep), "checking intValue");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println(43);
        this.th.check(caw.toString().equals(String.valueOf(43) + this.xsep), "checking use of println()");
        this.th.checkPoint("println(long)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.println(43L);
        this.th.check(caw.toString().equals(String.valueOf(43L) + this.sep), "checking longValue");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println(43L);
        this.th.check(caw.toString().equals(String.valueOf(43L) + this.xsep), "checking use of println()");
        this.th.checkPoint("println(float)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.println(43.5f);
        this.th.check(caw.toString().equals(String.valueOf(43.5f) + this.sep), "checking floatValue");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println(43.5f);
        this.th.check(caw.toString().equals(String.valueOf(43.5f) + this.xsep), "checking use of println()");
        this.th.checkPoint("println(double)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.println(43.25);
        this.th.check(caw.toString().equals(String.valueOf(43.25) + this.sep), "checking doubleValue");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println(43.25);
        this.th.check(caw.toString().equals(String.valueOf(43.25) + this.xsep), "checking use of println()");
        this.th.checkPoint("println(java.lang.Object)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        Object o = new Object();
        xpw.println(o);
        this.th.check(caw.toString().equals(String.valueOf(o) + this.sep), "checking ObjectValue");
        try {
            xpw.println((Object)null);
            this.th.check(caw.toString().equals(String.valueOf(o) + this.sep + "null" + this.sep), "checking string");
        }
        catch (NullPointerException ne) {
            this.th.fail("should not throw a NullpointerException");
        }
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println(o);
        this.th.check(caw.toString().equals(String.valueOf(o) + this.xsep), "checking use of println()");
        this.th.checkPoint("println(java.lang.String)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        String s = "smartmove rules!";
        xpw.println(s);
        this.th.check(caw.toString().equals(s + this.sep), "checking string");
        try {
            xpw.println((String)null);
            this.th.check(caw.toString().equals(s + this.sep + "null" + this.sep), "checking string");
        }
        catch (NullPointerException ne) {
            this.th.fail("should not throw a NullpointerException");
        }
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println(s);
        this.th.check(caw.toString().equals(s + this.xsep), "checking use of println()");
        this.th.checkPoint("println(char)void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.println('a');
        this.th.check(caw.toString().equals(String.valueOf('a') + this.sep), "checking char");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println('a');
        this.th.check(caw.toString().equals(String.valueOf('a') + this.xsep), "checking use of println()");
        this.th.checkPoint("println(char[])void");
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter(caw);
        xpw.println(s.toCharArray());
        this.th.check(caw.toString().equals(String.valueOf(s.toCharArray()) + this.sep), "checking charArray");
        try {
            xpw.print((char[])null);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        caw = new CharArrayWriter();
        xpw = new SMExPrintWriter((Writer)caw, 1);
        xpw.println(s.toCharArray());
        this.th.check(caw.toString().equals(String.valueOf(s.toCharArray()) + this.xsep), "checking use of println()");
    }

    public void test_write() {
        String s;
        char[] ca;
        this.th.checkPoint("write(int)void");
        CharArrayWriter caw = new CharArrayWriter();
        SMExPrintWriter xw = new SMExPrintWriter(caw);
        xw.write(97);
        xw.write(98);
        xw.write(99);
        xw.write(98);
        xw.write(97);
        this.th.check(caw.toString().equals("abcba"), "check if chars are added");
        this.th.checkPoint("write(char[])void");
        caw = new CharArrayWriter();
        xw = new SMExPrintWriter(caw);
        xw.write("".toCharArray());
        this.th.check("".equals(caw.toString()), "checking write -- 1, got:" + caw.toString());
        xw.write("bcdefg".toCharArray());
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 2, got:" + caw.toString());
        xw.write("abcd".toCharArray());
        this.th.check("bcdefgabcd".equals(caw.toString()), "checking write -- 3, got:" + caw.toString());
        xw.write("a".toCharArray());
        this.th.check("bcdefgabcda".equals(caw.toString()), "checking write -- 4, got:" + caw.toString());
        try {
            ca = null;
            xw.write(ca);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        this.th.checkPoint("write(char[],int,int)void");
        caw = new CharArrayWriter();
        xw = new SMExPrintWriter(caw);
        xw.write("".toCharArray(), 0, 0);
        this.th.check("".equals(caw.toString()), "checking write -- 1, got:" + caw.toString());
        xw.write("abcdefgh".toCharArray(), 1, 6);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 2, got:" + caw.toString());
        xw.write("abcd".toCharArray(), 4, 0);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 3, got:" + caw.toString());
        xw.write("a".toCharArray(), 0, 0);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 4, got:" + caw.toString());
        xw.write("abcd".toCharArray(), 2, 2);
        this.th.check("bcdefgcd".equals(caw.toString()), "checking write -- 5, got:" + caw.toString());
        xw.write("abcd".toCharArray(), 0, 4);
        this.th.check("bcdefgcdabcd".equals(caw.toString()), "checking write -- 6, got:" + caw.toString());
        try {
            ca = null;
            xw.write(ca, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            xw.write("abcde".toCharArray(), 4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            xw.write("abcde".toCharArray(), -4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 3, got:" + e);
        }
        try {
            xw.write("abcde".toCharArray(), 4, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 4, got:" + e);
        }
        try {
            xw.write("abcde".toCharArray(), 6, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 5, got:" + e);
        }
        this.th.checkPoint("write(java.lang.String)void");
        caw = new CharArrayWriter();
        xw = new SMExPrintWriter(caw);
        xw.write("", 0, 0);
        this.th.check("".equals(caw.toString()), "checking write -- 1, got:" + caw.toString());
        xw.write("bcdefg");
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 2, got:" + caw.toString());
        xw.write("abcd");
        this.th.check("bcdefgabcd".equals(caw.toString()), "checking write -- 3, got:" + caw.toString());
        xw.write("a");
        this.th.check("bcdefgabcda".equals(caw.toString()), "checking write -- 4, got:" + caw.toString());
        try {
            s = null;
            xw.write(s);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        this.th.checkPoint("write(java.lang.String,int,int)void");
        caw = new CharArrayWriter();
        xw = new SMExPrintWriter(caw);
        xw.write("", 0, 0);
        this.th.check("".equals(caw.toString()), "checking write -- 1, got:" + caw.toString());
        xw.write("abcdefgh", 1, 6);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 2, got:" + caw.toString());
        xw.write("abcd", 4, 0);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 3, got:" + caw.toString());
        xw.write("a", 0, 0);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 4, got:" + caw.toString());
        xw.write("abcd", 2, 2);
        this.th.check("bcdefgcd".equals(caw.toString()), "checking write -- 5, got:" + caw.toString());
        xw.write("abcd", 0, 4);
        this.th.check("bcdefgcdabcd".equals(caw.toString()), "checking write -- 6, got:" + caw.toString());
        try {
            s = null;
            xw.write(s, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            xw.write("abcde", 4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            xw.write("abcde", -4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 3, got:" + e);
        }
        try {
            xw.write("abcde", 4, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 4, got:" + e);
        }
        try {
            xw.write("abcde", 6, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 5, got:" + e);
        }
    }

    public void test_checkError() {
        this.th.checkPoint("checkError()boolean");
        SMErrorWriter ew = new SMErrorWriter();
        SMExPrintWriter xw = new SMExPrintWriter(ew);
        xw.close();
        this.th.check(xw.checkError(), "checking Error flag set -- close");
        xw = new SMExPrintWriter(ew);
        xw.flush();
        this.th.check(xw.checkError(), "checking Error flag set -- flush");
        xw = new SMExPrintWriter(ew);
        xw.write(1);
        this.th.check(xw.checkError(), "checking Error flag set -- write 1");
        xw = new SMExPrintWriter(ew);
        xw.write("abcd", 1, 3);
        this.th.check(xw.checkError(), "checking Error flag set -- write 2");
        xw = new SMExPrintWriter(ew);
        xw.write("as");
        this.th.check(xw.checkError(), "checking Error flag set -- write 3");
        xw = new SMExPrintWriter(ew);
        char[] ca = "abcde".toCharArray();
        xw.write(ca, 1, 3);
        this.th.check(xw.checkError(), "checking Error flag set -- write 4");
        xw = new SMExPrintWriter(ew);
        xw.write(ca);
        this.th.check(xw.checkError(), "checking Error flag set -- write 5");
    }

    public void test_setError() {
        this.th.checkPoint("setError()void");
        CharArrayWriter caw = new CharArrayWriter();
        SMExPrintWriter xw = new SMExPrintWriter(caw);
        xw.setError();
        this.th.check(xw.checkError(), "checking setError");
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        SMErrorWriter ew = new SMErrorWriter(1);
        SMExPrintWriter xw = new SMExPrintWriter(ew);
        xw.close();
        boolean bl = false;
        if (ew.timesClosed() == 1) {
            bl = true;
        }
        this.th.check(bl);
        xw.close();
        xw.close();
        xw.close();
        boolean bl2 = false;
        if (ew.timesClosed() == 1) {
            bl2 = true;
        }
        this.th.check(bl2, "should only sent one close");
    }

    public void test_flush() {
        this.th.checkPoint("flush()void");
        SMErrorWriter ew = new SMErrorWriter();
        SMExPrintWriter xw = new SMExPrintWriter(ew);
        xw.flush();
        this.th.check(ew.isFlushed());
    }

    public void test_lock() {
        this.th.checkPoint("lock(protected)java.lang.Object");
        SMErrorWriter ew = new SMErrorWriter();
        SMExPrintWriter wr = new SMExPrintWriter(ew);
        SMlockPrintWriter lt = new SMlockPrintWriter();
        int i = this.setupLockThread(lt, wr);
        wr.write(97);
        boolean bl = false;
        if (i + 1 == this.accesed) {
            bl = true;
        }
        this.th.check(bl, "accesed xr before lock was released -- write 1");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockPrintWriter();
        i = this.setupLockThread(lt, wr);
        wr.write("abcd", 1, 2);
        boolean bl2 = false;
        if (i + 1 == this.accesed) {
            bl2 = true;
        }
        this.th.check(bl2, "accesed xr before lock was released -- write 2");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockPrintWriter();
        i = this.setupLockThread(lt, wr);
        wr.write("abcd");
        boolean bl3 = false;
        if (i + 1 == this.accesed) {
            bl3 = true;
        }
        this.th.check(bl3, "accesed xr before lock was released -- write 3");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockPrintWriter();
        i = this.setupLockThread(lt, wr);
        wr.write("abcd".toCharArray(), 1, 2);
        boolean bl4 = false;
        if (i + 1 == this.accesed) {
            bl4 = true;
        }
        this.th.check(bl4, "accesed xr before lock was released -- write 4");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockPrintWriter();
        i = this.setupLockThread(lt, wr);
        wr.write("abcd".toCharArray());
        boolean bl5 = false;
        if (i + 1 == this.accesed) {
            bl5 = true;
        }
        this.th.check(bl5, "accesed xr before lock was released -- write 5");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockPrintWriter();
        i = this.setupLockThread(lt, wr);
        wr.print("abcd");
        boolean bl6 = false;
        if (i + 1 == this.accesed) {
            bl6 = true;
        }
        this.th.check(bl6, "accesed xr before lock was released -- print");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockPrintWriter();
        i = this.setupLockThread(lt, wr);
        wr.println();
        boolean bl7 = false;
        if (i + 1 == this.accesed) {
            bl7 = true;
        }
        this.th.check(bl7, "accesed xr before lock was released -- println");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockPrintWriter();
        i = this.setupLockThread(lt, wr);
        wr.flush();
        boolean bl8 = false;
        if (i + 1 == this.accesed) {
            bl8 = true;
        }
        this.th.check(bl8, "accesed xr before lock was released -- flush");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockPrintWriter();
        i = this.setupLockThread(lt, wr);
        wr.close();
        boolean bl9 = false;
        if (i + 1 == this.accesed) {
            bl9 = true;
        }
        this.th.check(bl9, "accesed xr before lock was released -- close");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void inc() {
        ++this.accesed;
    }

    public int setupLockThread(SMlockPrintWriter lt, SMExPrintWriter pw) {
        this.f1 = false;
        lt.setWriter(pw);
        lt.setTestHarness(this.th);
        lt.setWT(this);
        this.t = new Thread(lt);
        this.t.start();
        while (!this.f1) {
            Thread.yield();
        }
        return this.accesed;
    }

    public void set1() {
        this.f1 = true;
    }

    private final /* synthetic */ void this() {
        this.sep = System.getProperty("line.separator", "\n");
        this.xsep = "#new separator#" + System.getProperty("line.separator", "\n");
        this.accesed = 0;
        this.t = null;
        this.f1 = false;
    }

    public SMPrintWriterTest() {
        this.this();
    }
}

