/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.InputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.InputStream.SMExInputStream;
import java.io.IOException;

public class SMInputStreamTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.InputStream");
        this.test_read();
        this.test_skip();
        this.test_mark();
        this.test_markSupported();
        this.test_reset();
        this.test_available();
        this.test_close();
    }

    public void test_read() {
        this.th.checkPoint("read()int");
        this.th.checkPoint("read(byte[])int");
        byte[] buffer = new byte[10];
        SMExInputStream is = new SMExInputStream();
        try {
            is.read(buffer);
            this.th.check("aaaaaaaaaa".equals(new String(buffer)), "checking read");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception --1, got:" + e);
        }
        int rc = is.getRC();
        try {
            is.read(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- 2, got:" + e);
        }
        this.th.check(is.readed(rc), "read was called --> not expected");
        this.th.checkPoint("read(byte[],int,int)int");
        buffer = new byte[10];
        int i = 0;
        while (i < 10) {
            buffer[i] = 98;
            ++i;
        }
        try {
            is.read(buffer, 0, 1);
            is.read(buffer, 3, 1);
            is.read(buffer, 5, 5);
            this.th.check("abbabaaaaa".equals(new String(buffer)), "checking read");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- 1, got:" + e);
        }
        rc = is.getRC();
        try {
            is.read(null, 3, 1);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- 2, got:" + e);
        }
        try {
            is.read(buffer, -3, 1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 3, got:" + e);
        }
        try {
            is.read(buffer, 3, 8);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 4, got:" + e);
        }
        try {
            is.read(buffer, 3, -1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 5, got:" + e);
        }
        try {
            is.read(buffer, 11, 1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 6, got:" + e);
        }
        this.th.check(is.readed(rc), "read was called --> not expected");
    }

    public void test_skip() {
        this.th.checkPoint("skip(long)long");
        SMExInputStream is = new SMExInputStream();
        try {
            boolean bl = false;
            if (is.skip(120L) == 120L) {
                bl = true;
            }
            this.th.check(bl, "checking return value -- 1");
            this.th.check(is.skip(-4294967292L), 0L, "checking return value -- 2");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception, got:" + e);
        }
        try {
            boolean bl = false;
            if (is.skip(-120L) == 0L) {
                bl = true;
            }
            this.th.check(bl, "checking return value -- 3");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception, got:" + e);
        }
    }

    public void test_mark() {
        this.th.checkPoint("mark(int)void");
        SMExInputStream is = new SMExInputStream();
        try {
            is.mark(30);
            boolean bl = false;
            if (is.read() == 97) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception, got:" + e);
        }
    }

    public void test_markSupported() {
        this.th.checkPoint("markSupported()boolean");
        SMExInputStream is = new SMExInputStream();
        try {
            this.th.check(is.markSupported() ^ true, "always returns false -- 1");
            is.read();
            is.mark(20);
            this.th.check(is.markSupported() ^ true, "always returns false -- 2");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception, got:" + e);
        }
    }

    public void test_reset() {
        this.th.checkPoint("reset()void");
        SMExInputStream is = new SMExInputStream();
        try {
            is.reset();
            this.th.fail("should throw IOException");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
    }

    public void test_available() {
        this.th.checkPoint("available()int");
        SMExInputStream is = new SMExInputStream();
        try {
            boolean bl = false;
            if (is.available() == 0) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (IOException ioe) {
            this.th.fail("should not throw an IOException, got:" + ioe);
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        SMExInputStream is = new SMExInputStream();
        try {
            is.close();
            boolean bl = false;
            if (is.read() == 97) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception, got:" + e);
        }
    }
}

