/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.ByteArrayOutputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.ByteArrayOutputStream.SMExByteArrayOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SMByteArrayOutputStreamTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.ByteArrayOutputStream");
        this.test_ByteArrayOutputStream();
        this.test_write();
        this.test_reset();
        this.test_size();
        this.test_toByteArray();
        this.test_toString();
        this.test_writeTo();
        this.test_close();
    }

    public void test_ByteArrayOutputStream() {
        this.th.checkPoint("ByteArrayOutputStream()");
        SMExByteArrayOutputStream xbout = new SMExByteArrayOutputStream();
        boolean bl = false;
        if (xbout.get_length() == 32) {
            bl = true;
        }
        this.th.check(bl);
        boolean bl2 = false;
        if (xbout.get_count() == 0) {
            bl2 = true;
        }
        this.th.check(bl2);
        this.th.checkPoint("ByteArrayOutputStream(int)");
        xbout = new SMExByteArrayOutputStream(0);
        boolean bl3 = false;
        if (xbout.get_count() == 0) {
            bl3 = true;
        }
        this.th.check(bl3);
        boolean bl4 = false;
        if (xbout.get_length() == 0) {
            bl4 = true;
        }
        this.th.check(bl4);
        xbout = new SMExByteArrayOutputStream(1);
        boolean bl5 = false;
        if (xbout.get_length() == 1) {
            bl5 = true;
        }
        this.th.check(bl5);
        boolean bl6 = false;
        if (xbout.get_count() == 0) {
            bl6 = true;
        }
        this.th.check(bl6);
        xbout = new SMExByteArrayOutputStream(55);
        boolean bl7 = false;
        if (xbout.get_length() == 55) {
            bl7 = true;
        }
        this.th.check(bl7);
        xbout = new SMExByteArrayOutputStream(77);
        boolean bl8 = false;
        if (xbout.get_length() == 77) {
            bl8 = true;
        }
        this.th.check(bl8);
        try {
            new ByteArrayOutputStream(-1);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true);
        }
    }

    public void test_write() {
        this.th.checkPoint("write(int)void");
        SMExByteArrayOutputStream xbout = new SMExByteArrayOutputStream();
        xbout.write(97);
        boolean bl = false;
        if (xbout.get_count() == 1) {
            bl = true;
        }
        this.th.check(bl);
        xbout.write(98);
        xbout.write(99);
        xbout.write(100);
        boolean bl2 = false;
        if (xbout.get_count() == 4) {
            bl2 = true;
        }
        this.th.check(bl2);
        this.th.check(new String(xbout.get_buf(), 0, xbout.get_count()).equals("abcd"), "checking if all byte are written");
        try {
            xbout.close();
            xbout.write(12);
        }
        catch (Exception ieo) {
            this.th.fail("close is ignored");
        }
        this.th.checkPoint("write(byte[],int,int)void");
        xbout = new SMExByteArrayOutputStream();
        String s = "abcdefgh";
        xbout.write(s.getBytes(), 0, 8);
        boolean bl3 = false;
        if (xbout.get_count() == 8) {
            bl3 = true;
        }
        this.th.check(bl3);
        this.th.check(s.equals(new String(xbout.get_buf(), 0, xbout.get_count())), "checking what is written -- 1, got:" + new String(xbout.get_buf(), 0, xbout.get_count()));
        xbout.write(s.getBytes(), 1, 6);
        boolean bl4 = false;
        if (xbout.get_count() == 14) {
            bl4 = true;
        }
        this.th.check(bl4);
        this.th.check("abcdefghbcdefg".equals(new String(xbout.get_buf(), 0, xbout.get_count())), "checking what is written -- 2, got:" + new String(xbout.get_buf(), 0, xbout.get_count()));
        xbout.write(s.getBytes(), 3, 0);
        boolean bl5 = false;
        if (xbout.get_count() == 14) {
            bl5 = true;
        }
        this.th.check(bl5);
        this.th.check("abcdefghbcdefg".equals(new String(xbout.get_buf(), 0, xbout.get_count())), "checking what is written -- 3, got:" + new String(xbout.get_buf(), 0, xbout.get_count()));
        try {
            xbout.write(s.getBytes(), 3, 6);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            xbout.write(s.getBytes(), -1, 5);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            xbout.write(s.getBytes(), 6, -5);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            xbout.write(s.getBytes(), 8, 1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 5");
        }
        catch (IndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            xbout.write(null, 8, 1);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        boolean bl6 = false;
        if (xbout.get_count() == 14) {
            bl6 = true;
        }
        this.th.check(bl6);
        this.th.check("abcdefghbcdefg".equals(new String(xbout.get_buf(), 0, xbout.get_count())), "checking if nothing is added while trting to trigger exceptions, got:" + new String(xbout.get_buf(), 0, xbout.get_count()));
        try {
            xbout.close();
            xbout.write(s.getBytes(), 5, 1);
        }
        catch (Exception ieo) {
            this.th.fail("writting to a closed stream is allowed");
        }
    }

    public void test_reset() {
        this.th.checkPoint("reset()void");
        SMExByteArrayOutputStream xbout = new SMExByteArrayOutputStream();
        String s = "abcdefgh";
        xbout.write(s.getBytes(), 0, 8);
        xbout.reset();
        boolean bl = false;
        if (xbout.get_count() == 0) {
            bl = true;
        }
        this.th.check(bl);
        this.th.check(xbout.toString().equals(""));
        xbout.write(120);
        boolean bl2 = false;
        if (xbout.get_buf()[0] == 120) {
            bl2 = true;
        }
        this.th.check(bl2, "writting at 1st pos after a reset");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        SMExByteArrayOutputStream xbout = new SMExByteArrayOutputStream();
        String s = "abcdefgh";
        xbout.write(s.getBytes(), 0, 8);
        boolean bl = false;
        if (xbout.size() == 8) {
            bl = true;
        }
        this.th.check(bl);
        xbout.reset();
        boolean bl2 = false;
        if (xbout.size() == 0) {
            bl2 = true;
        }
        this.th.check(bl2);
        xbout.write(120);
        boolean bl3 = false;
        if (xbout.size() == 1) {
            bl3 = true;
        }
        this.th.check(bl3);
    }

    public void test_toByteArray() {
        this.th.checkPoint("toByteArray()byte[]");
        SMExByteArrayOutputStream xbout = new SMExByteArrayOutputStream();
        String s = "abcdefgh";
        boolean bl = false;
        if (xbout.toByteArray() != null) {
            bl = true;
        }
        this.th.check(bl, "should be an empty array");
        boolean bl2 = false;
        if (xbout.toByteArray().length == 0) {
            bl2 = true;
        }
        this.th.check(bl2, "length of array is 0");
        xbout.write(s.getBytes(), 0, 8);
        boolean bl3 = false;
        if (xbout.get_buf() != xbout.toByteArray()) {
            bl3 = true;
        }
        this.th.check(bl3);
        this.th.check(s.equals(new String(xbout.toByteArray())), "should give only the bytes written");
        xbout.write(s.getBytes(), 1, 6);
        this.th.check("abcdefghbcdefg".equals(new String(xbout.toByteArray())), "should give only the bytes written");
        xbout.reset();
        boolean bl4 = false;
        if (xbout.toByteArray().length == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "length of array is 0 after reset");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        SMExByteArrayOutputStream xbout = new SMExByteArrayOutputStream();
        String s = "abcdefgh";
        boolean bl = false;
        if (xbout.toString() != null) {
            bl = true;
        }
        this.th.check(bl, "should be an empty array");
        this.th.check("".equals(xbout.toString()), "should return empty string -- 1");
        xbout.write(s.getBytes(), 0, 8);
        this.th.check(s.equals(xbout.toString()), "should give only the bytes written");
        xbout.write(s.getBytes(), 1, 6);
        this.th.check("abcdefghbcdefg".equals(xbout.toString()), "should give only the bytes written");
        xbout.reset();
        this.th.check("".equals(xbout.toString()), "should return empty string -- 2");
        this.th.checkPoint("toString(java.lang.String)java.lang.String");
        xbout = new SMExByteArrayOutputStream();
        try {
            boolean bl2 = false;
            if (xbout.toString("8859_1") != null) {
                bl2 = true;
            }
            this.th.check(bl2, "should be an empty array");
            this.th.check("".equals(xbout.toString("8859_1")), "should return empty string -- 1");
            xbout.write(s.getBytes(), 0, 8);
            this.th.check(s.equals(xbout.toString("8859_1")), "should give only the bytes written");
            xbout.write(s.getBytes(), 1, 6);
            this.th.check("abcdefghbcdefg".equals(xbout.toString("8859_1")), "should give only the bytes written");
            xbout.reset();
            this.th.check("".equals(xbout.toString("8859_1")), "should return empty string -- 2");
        }
        catch (IOException ioe) {
            this.th.fail("should not throw an IOException, got:" + ioe);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1,got: " + e);
        }
        try {
            xbout.toString((String)null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 2,got: " + e);
        }
        try {
            xbout.toString("this is not a good encoding string");
            this.th.fail("should throw UnsupportedEncodingException");
        }
        catch (UnsupportedEncodingException ne) {
            this.th.check(true);
        }
    }

    public void test_writeTo() {
        this.th.checkPoint("writeTo(java.io.OutputStream)void");
        SMExByteArrayOutputStream xbout1 = new SMExByteArrayOutputStream();
        SMExByteArrayOutputStream xbout2 = new SMExByteArrayOutputStream();
        String s = "abcdefgh";
        try {
            xbout1.writeTo(null);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (IOException ioe) {
            this.th.fail("should not throw an IOException -- 1, got:" + ioe);
        }
        try {
            xbout1.writeTo(xbout2);
            this.th.check("".equals(xbout2.toString()), "making sure empty to empty works");
            xbout1.write(s.getBytes(), 0, 8);
            xbout1.write(s.getBytes(), 0, 8);
            xbout1.writeTo(xbout2);
            this.th.check("abcdefghabcdefgh".equals(xbout2.toString()), "making sure writeTo an empty stream works");
            xbout1.writeTo(xbout2);
            this.th.check("abcdefghabcdefghabcdefghabcdefgh".equals(xbout2.toString()), "making sure writeTo does not overwrite the stream");
            xbout2.close();
        }
        catch (IOException ioe) {
            this.th.fail("should not throw an IOException -- 2, got:" + ioe);
        }
        try {
            xbout1.writeTo(xbout2);
        }
        catch (IOException ioe) {
            this.th.fail("close() is ignored");
        }
        try {
            xbout1.writeTo(null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (IOException ioe) {
            this.th.fail("should not throw an IOException -- 3, got:" + ioe);
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
    }
}

