/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.BufferedWriter;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.BufferedWriter.SMExWriter;
import gnu.testlet.wonka.io.BufferedWriter.SMlockBufferedWriter;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMBufferedWriterTest
implements Testlet {
    protected TestHarness th;
    protected int accesed;
    private Thread t;
    private volatile boolean f1;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.BufferedWriter");
        this.test_BufferedWriter();
        this.test_newLine();
        this.test_write();
        this.test_close();
        this.test_flush();
        this.test_lock();
    }

    public void test_BufferedWriter() {
        this.th.checkPoint("BufferedWriter(java.io.Writer)");
        CharArrayWriter caw = new CharArrayWriter();
        try {
            new BufferedWriter(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- 2, got:" + e);
        }
        this.th.checkPoint("BufferedWriter(java.io.Writer,int)");
        try {
            new BufferedWriter(null, 8);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- 2, got:" + e);
        }
        try {
            new BufferedWriter(caw, -1);
            this.th.fail("should throw IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- 2, got:" + e);
        }
        try {
            new BufferedWriter(caw, 0);
            this.th.fail("should throw IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- 3, got:" + e);
        }
    }

    public void test_newLine() {
        this.th.checkPoint("newLine()void");
        CharArrayWriter caw = new CharArrayWriter();
        BufferedWriter bw = new BufferedWriter(caw, 10);
        String s = System.getProperty("line.separator");
        try {
            bw.newLine();
            bw.newLine();
            bw.write(97);
            bw.flush();
            this.th.check(caw.toString(), s + s + 'a', "checking lineseparator");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- 1, got:" + e);
        }
    }

    public void test_write() {
        this.th.checkPoint("write(int)void");
        CharArrayWriter caw = new CharArrayWriter();
        BufferedWriter bw = new BufferedWriter(caw, 4);
        try {
            bw.write(97);
            bw.write(98);
            bw.write(99);
            bw.write(100);
            this.th.check(caw.toString(), "", "nothing written to underlying writer");
            bw.write(101);
            this.th.check(caw.toString().equals("abcd"), "there should be written to underlying writer -- 1, got:" + caw);
            bw.write(102);
            this.th.check(caw.toString().equals("abcd"), "there should be written to underlying writer -- 2, got:" + caw);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- 1, got:" + e);
        }
        this.th.checkPoint("write(char[],int,int)void");
        CharArrayWriter xw = new CharArrayWriter();
        bw = new BufferedWriter(xw, 12);
        try {
            bw.write(new char[0], 0, 0);
            bw.write("abcdefgh".toCharArray(), 1, 6);
            bw.write("abcd".toCharArray(), 4, 0);
            bw.write("a".toCharArray(), 0, 0);
            bw.write("abcd".toCharArray(), 2, 2);
            this.th.check("".equals(xw.toString()), "nothing is written to xw yet, got:" + xw);
            bw.write("abcd".toCharArray(), 0, 4);
            this.th.check("bcdefgcdabcd".equals(xw.toString()), "first time something is written to xw, got:" + xw);
            bw.write("abcdefgh".toCharArray(), 1, 7);
            bw.write("abcdefgh".toCharArray(), 1, 7);
            this.th.check("bcdefgcdabcdbcdefghbcdef".equals(xw.toString()), "first time something is written to xw, got:" + xw);
            bw.write("smartmovetests".toCharArray());
            this.th.check("bcdefgcdabcdbcdefghbcdefghsmartmovetests".equals(xw.toString()), "first time something is written to xw, got:" + xw);
            bw.write("smartmovetests".toCharArray());
            this.th.check("bcdefgcdabcdbcdefghbcdefghsmartmovetestssmartmovetests".equals(xw.toString()), "first time something is written to xw, got:" + xw);
            bw.write("abcdefghij".toCharArray());
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw any Exception, got:" + e);
        }
        try {
            char[] ca = null;
            bw.write(ca, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            bw.write("abcde".toCharArray(), 4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            bw.write("abcde".toCharArray(), -4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 3, got:" + e);
        }
        try {
            bw.write("abcde".toCharArray(), 4, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 4, got:" + e);
        }
        try {
            bw.write("abcde".toCharArray(), 6, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 5, got:" + e);
        }
        try {
            this.th.check("bcdefgcdabcdbcdefghbcdefghsmartmovetestssmartmovetests".equals(xw.toString()), "first time something is written to xw, got:" + xw);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 6, got:" + e);
        }
        this.th.checkPoint("write(java.lang.String,int,int)void");
        xw = new CharArrayWriter();
        bw = new BufferedWriter(xw, 12);
        try {
            bw.write("", 0, 0);
            bw.write("abcdefgh", 1, 6);
            bw.write("abcd", 4, 0);
            bw.write("a", 0, 0);
            bw.write("abcd", 2, 2);
            this.th.check("".equals(xw.toString()), "nothing is written to xw yet, got:" + xw);
            bw.write("abcd", 0, 4);
            this.th.check("bcdefgcdabcd".equals(xw.toString()), "first time something is written to xw, got:" + xw);
            bw.write("abcdefgh", 1, 7);
            bw.write("abcdefgh", 1, 7);
            this.th.check("bcdefgcdabcdbcdefghbcdef".equals(xw.toString()), "checking contents of xw -- 1, got:" + xw);
            bw.write("smartmovetests");
            this.th.check("bcdefgcdabcdbcdefghbcdefghsmartmovet".equals(xw.toString()), "checking contents of xw -- 2, got:" + xw);
            bw.write("smartmovetests");
            this.th.check("bcdefgcdabcdbcdefghbcdefghsmartmovetestssmartmov".equals(xw.toString()), "first time something is written to xw, got:" + xw);
            bw.write("abcd");
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw any Exception, got:" + e);
        }
        try {
            String s = null;
            bw.write(s, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            bw.write("abcde", 4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            bw.write("abcde", -4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 3, got:" + e);
        }
        try {
            bw.write("abcde", 4, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 4, got:" + e);
        }
        try {
            bw.write("abcde", 5, 1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 5, got:" + e);
        }
        try {
            this.th.check("bcdefgcdabcdbcdefghbcdefghsmartmovetestssmartmov".equals(xw.toString()), "first time something is written to xw, got:" + xw);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 6, got:" + e);
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        SMExWriter xw = new SMExWriter();
        BufferedWriter bw = new BufferedWriter(xw, 40);
        try {
            bw.close();
            this.th.check(xw.isClosed(), "close must close underlying writers");
            this.th.check(xw.isFlushed() ^ true, "close must close underlying writers--flushed");
            bw.close();
            bw.close();
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            bw.flush();
            this.th.fail("should throw an IOException after writer is closed -- flush");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            bw.newLine();
            this.th.fail("should throw an IOException after writer is closed -- newLine");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            bw.write(97);
            this.th.fail("should throw an IOException after writer is closed -- write 1");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            bw.write("sdsd".toCharArray(), 1, 2);
            this.th.fail("should throw an IOException after writer is closed -- write 2");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            bw.write("agfh", 1, 2);
            this.th.fail("should throw an IOException after writer is closed -- write 3");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
    }

    public void test_flush() {
        this.th.checkPoint("flush()void");
        SMExWriter xw = new SMExWriter();
        BufferedWriter bw = new BufferedWriter(xw, 40);
        try {
            bw.write(97);
            bw.flush();
            this.th.check(xw.isFlushed(), "flush must flush underlying writers");
            this.th.check(xw.toString().equals("a"), "buf must be written before flush");
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
    }

    public void test_lock() {
        this.th.checkPoint("lock(protected)java.lang.Object");
        SMlockBufferedWriter lt = new SMlockBufferedWriter();
        CharArrayWriter wr = new CharArrayWriter();
        BufferedWriter bw = new BufferedWriter(wr, 40);
        int i = this.setupLockThread(lt, wr);
        try {
            bw.write(97);
        }
        catch (Exception e) {
            this.th.fail("should not throw an exception -- 1, got:" + e);
        }
        boolean bl = false;
        if (i + 1 == this.accesed) {
            bl = true;
        }
        this.th.check(bl, "accesed xr before lock was released -- write 1");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedWriter();
        i = this.setupLockThread(lt, wr);
        try {
            bw.write("abcd".toCharArray(), 1, 2);
        }
        catch (Exception e) {
            this.th.fail("should not throw an exception -- 2, got:" + e);
        }
        boolean bl2 = false;
        if (i + 1 == this.accesed) {
            bl2 = true;
        }
        this.th.check(bl2, "accesed xr before lock was released -- write 2");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedWriter();
        i = this.setupLockThread(lt, wr);
        try {
            bw.write("abcd", 1, 2);
        }
        catch (Exception e) {
            this.th.fail("should not throw an exception -- 3, got:" + e);
        }
        boolean bl3 = false;
        if (i + 1 == this.accesed) {
            bl3 = true;
        }
        this.th.check(bl3, "accesed xr before lock was released -- write 3");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedWriter();
        i = this.setupLockThread(lt, wr);
        try {
            bw.newLine();
        }
        catch (Exception e) {
            this.th.fail("should not throw an exception -- 4, got:" + e);
        }
        boolean bl4 = false;
        if (i + 1 == this.accesed) {
            bl4 = true;
        }
        this.th.check(bl4, "accesed xr before lock was released -- newLine");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedWriter();
        i = this.setupLockThread(lt, wr);
        try {
            bw.flush();
        }
        catch (Exception e) {
            this.th.fail("should not throw an exception -- 5, got:" + e);
        }
        boolean bl5 = false;
        if (i + 1 == this.accesed) {
            bl5 = true;
        }
        this.th.check(bl5, "accesed xr before lock was released -- flush");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedWriter();
        i = this.setupLockThread(lt, wr);
        try {
            bw.close();
        }
        catch (Exception e) {
            this.th.fail("should not throw an exception -- 6, got:" + e);
        }
        boolean bl6 = false;
        if (i + 1 == this.accesed) {
            bl6 = true;
        }
        this.th.check(bl6, "accesed xr before lock was released -- close");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void set1() {
        this.f1 = true;
    }

    public void inc() {
        ++this.accesed;
    }

    public int setupLockThread(SMlockBufferedWriter lt, CharArrayWriter xr) {
        this.f1 = false;
        lt.setWriter(xr);
        lt.setTestHarness(this.th);
        lt.setWT(this);
        this.t = new Thread(lt);
        this.t.start();
        while (!this.f1) {
            Thread.yield();
        }
        return this.accesed;
    }

    private final /* synthetic */ void this() {
        this.accesed = 0;
        this.t = null;
        this.f1 = false;
    }

    public SMBufferedWriterTest() {
        this.this();
    }
}

