/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.BufferedReader;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.BufferedReader.SMlockBufferedReader;
import gnu.testlet.wonka.io.Reader.SMExReader;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMBufferedReaderTest
implements Testlet {
    protected TestHarness th;
    protected char[] ca;
    protected int accesed;
    private Thread t;
    private volatile boolean f1;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.BufferedReader");
        this.test_BufferedReader();
        this.test_read();
        this.test_readLine();
        this.test_skip();
        this.test_mark();
        this.test_markSupported();
        this.test_reset();
        this.test_close();
        this.test_ready();
        this.test_lock();
    }

    public void test_BufferedReader() {
        this.th.checkPoint("BufferedReader(java.io.Reader)");
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader br = new BufferedReader(car);
        try {
            new BufferedReader(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        this.th.checkPoint("BufferedReader(java.io.Reader,int)");
        try {
            new BufferedReader(car, -1);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true);
        }
        try {
            new BufferedReader(null, 10);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_read() {
        this.th.checkPoint("read()int");
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader br = new BufferedReader(car, 10);
        try {
            char c = (char)br.read();
            boolean bl = false;
            if (c == 'a') {
                bl = true;
            }
            this.th.check(bl, "checking value char read --1");
            c = (char)br.read();
            boolean bl2 = false;
            if (c == 'b') {
                bl2 = true;
            }
            this.th.check(bl2, "checking value char read --1");
            int i = 0;
            while (i < 10) {
                br.read();
                ++i;
            }
            int j = 0;
            while (br.read() != -1) {
                if (j++ > 99) break;
            }
            boolean bl3 = false;
            if (j < 100) {
                bl3 = true;
            }
            this.th.check(bl3, "EOF is not returning -1");
            this.th.check(br.read(), -1, "expect -1");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
        this.th.checkPoint("read(char[],int,int)int");
        car = new CharArrayReader(this.ca);
        BufferedReader xar = new BufferedReader(car, 40);
        char[] ca1 = new char[15];
        try {
            xar.read(null, 0, 15);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 2");
        }
        try {
            xar.read(ca1, 16, 0);
            this.th.fail("should throw a IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 3");
        }
        try {
            xar.read(ca1, -1, 5);
            this.th.fail("should throw a IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 4");
        }
        try {
            xar.read(ca1, 1, -5);
            this.th.fail("should throw a IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 5");
        }
        try {
            xar.read(ca1, 10, 6);
            this.th.fail("should throw a IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 6");
        }
        car = new CharArrayReader(this.ca);
        br = new BufferedReader(car, 10);
        try {
            int k = br.read(ca1, 0, 10);
            boolean bl = false;
            if (k == 10) {
                bl = true;
            }
            this.th.check(bl, "checking returnvalue --1");
            boolean bl4 = false;
            if (ca1[10] == '\u0000' && ca1[11] == '\u0000' && ca1[12] == '\u0000' && ca1[13] == '\u0000' && ca1[14] == '\u0000') {
                bl4 = true;
            }
            this.th.check(bl4, "checking nulls");
            k = br.read(ca1, 0, 9);
            boolean bl5 = false;
            if (k == 9) {
                bl5 = true;
            }
            this.th.check(bl5, "checking returnvalue --2");
            this.th.check(new String(ca1, 0, 10).equals("cde\nsmartb"), "checking external buffer");
            ca1 = new char[50];
            br.read(ca1, 1, 4);
            this.th.check(new String(ca1, 0, 5), "\u0000move", "checking external buffer");
            k = br.read(ca1, 1, 0);
            boolean bl6 = false;
            if (k == 0) {
                bl6 = true;
            }
            this.th.check(bl6, "checking returnvalue -- 3");
            this.th.check(new String(ca1, 0, 5), "\u0000move", "checking external buffer");
            k = br.read(ca1, 0, 35);
            this.th.check(k, 35, "checking returnvalue -- 4");
            this.th.check(new String(ca1, 0, k), "\n   not empty\r\nmuch more to come...", "check readed bytes -- 1");
            k = br.read(ca1, 0, 9);
            this.th.check(k, 9, "checking returnvalue -- 5");
            this.th.check(new String(ca1, 0, k), "(maybe ! ", "check readed bytes -- 2");
            k = br.read(ca1, 0, 2);
            k = br.read(ca1, 0, 9);
            this.th.check(k, 8, "checking returnvalue -- 6");
            this.th.check(new String(ca1, 0, k), " not)\n\n\n", "check readed bytes -- 3");
            k = br.read(ca1, 0, 2);
            this.th.check(k, -1, "checking returnvalue -- 7, got k:" + k);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
    }

    public void test_readLine() {
        this.th.checkPoint("readLine()java.lang.String");
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader br = new BufferedReader(car);
        try {
            String s = br.readLine();
            this.th.check(s, "abcde", "got:" + s);
            s = br.readLine();
            this.th.check(s, "", "got:" + s);
            s = br.readLine();
            this.th.check(s, "\tabcde", "got:" + s);
            s = br.readLine();
            this.th.check(s, "smartmove", "got:" + s);
            s = br.readLine();
            this.th.check(s, "   not empty", "got:" + s);
            s = br.readLine();
            this.th.check(s, "much more to come...(maybe ! or not)", "got:" + s);
            s = br.readLine();
            this.th.check(s, "", "got:" + s);
            s = br.readLine();
            this.th.check(s, "", "got:" + s);
            s = br.readLine();
            this.th.check(s, null, "should return null, got:" + s);
            car = new CharArrayReader("special things\rhik\noops\n\rtoppie\rg\ntest".toCharArray());
            br = new BufferedReader(car);
            s = br.readLine();
            this.th.check(s, "special things", "got:" + s);
            s = br.readLine();
            this.th.check(s, "hik", "got:" + s);
            s = br.readLine();
            this.th.check(s, "oops", "got:" + s);
            s = br.readLine();
            this.th.check(s, "", "got:" + s);
            s = br.readLine();
            this.th.check(s, "toppie", "got:" + s);
            br.mark(5);
            br.read();
            s = br.readLine();
            this.th.check(s, "", "force fail read() -- got:" + s);
            br.reset();
            br.read(new char[1]);
            s = br.readLine();
            this.th.check(s, "", "force fail read(char[],int,int) -- got:" + s);
            br.reset();
            br.skip(1L);
            s = br.readLine();
            this.th.check(s, "", "force fail skip() -- got:" + s);
            br.reset();
            s = br.readLine();
            this.th.check(s, "g", "got:" + s);
            s = br.readLine();
            this.th.check(s, "test", "got:" + s);
            s = br.readLine();
            this.th.check(s, null, "got:" + s);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
            e.printStackTrace();
        }
    }

    public void test_skip() {
        this.th.checkPoint("skip(long)long");
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader br = new BufferedReader(car, 10);
        try {
            br.skip(-1);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
        try {
            long l = br.skip(10L);
            boolean bl = false;
            if (l == 10L) {
                bl = true;
            }
            this.th.check(bl, "checking return value -- 1");
            l = br.skip(this.ca.length);
            boolean bl2 = false;
            if (l == (long)(this.ca.length - 10)) {
                bl2 = true;
            }
            this.th.check(bl2, "checking return value -- 2");
            l = br.skip(15L);
            boolean bl3 = false;
            if (l == 0L) {
                bl3 = true;
            }
            this.th.check(bl3, "checking return value -- 3");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
    }

    public void test_mark() {
        this.th.checkPoint("mark(int)void");
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader br = new BufferedReader(car, 10);
        try {
            br.read();
            br.mark(1);
            br.skip(5);
            br.mark(-1);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
        try {
            br.skip(5);
            br.mark(15);
            br.skip(11L);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
    }

    public void test_markSupported() {
        this.th.checkPoint("markSupported()boolean");
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader br = new BufferedReader(car, 10);
        try {
            this.th.check(br.markSupported(), "always returns true -- 1");
            br.close();
            this.th.check(br.markSupported(), "always returns true -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
    }

    public void test_reset() {
        char c;
        this.th.checkPoint("reset()void");
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader br = new BufferedReader(car, 10);
        try {
            br.reset();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            br.mark(3);
            br.skip(4);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
        try {
            br.reset();
            this.th.fail("should throw an IOException -- 2");
            c = (char)br.read();
            this.th.debug(c == 'e' ? "didn't throw the IOException" : "reset was executed, got:" + c);
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            br.mark(1);
            br.read();
            br.read();
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
        try {
            br.reset();
            this.th.fail("should throw an IOException -- 3");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            br.mark(3);
            br.read(new char[5], 0, 5);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
        try {
            br.reset();
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        car = new CharArrayReader(this.ca);
        br = new BufferedReader(car, 10);
        try {
            br.mark(5);
            br.skip(4);
            br.reset();
            c = (char)br.read();
            boolean bl = false;
            if (c == 'a') {
                bl = true;
            }
            this.th.check(bl, "make sure we read first char -- 1");
            br.skip(4);
            br.reset();
            c = (char)br.read();
            boolean bl2 = false;
            if (c == 'a') {
                bl2 = true;
            }
            this.th.check(bl2, "make sure we can reset as much as we like -- 1");
            br.skip(4);
            br.reset();
            c = (char)br.read();
            boolean bl3 = false;
            if (c == 'a') {
                bl3 = true;
            }
            this.th.check(bl3, "make sure we can reset as much as we like -- 2");
            br.skip(3);
            br.mark(15);
            br.read(new char[10]);
            br.reset();
            c = (char)br.read();
            boolean bl4 = false;
            if (c == 'e') {
                bl4 = true;
            }
            this.th.check(bl4, "make sure reset works if the buffer needs to grow -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
    }

    public void test_ready() {
        this.th.checkPoint("ready()boolean");
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader br = new BufferedReader(car, 10);
        try {
            this.th.check(br.ready(), "always true -- 1");
            br.read();
            this.th.check(br.ready(), "always true -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
        br = new BufferedReader(new SMExReader(this.ca), 10);
        try {
            this.th.check(br.ready() ^ true, "should be false -- 1");
            br.read();
            this.th.check(br.ready(), "should be true -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception" + e);
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        SMExReader car = new SMExReader(this.ca);
        BufferedReader xar = new BufferedReader(car, 10);
        try {
            xar.close();
            xar.close();
            xar.close();
            xar.close();
            this.th.check(true);
            this.th.check(car.isClosed(), "make sure resources are released -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 1");
        }
        try {
            xar.read();
            this.th.fail("should throw IOException after close -- read() 1");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.read(new char[6], 1, 3);
            this.th.fail("should throw IOException after close -- read() 2");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.readLine();
            this.th.fail("should throw IOException after close -- readLine()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.skip(3);
            this.th.fail("should throw IOException after close -- skip()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.mark(23);
            this.th.fail("should throw IOException after close -- mark()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.reset();
            this.th.fail("should throw IOException after close -- reset()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.ready();
            this.th.fail("should throw IOException after close -- ready()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
    }

    public void test_lock() {
        this.th.checkPoint("lock(protected)java.lang.Object");
        SMlockBufferedReader lt = new SMlockBufferedReader();
        CharArrayReader car = new CharArrayReader(this.ca);
        BufferedReader xr = new BufferedReader(car, 100);
        int i = this.setupLockThread(lt, car);
        try {
            xr.mark(2);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = false;
        if (i + 1 == this.accesed) {
            bl = true;
        }
        this.th.check(bl, "accesed xr before lock was released -- mark");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedReader();
        i = this.setupLockThread(lt, car);
        try {
            xr.reset();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl2 = false;
        if (i + 1 == this.accesed) {
            bl2 = true;
        }
        this.th.check(bl2, "accesed xr before lock was released -- reset");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedReader();
        i = this.setupLockThread(lt, car);
        try {
            xr.read();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl3 = false;
        if (i + 1 == this.accesed) {
            bl3 = true;
        }
        this.th.check(bl3, "accesed xr before lock was released -- read()");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedReader();
        i = this.setupLockThread(lt, car);
        try {
            xr.read(new char[2]);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl4 = false;
        if (i + 1 == this.accesed) {
            bl4 = true;
        }
        this.th.check(bl4, "accesed xr before lock was released -- read(char[])");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedReader();
        i = this.setupLockThread(lt, car);
        try {
            xr.read(new char[2], 0, 1);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl5 = false;
        if (i + 1 == this.accesed) {
            bl5 = true;
        }
        this.th.check(bl5, "accesed xr before lock was released -- read(char[],int,int)");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedReader();
        i = this.setupLockThread(lt, car);
        try {
            xr.readLine();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl6 = false;
        if (i + 1 == this.accesed) {
            bl6 = true;
        }
        this.th.check(bl6, "accesed xr before lock was released -- readLine()");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedReader();
        i = this.setupLockThread(lt, car);
        try {
            xr.ready();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl7 = false;
        if (i + 1 == this.accesed) {
            bl7 = true;
        }
        this.th.check(bl7, "accesed xr before lock was released -- ready");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedReader();
        i = this.setupLockThread(lt, car);
        try {
            xr.skip(30L);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl8 = false;
        if (i + 1 == this.accesed) {
            bl8 = true;
        }
        this.th.check(bl8, "accesed xr before lock was released -- skip");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockBufferedReader();
        i = this.setupLockThread(lt, car);
        try {
            xr.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl9 = false;
        if (i + 1 == this.accesed) {
            bl9 = true;
        }
        this.th.check(bl9, "accesed xr before lock was released -- close");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int setupLockThread(SMlockBufferedReader lt, CharArrayReader car) {
        this.f1 = false;
        lt.setXReader(car);
        lt.setTestHarness(this.th);
        lt.setRT(this);
        this.t = new Thread(lt);
        this.t.start();
        while (!this.f1) {
            Thread.yield();
        }
        return this.accesed;
    }

    public void inc() {
        ++this.accesed;
    }

    public void set1() {
        this.f1 = true;
    }

    private final /* synthetic */ void this() {
        this.ca = "abcde\n\n\tabcde\nsmartmove\n   not empty\r\nmuch more to come...(maybe ! or not)\n\n\n".toCharArray();
        this.accesed = 0;
        this.t = null;
        this.f1 = false;
    }

    public SMBufferedReaderTest() {
        this.this();
    }
}

