/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.BufferedInputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.BufferedInputStream.SMExBufferedInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMBufferedInputStreamTest
implements Testlet {
    protected TestHarness th;
    protected byte[] b;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.BufferedInputStream");
        this.test_BufferedInputStream();
        this.test_read();
        this.test_skip();
        this.test_mark();
        this.test_markSupported();
        this.test_reset();
        this.test_available();
        this.test_close();
    }

    public void test_BufferedInputStream() {
        this.th.checkPoint("BufferedInputStream(java.io.InputStream)");
        ByteArrayInputStream bis = new ByteArrayInputStream(this.b);
        SMExBufferedInputStream xbuf = new SMExBufferedInputStream(bis);
        boolean bl = false;
        if (xbuf.getbuf().length == 2048) {
            bl = true;
        }
        this.th.check(bl, "checking default size");
        boolean bl2 = false;
        if (xbuf.getcount() == 0) {
            bl2 = true;
        }
        this.th.check(bl2, "checking initial count");
        this.th.checkPoint("BufferedInputStream(java.io.InputStream,int)");
        xbuf = new SMExBufferedInputStream(bis, 30);
        boolean bl3 = false;
        if (xbuf.getbuf().length == 30) {
            bl3 = true;
        }
        this.th.check(bl3, "checking default size");
        boolean bl4 = false;
        if (xbuf.getcount() == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "checking initial count");
        try {
            new BufferedInputStream(bis, 0);
            this.th.fail("should throw a IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        try {
            new BufferedInputStream(bis, -1);
            this.th.fail("should throw a IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
    }

    public void test_read() {
        int i;
        this.th.checkPoint("read()int");
        ByteArrayInputStream bis = new ByteArrayInputStream(this.b);
        SMExBufferedInputStream xbuf = new SMExBufferedInputStream(bis, 6);
        try {
            char c = (char)xbuf.read();
            this.th.check(xbuf.toString().equals("smartm"), "checking buffer -- 1");
            this.th.check(xbuf.getcount(), 6, "checking count -- 1");
            this.th.check(xbuf.getpos(), 1, "checking pos -- 1");
            this.th.check(c, 115, "checking return value -- 1");
            this.checkPos(bis, 'o', "checking pos of in-stream -- 1");
            xbuf.read();
            xbuf.read();
            xbuf.read();
            xbuf.read();
            c = (char)xbuf.read();
            this.th.check(xbuf.toString(), "smartm", "checking buffer -- 2");
            this.th.check(xbuf.getcount(), 6, "checking count -- 2");
            this.th.check(xbuf.getpos(), 6, "checking pos -- 2");
            this.th.check(c, 109, "checking return value -- 2");
            this.checkPos(bis, 'o', "checking pos of in-stream -- 2");
            c = (char)xbuf.read();
            this.th.check(xbuf.toString(), "ove ru", "checking buffer -- 3");
            this.th.check(xbuf.getcount(), 6, "checking count -- 3");
            this.th.check(xbuf.getpos(), 1, "checking pos -- 3");
            boolean bl = false;
            if (c == 'o') {
                bl = true;
            }
            this.th.check(bl, "checking return value -- 3");
            this.checkPos(bis, 'l', "checking pos of in-stream -- 3");
            long l = xbuf.skip(this.b.length);
            while (l > 0L) {
                l = xbuf.skip(this.b.length);
            }
            int i2 = xbuf.read();
            this.th.check(i2, -1, "checking return value -- 4");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
        this.th.checkPoint("read(byte[],int,int)int");
        byte[] ba = new byte[10];
        bis = new ByteArrayInputStream(this.b);
        xbuf = new SMExBufferedInputStream(bis, 6);
        try {
            i = xbuf.read(ba, 0, 10);
            String s = new String(ba);
            this.th.check(s, "smartmove ", "checking readed bytes -- 1, got:" + s);
            this.th.check(xbuf.toString(), "", "checking buffer -- 1, got:" + xbuf.toString());
            this.th.check(xbuf.getcount(), 0, "checking count -- 1, got:" + xbuf.getcount());
            this.th.check(xbuf.getpos(), 0, "checking pos -- 1, got:" + xbuf.getpos());
            this.th.check(i, 10, "checking return value -- 1, got:" + i);
            this.checkPos(bis, 'r', "checking pos of in-stream -- 1");
            i = xbuf.read(ba, 5, 5);
            s = new String(ba);
            this.th.check(s, "smartrules", "checking readed bytes -- 2, got:" + s);
            this.th.check(xbuf.toString(), "rules!", "checking buffer -- 2, got:" + xbuf.toString());
            this.th.check(xbuf.getcount(), 6, "checking count -- 2, got:" + xbuf.getcount());
            this.th.check(xbuf.getpos(), 5, "checking pos -- 2, got:" + xbuf.getpos());
            this.th.check(i, 5, "checking return value -- 2, got:" + i);
            this.checkPos(bis, '\n', "checking pos of in-stream -- 2");
            i = xbuf.read(ba, 5, 5);
            s = new String(ba);
            this.th.check(s.equals("smart!\nWe "), "checking readed bytes -- 3, got:" + s);
            this.th.check(xbuf.toString().equals("\nWe ar"), "checking buffer -- 3, got:" + xbuf.toString());
            boolean bl = false;
            if (xbuf.getcount() == 6) {
                bl = true;
            }
            this.th.check(bl, "checking count -- 3, got:" + xbuf.getcount());
            boolean bl2 = false;
            if (xbuf.getpos() == 4) {
                bl2 = true;
            }
            this.th.check(bl2, "checking pos -- 3, got:" + xbuf.getpos());
            boolean bl3 = false;
            if (i == 5) {
                bl3 = true;
            }
            this.th.check(bl3, "checking return value -- 3, got:" + i);
            this.checkPos(bis, 'e', "checking pos of in-stream -- 3");
            i = xbuf.read(ba, 3, 7);
            s = new String(ba);
            this.th.check(s.equals("smaare tes"), "checking readed bytes -- 4, got:" + s);
            this.th.check(xbuf.toString().equals("e test"), "checking buffer -- 4, got:" + xbuf.toString());
            boolean bl4 = false;
            if (xbuf.getcount() == 6) {
                bl4 = true;
            }
            this.th.check(bl4, "checking count -- 4, got:" + xbuf.getcount());
            boolean bl5 = false;
            if (xbuf.getpos() == 5) {
                bl5 = true;
            }
            this.th.check(bl5, "checking pos -- 4, got:" + xbuf.getpos());
            boolean bl6 = false;
            if (i == 7) {
                bl6 = true;
            }
            this.th.check(bl6, "checking return value -- 4, got:" + i);
            this.checkPos(bis, 'i', "checking pos of in-stream -- 4");
            i = xbuf.read(ba, 3, 7);
            s = new String(ba);
            this.th.check(s.equals("smating th"), "checking readed bytes -- 5, got:" + s);
            boolean bl7 = false;
            if (xbuf.getcount() == xbuf.getpos()) {
                bl7 = true;
            }
            this.th.check(bl7, "checking buffer is empty -- 5");
            boolean bl8 = false;
            if (i == 7) {
                bl8 = true;
            }
            this.th.check(bl8, "checking return value -- 5, got:" + i);
            this.checkPos(bis, 'e', "checking pos of in-stream -- 5");
            i = xbuf.read(ba, 0, 10);
            s = new String(ba);
            this.th.check(s.equals("e Buffered"), "checking readed bytes -- 6, got:" + s);
            boolean bl9 = false;
            if (xbuf.getcount() == xbuf.getpos()) {
                bl9 = true;
            }
            this.th.check(bl9, "checking buffer is empty -- 6");
            boolean bl10 = false;
            if (i == 10) {
                bl10 = true;
            }
            this.th.check(bl10, "checking return value -- 6, got:" + i);
            i = xbuf.read(ba, 0, 10);
            s = new String(ba);
            this.th.check(s.equals("InputStrea"), "checking readed bytes -- 7, got:" + s);
            boolean bl11 = false;
            if (xbuf.getcount() == xbuf.getpos()) {
                bl11 = true;
            }
            this.th.check(bl11, "checking buffer is empty -- 7");
            boolean bl12 = false;
            if (i == 10) {
                bl12 = true;
            }
            this.th.check(bl12, "checking return value -- 7, got:" + i);
            i = xbuf.read(ba, 6, 4);
            s = new String(ba);
            this.th.check(s.equals("InputSm cl"), "checking readed bytes -- 8, got:" + s);
            this.th.check(xbuf.toString().equals("m clas"), "checking buffer -- 8, got:" + xbuf.toString());
            boolean bl13 = false;
            if (xbuf.getcount() == 6) {
                bl13 = true;
            }
            this.th.check(bl13, "checking count -- 8, got:" + xbuf.getcount());
            boolean bl14 = false;
            if (xbuf.getpos() == 4) {
                bl14 = true;
            }
            this.th.check(bl14, "checking pos -- 8, got:" + xbuf.getpos());
            boolean bl15 = false;
            if (i == 4) {
                bl15 = true;
            }
            this.th.check(bl15, "checking return value -- 8, got:" + i);
            i = xbuf.read(ba, 5, 5);
            s = new String(ba);
            this.th.check(s.equals("Inputasscl"), "checking readed bytes -- 9, got:" + s);
            boolean bl16 = false;
            if (i == 3) {
                bl16 = true;
            }
            this.th.check(bl16, "checking return value -- 9, got:" + i);
            i = xbuf.read(ba, 5, 5);
            s = new String(ba);
            this.th.check(s.equals("Inputasscl"), "checking readed bytes -- 10, got:" + s);
            boolean bl17 = false;
            if (xbuf.getcount() == xbuf.getpos()) {
                bl17 = true;
            }
            this.th.check(bl17, "checking buffer is empty -- 10");
            boolean bl18 = false;
            if (i == -1) {
                bl18 = true;
            }
            this.th.check(bl18, "checking return value -- 10, got:" + i);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
            e.printStackTrace();
        }
        try {
            xbuf.read(null, 1, 2);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 2, got:" + e);
        }
        try {
            xbuf.read(ba, -1, 2);
            this.th.fail("should throw a IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 3, got:" + e);
        }
        try {
            xbuf.read(ba, 5, -2);
            this.th.fail("should throw a IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 4, got:" + e);
        }
        try {
            xbuf.read(ba, 11, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 5, got:" + e);
        }
        try {
            xbuf.read(ba, 5, 6);
            this.th.fail("should throw a IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 6, got:" + e);
        }
        this.th.checkPoint("read(byte[],int,int)int");
        ba = new byte[5];
        bis = new ByteArrayInputStream(this.b);
        xbuf = new SMExBufferedInputStream(bis, 6);
        try {
            i = xbuf.read(ba);
            String s = new String(ba);
            this.th.check(s.equals("smart"), "checking readed bytes -- 1, got:" + s);
            this.th.check(xbuf.toString().equals("smartm"), "checking buffer -- 1, got:" + xbuf.toString());
            boolean bl = false;
            if (xbuf.getcount() == 6) {
                bl = true;
            }
            this.th.check(bl, "checking count -- 1, got:" + xbuf.getcount());
            boolean bl19 = false;
            if (xbuf.getpos() == 5) {
                bl19 = true;
            }
            this.th.check(bl19, "checking pos -- 1, got:" + xbuf.getpos());
            boolean bl20 = false;
            if (i == 5) {
                bl20 = true;
            }
            this.th.check(bl20, "checking return value -- 1, got:" + i);
            this.checkPos(bis, 'o', "checking pos of in-stream -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
        bis = new ByteArrayInputStream(this.b);
        xbuf = new SMExBufferedInputStream(bis, 6);
        try {
            ba = new byte[10];
            i = xbuf.read(ba, 0, 1);
            String s = new String(ba);
            this.th.check(s, "smartmove ", "checking readed bytes -- 1, got:" + s);
            this.th.check(i += xbuf.read(ba, 1, 9), 10, "checking return value -- 1, got:" + i);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 3, got:" + e);
            e.printStackTrace();
        }
    }

    public void checkPos(ByteArrayInputStream bis, char b, String s) {
        try {
            bis.mark(1);
            char r = (char)bis.read();
            bis.reset();
            this.th.check(r, b, s);
        }
        catch (Exception e) {
            this.th.debug("checkPos failed, got:" + e);
        }
    }

    public void test_skip() {
        this.th.checkPoint("skip(long)long");
        ByteArrayInputStream bis = new ByteArrayInputStream(this.b);
        SMExBufferedInputStream xbuf = new SMExBufferedInputStream(bis, 6);
        try {
            xbuf.read();
            long l = xbuf.skip(4);
            this.th.check(xbuf.getpos(), 5, "checking pos -- 1, got:" + xbuf.getcount());
            this.th.check(xbuf.toString(), "smartm", "checking buffer -- 1, got:" + xbuf.toString());
            this.th.check(l, (long)4, "checking return value -- 1, got:" + l);
            this.checkPos(bis, 'o', "checking pos of in-stream -- 1");
            l = xbuf.skip(4);
            this.th.check(xbuf.getpos(), 6, "checking pos -- 2, got:" + xbuf.getcount());
            this.th.check(xbuf.toString(), "smartm", "checking buffer -- 2, got:" + xbuf.toString());
            this.th.check(l, 1L, "checking return value -- 2");
            this.checkPos(bis, 'o', "checking pos of in-stream -- 2");
            l = xbuf.skip(10L);
            this.th.check(xbuf.getcount(), xbuf.getpos(), "checking buffer is empty -- 3");
            this.th.check(l, 10L, "checking return value -- 3, got:" + l);
            this.checkPos(bis, '\n', "checking pos of in-stream -- 3");
            l = xbuf.skip(-10L);
            this.th.check(l, 0L, "checking return value -- 4, got:" + l);
            this.checkPos(bis, '\n', "checking pos of in-stream -- 4");
            l = xbuf.skip(0L);
            this.th.check(l, 0L, "checking return value -- 5, got:" + l);
            this.checkPos(bis, '\n', "checking pos of in-stream -- 5");
            l = xbuf.skip(this.b.length);
            this.th.check(l, (long)this.b.length - 16L, "checking return value -- 6, got:" + l);
            l = xbuf.skip(10L);
            this.th.check(l, 0L, "checking return value -- 6, got:" + l);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
    }

    public void test_mark() {
        this.th.checkPoint("mark(int)void");
        ByteArrayInputStream bis = new ByteArrayInputStream(this.b);
        SMExBufferedInputStream xbuf = new SMExBufferedInputStream(bis, 6);
        byte[] ba = new byte[8];
        try {
            xbuf.read();
            xbuf.mark(1);
            boolean bl = false;
            if (xbuf.getmarkpos() == 1) {
                bl = true;
            }
            this.th.check(bl, "checking markpos -- 1, got:" + xbuf.getmarkpos());
            boolean bl2 = false;
            if (xbuf.getmarklimit() == 1) {
                bl2 = true;
            }
            this.th.check(bl2, "checking marklimit -- 1, got:" + xbuf.getmarklimit());
            this.th.check(xbuf.getpos(), 1, "checking position -- 4");
            xbuf.read();
            xbuf.read();
            this.th.check(xbuf.getpos(), 3, "checking position -- 2");
            this.th.check(xbuf.getmarkpos(), 1, "checking markpos -- 2, got:" + xbuf.getmarkpos());
            this.th.check(xbuf.getmarklimit(), 1, "checking marklimit -- 2, got:" + xbuf.getmarklimit());
            xbuf.mark(10);
            boolean bl3 = false;
            if (xbuf.getmarkpos() == 3) {
                bl3 = true;
            }
            this.th.check(bl3, "checking markpos -- 3, got:" + xbuf.getmarkpos());
            boolean bl4 = false;
            if (xbuf.getmarklimit() == 10) {
                bl4 = true;
            }
            this.th.check(bl4, "checking marklimit -- 3, got:" + xbuf.getmarklimit());
            xbuf.read(ba, 0, 5);
            this.th.check(xbuf.getmarkpos(), 0, "checking markpos -- 4, got:" + xbuf.getmarkpos());
            this.th.check(xbuf.getmarklimit(), 10, "checking marklimit -- 4, got:" + xbuf.getmarklimit());
            this.th.check(xbuf.getbuf().length, 6, "checking buffer length -- 4, got:" + xbuf.getbuf().length);
            this.th.check(xbuf.getpos(), 5, "checking pos -- 4, got:" + xbuf.getpos());
            this.th.check(xbuf.getcount(), 6, "checking count -- 4");
            xbuf.read(ba, 0, 6);
            boolean bl5 = false;
            if (xbuf.getmarkpos() < 0) {
                bl5 = true;
            }
            this.th.check(bl5, "checking markpos -- 4bis, got:" + xbuf.getmarkpos());
            this.th.check(xbuf.getmarklimit(), 10, "checking marklimit -- 4bis, got:" + xbuf.getmarklimit());
            this.th.check(xbuf.getbuf().length, 10, "checking buffer length -- 4bis, got:" + xbuf.getbuf().length);
            this.th.check(xbuf.getpos(), 1, "checking position -- 4bis");
            this.th.check(xbuf.getcount(), 10, "checking count -- 4bis");
            xbuf.mark(12);
            this.th.check(xbuf.getmarkpos(), 1, "checking markpos -- 5, got:" + xbuf.getmarkpos());
            this.th.check(xbuf.getmarklimit(), 12, "checking marklimit -- 5, got:" + xbuf.getmarklimit());
            xbuf.skip(13L);
            this.th.check(xbuf.getmarkpos(), 1, "checking markpos -- 6, got:" + xbuf.getmarkpos());
            this.th.check(xbuf.getmarklimit(), 12, "checking marklimit -- 6, got:" + xbuf.getmarklimit());
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
            e.printStackTrace();
        }
        xbuf.mark(-2);
        this.th.check(xbuf.getmarklimit(), -2, "checking marklimit -- 7, got:" + xbuf.getmarklimit());
    }

    public void test_markSupported() {
        this.th.checkPoint("markSupported()boolean");
        ByteArrayInputStream bis = new ByteArrayInputStream(this.b);
        SMExBufferedInputStream xbuf = new SMExBufferedInputStream(bis, 6);
        this.th.check(xbuf.markSupported(), "should always be true");
    }

    public void test_reset() {
        this.th.checkPoint("reset()void");
        ByteArrayInputStream bis = new ByteArrayInputStream(this.b);
        SMExBufferedInputStream xbuf = new SMExBufferedInputStream(bis, 6);
        byte[] ba = new byte[8];
        try {
            xbuf.reset();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ie) {
            this.th.check(true);
        }
        try {
            xbuf.read();
            xbuf.mark(1);
            xbuf.read();
            xbuf.reset();
            boolean bl = false;
            if (xbuf.getmarkpos() == 1) {
                bl = true;
            }
            this.th.check(bl, "checking markpos -- 1, got:" + xbuf.getmarkpos());
            boolean bl2 = false;
            if (xbuf.getmarklimit() == 1) {
                bl2 = true;
            }
            this.th.check(bl2, "checking marklimit -- 1, got:" + xbuf.getmarklimit());
            boolean bl3 = false;
            if (xbuf.getpos() == 1) {
                bl3 = true;
            }
            this.th.check(bl3, "checking pos -- 1, got:" + xbuf.getpos());
            xbuf.read();
            xbuf.read();
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
        try {
            xbuf.reset();
            this.th.fail("should throw an IOException -- 2 --> " + (char)xbuf.read());
        }
        catch (IOException ie) {
            this.th.check(true);
        }
        try {
            xbuf.mark(10);
            xbuf.read(ba, 0, 5);
            xbuf.reset();
            this.th.check(xbuf.getpos(), 0, "checking pos -- 2, got:" + xbuf.getpos());
            xbuf.read(ba, 0, 5);
            xbuf.read(ba, 0, 6);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 2, got:" + e);
        }
        try {
            xbuf.reset();
            this.th.fail("should throw an IOException -- 3");
        }
        catch (IOException ie) {
            this.th.check(true);
        }
        try {
            bis = new ByteArrayInputStream(this.b);
            xbuf = new SMExBufferedInputStream(bis, 5);
            xbuf.mark(12);
            xbuf.skip(6L);
            xbuf.reset();
            this.th.check(xbuf.read(), 115);
            boolean bl = false;
            if (xbuf.getpos() == 1) {
                bl = true;
            }
            this.th.check(bl, "checking pos -- 3, got:" + xbuf.getpos());
            xbuf.skip(13L);
            xbuf.skip(13L);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 3, got:" + e);
        }
        try {
            xbuf.reset();
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ie) {
            this.th.check(true);
        }
    }

    public void test_available() {
        this.th.checkPoint("available()int");
        ByteArrayInputStream bis = new ByteArrayInputStream(this.b);
        SMExBufferedInputStream xbuf = new SMExBufferedInputStream(bis, 6);
        byte[] ba = new byte[8];
        try {
            boolean bl = false;
            if (xbuf.available() == this.b.length) {
                bl = true;
            }
            this.th.check(bl, "checking returnvalue -- 1, got:" + xbuf.available());
            xbuf.read(ba, 0, 5);
            boolean bl2 = false;
            if (xbuf.available() == this.b.length - 5) {
                bl2 = true;
            }
            this.th.check(bl2, "checking returnvalue -- 2, got:" + xbuf.available());
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        ByteArrayInputStream bis = new ByteArrayInputStream(this.b);
        SMExBufferedInputStream xbuf1 = new SMExBufferedInputStream(bis, 60);
        SMExBufferedInputStream xbuf = new SMExBufferedInputStream(xbuf1, 6);
        byte[] ba = new byte[8];
        try {
            xbuf.read(ba, 0, 5);
            xbuf.close();
            boolean bl = false;
            if (xbuf.getbuf() == null) {
                bl = true;
            }
            this.th.check(bl, "resources should be released after close");
            xbuf.close();
            xbuf.close();
            xbuf.close();
            boolean bl2 = false;
            if (xbuf1.getTC() == 1) {
                bl2 = true;
            }
            this.th.check(bl2, "close does nothing after the first time");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
        try {
            xbuf.reset();
            this.th.fail("should throw an IOException -- reset");
        }
        catch (IOException ie) {
            this.th.check(true);
        }
        try {
            xbuf.read();
            this.th.fail("should throw an IOException -- read 1");
        }
        catch (IOException ie) {
            this.th.check(true);
        }
        try {
            xbuf.read(new byte[3], 1, 1);
            this.th.fail("should throw an IOException -- read 2");
        }
        catch (IOException ie) {
            this.th.check(true);
        }
        try {
            xbuf.skip(6L);
            this.th.fail("should throw an IOException -- skip");
        }
        catch (IOException ie) {
            this.th.check(true);
        }
        try {
            xbuf.available();
            this.th.fail("should throw an IOException -- available");
        }
        catch (IOException ie) {
            this.th.check(true);
        }
    }

    private final /* synthetic */ void this() {
        this.b = "smartmove rules!\nWe are testing the BufferedInputStream class".getBytes();
    }

    public SMBufferedInputStreamTest() {
        this.this();
    }
}

