/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.awt.Image;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class ImageTest
implements Testlet {
    TestHarness harness;

    void testDimension() {
        this.harness.checkPoint("getWidth(java.awt.image.ImageObserver)int");
        int w = 400;
        int h = 234;
        Panel pa = new Panel();
        try {
            Image im = pa.createImage(w, h);
            this.harness.check(im.getWidth(null), w, "getWidth(java.awt.image.ImageObserver)int");
            this.harness.checkPoint("getHeight(java.awt.image.ImageObserver)int");
            this.harness.check(im.getHeight(null), h, "getHeight(java.awt.image.ImageObserver)int");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void testGraphics() {
        this.harness.checkPoint("getGraphics()java.awt.Graphics");
        try {
            int w = 400;
            int h = 234;
            Panel pa = new Panel();
            Image im = pa.createImage(w, h);
            this.harness.check(im != null, "createImage(int, int)java.awt.Image");
            Graphics g1 = null;
            try {
                g1 = im.getGraphics();
                this.harness.check(g1 != null, "getGraphics()java.awt.Graphics");
                this.harness.check("test OK".equals("test OK"), "equals(java.lang.String)boolean");
            }
            catch (ClassCastException e) {
                this.harness.check("test OK".equals(null), "equals(java.lang.String)boolean");
            }
            this.harness.check(g1.getFont(), Component.DEFAULT_FONT, "getFont()java.awt.Font");
            this.harness.check(g1.getColor(), Color.black, "getColor()java.awt.Color");
            pa.setFont(new Font("courR20", 0, 20));
            pa.setForeground(Color.orange);
            Graphics g2 = im.getGraphics();
            this.harness.check(g2.getFont(), new Font("courR20", 0, 20), "getFont()java.awt.Font");
            this.harness.check(g2.getColor(), Color.orange, "createColor()java.awt.Color");
            Graphics g3 = im.getGraphics();
            g3.setFont(new Font("helvB25", 0, 25));
            g3.setColor(Color.red);
            this.harness.check(g3.getFont(), new Font("helvB25", 0, 25), "getFont()java.awt.Font");
            this.harness.check(g3.getColor(), Color.red, "createColor()java.awt.Color");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void test(TestHarness newharness) {
        this.harness = newharness;
        this.harness.setclass("java.awt.Image");
        this.testDimension();
    }
}

