/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_A;
import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_B;
import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_C;
import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TEST_ObjectOutputStream_Instanceof
extends Mv_Assert {
    private SAMPLE_ObjectStream_B root = SAMPLE_SerialObject.getRootObject();
    private SAMPLE_ObjectStream_B b;
    private Object object;
    private byte[] output;
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private ByteArrayOutputStream baos;
    private ObjectOutputStream oos;

    public TEST_ObjectOutputStream_Instanceof() {
        this.openOutputStream();
        try {
            this.oos.writeObject(this.root);
            this.oos.flush();
        }
        catch (IOException ioe) {
            this.closeOutputStream();
            TEST_ObjectOutputStream_Instanceof.fail(ioe.toString());
        }
        this.output = this.baos.toByteArray();
        this.closeOutputStream();
        this.openInputStream(this.output);
        try {
            this.object = this.ois.readObject();
        }
        catch (Exception e) {
            TEST_ObjectOutputStream_Instanceof.fail(e.toString());
        }
        this.closeInputStream();
    }

    public void setUp() {
        this.b = (SAMPLE_ObjectStream_B)this.object;
    }

    public void tearDown() {
    }

    private void closeOutputStream() {
        try {
            this.baos.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Instanceof.fail(ioe.toString());
        }
    }

    private void openOutputStream() {
        try {
            this.baos = new ByteArrayOutputStream();
            this.oos = new ObjectOutputStream(this.baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            TEST_ObjectOutputStream_Instanceof.fail("unexpected io exception occurred while setting up");
        }
    }

    public void closeInputStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Instanceof.fail("IO Exception while closing input stream");
        }
    }

    private void openInputStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Instanceof.fail("openStream> " + ioe.toString());
            return;
        }
    }

    protected void runTest() {
        TEST_ObjectOutputStream_Instanceof.assert("read object not an instance of original", this.object instanceof SAMPLE_ObjectStream_B);
        TEST_ObjectOutputStream_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_B", this.b.getLeft() instanceof SAMPLE_ObjectStream_B);
        TEST_ObjectOutputStream_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_C", this.b.getRight() instanceof SAMPLE_ObjectStream_C);
        TEST_ObjectOutputStream_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_A", this.b.getLeft().getLeft() instanceof SAMPLE_ObjectStream_A);
        TEST_ObjectOutputStream_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_C", this.b.getLeft().getRight() instanceof SAMPLE_ObjectStream_C);
    }
}

