/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_OuterClass;
import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TEST_ObjectOutputStream_InnerClass_Instanceof
extends Mv_Assert {
    private SAMPLE_ObjectStream_OuterClass outerClassAfter;
    private SAMPLE_ObjectStream_OuterClass outerClass;
    private Object object;
    private byte[] output;
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private ByteArrayOutputStream baos;
    private ObjectOutputStream oos;

    public void setUp() {
        this.outerClass = SAMPLE_SerialObject.getOuterClass();
        this.openOutputStream();
        try {
            this.oos.writeObject(this.outerClass);
            this.oos.flush();
        }
        catch (IOException ioe) {
            this.closeOutputStream();
            TEST_ObjectOutputStream_InnerClass_Instanceof.fail(ioe.toString());
        }
        this.output = this.baos.toByteArray();
        this.closeOutputStream();
        this.openInputStream(this.output);
        try {
            this.object = this.ois.readObject();
        }
        catch (Exception e) {
            TEST_ObjectOutputStream_InnerClass_Instanceof.fail(e.toString());
        }
    }

    public void tearDown() {
        this.closeInputStream();
    }

    private void closeOutputStream() {
        try {
            this.baos.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_InnerClass_Instanceof.fail(ioe.toString());
        }
    }

    private void openOutputStream() {
        try {
            this.baos = new ByteArrayOutputStream();
            this.oos = new ObjectOutputStream(this.baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            TEST_ObjectOutputStream_InnerClass_Instanceof.fail("unexpected io exception occurred while setting up");
        }
    }

    public void closeInputStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_InnerClass_Instanceof.fail("IO Exception while closing input stream");
        }
    }

    private void openInputStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_InnerClass_Instanceof.fail("openStream> " + ioe.toString());
            return;
        }
    }

    protected void runTest() {
        TEST_ObjectOutputStream_InnerClass_Instanceof.assert("read object not an instance of original", this.object instanceof SAMPLE_ObjectStream_OuterClass);
        this.outerClassAfter = (SAMPLE_ObjectStream_OuterClass)this.object;
        TEST_ObjectOutputStream_InnerClass_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_OuterClass.PublicInnerClass", this.outerClassAfter.puic instanceof SAMPLE_ObjectStream_OuterClass.PublicInnerClass);
        this.outerClassAfter = (SAMPLE_ObjectStream_OuterClass)this.object;
        TEST_ObjectOutputStream_InnerClass_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_OuterClass.PrivateInnerClass", this.outerClassAfter.isInstanceOfPrivateInnerClass(this.outerClassAfter.pric));
    }
}

